/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.SeparationCyclesManagement;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.task.SeparateSecondCycle$callable$separateByStudentNumberProcedure;
import org.fenixedu.academic.task.SeparateSecondCycle$callable$separateStudentProcedure;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Task(englishTitle="SeparateSecondCycle", readOnly=true)
public class SeparateSecondCycle
extends CronTask {
    public static final Advice advice$separateStudentProcedure = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$separateByStudentNumberProcedure = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public void runTask() {
        I18N.setLocale((Locale)new Locale("pt", "PT"));
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlans()) {
            this.getLogger().info("Processing DCP: " + degreeCurricularPlan.getName());
            for (StudentCurricularPlan studentCurricularPlan : degreeCurricularPlan.getStudentCurricularPlansSet()) {
                if (studentCurricularPlan.isActive() && this.canSeparate(studentCurricularPlan)) {
                    if (this.studentAlreadyHasNewRegistration(studentCurricularPlan) && this.canRepeateSeparate(studentCurricularPlan)) {
                        this.getLogger().info("1 - Repeating separate for: " + studentCurricularPlan.getRegistration().getStudent().getNumber());
                        try {
                            this.separateByStudentNumberProcedure(studentCurricularPlan.getRegistration().getStudent(), studentCurricularPlan.getDegreeCurricularPlan());
                        }
                        catch (Exception e) {
                            this.getLogger().error("Repeating separate student", (Throwable)e);
                        }
                        continue;
                    }
                    this.getLogger().info("Separating Student: " + studentCurricularPlan.getRegistration().getStudent().getNumber());
                    try {
                        this.separateStudentProcedure(studentCurricularPlan);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Separating students with rules", (Throwable)e);
                    }
                    continue;
                }
                if (!studentCurricularPlan.hasRegistration() || !studentCurricularPlan.getRegistration().isConcluded() || !this.canRepeateSeparate(studentCurricularPlan)) continue;
                this.getLogger().info("2 - Repeating separate for: " + studentCurricularPlan.getRegistration().getStudent().getNumber());
                try {
                    this.separateByStudentNumberProcedure(studentCurricularPlan.getRegistration().getStudent(), studentCurricularPlan.getDegreeCurricularPlan());
                }
                catch (Exception e) {
                    this.getLogger().error("Repeating separate student", (Throwable)e);
                }
            }
        }
    }

    private boolean studentAlreadyHasNewRegistration(StudentCurricularPlan studentCurricularPlan) {
        Student student = studentCurricularPlan.getRegistration().getStudent();
        return student.hasRegistrationFor(studentCurricularPlan.getSecondCycle().getDegreeCurricularPlanOfDegreeModule());
    }

    private boolean canSeparate(StudentCurricularPlan studentCurricularPlan) {
        return this.hasFirstCycleConcluded(studentCurricularPlan) && this.hasExternalSecondCycle(studentCurricularPlan);
    }

    private boolean canRepeateSeparate(StudentCurricularPlan studentCurricularPlan) {
        return this.hasFirstCycleConcluded(studentCurricularPlan) && this.hasExternalSecondCycleAndNewRegistration(studentCurricularPlan);
    }

    private List<DegreeCurricularPlan> getDegreeCurricularPlans() {
        return DegreeCurricularPlan.readByDegreeTypesAndState(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree), DegreeCurricularPlanState.ACTIVE);
    }

    private boolean hasFirstCycleConcluded(StudentCurricularPlan studentCurricularPlan) {
        CycleCurriculumGroup firstCycle = studentCurricularPlan.getFirstCycle();
        return firstCycle != null && firstCycle.isConcluded();
    }

    private boolean hasExternalSecondCycle(StudentCurricularPlan studentCurricularPlan) {
        CycleCurriculumGroup secondCycle = studentCurricularPlan.getSecondCycle();
        return secondCycle != null && secondCycle.isExternal() && secondCycle.hasAnyCurriculumLines();
    }

    private boolean hasExternalSecondCycleAndNewRegistration(StudentCurricularPlan studentCurricularPlan) {
        CycleCurriculumGroup secondCycle = studentCurricularPlan.getSecondCycle();
        if (secondCycle != null && secondCycle.isExternal() && secondCycle.hasAnyCurriculumLines()) {
            Student student = studentCurricularPlan.getRegistration().getStudent();
            return student.hasActiveRegistrationFor(secondCycle.getDegreeCurricularPlanOfDegreeModule());
        }
        return false;
    }

    private void separateStudentProcedure(StudentCurricularPlan studentCurricularPlan) {
        Object object = advice$separateStudentProcedure.perform((Callable)new SeparateSecondCycle$callable$separateStudentProcedure(this, studentCurricularPlan));
    }

    static /* synthetic */ void advised$separateStudentProcedure(SeparateSecondCycle this_, StudentCurricularPlan studentCurricularPlan) {
        new SeparationCyclesManagement().separateSecondCycle(studentCurricularPlan);
    }

    private void separateByStudentNumberProcedure(Student student, DegreeCurricularPlan degreeCurricularPlan) {
        Object object = advice$separateByStudentNumberProcedure.perform((Callable)new SeparateSecondCycle$callable$separateByStudentNumberProcedure(this, student, degreeCurricularPlan));
    }

    static /* synthetic */ void advised$separateByStudentNumberProcedure(SeparateSecondCycle this_, Student student, DegreeCurricularPlan dcp) {
        Registration registration = student.getMostRecentRegistration(dcp);
        this_.new SeparateByStudentNumber().separateSecondCycle(registration.getLastStudentCurricularPlan());
    }

    private class SeparateByStudentNumber
    extends SeparationCyclesManagement {
        private SeparateByStudentNumber() {
        }

        @Override
        public Registration separateSecondCycle(StudentCurricularPlan studentCurricularPlan) {
            if (SeparateSecondCycle.this.canRepeateSeparate(studentCurricularPlan)) {
                return this.createNewSecondCycle(studentCurricularPlan);
            }
            return null;
        }
    }
}

