/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestPR;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ApprovementCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.Money;

public class ApprovementCertificate
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected ApprovementCertificate(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        this.addParameter("approvementsInfo", this.getApprovementsInfo());
    }

    protected ApprovementCertificateRequest getDocumentRequest() {
        return (ApprovementCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected String getDegreeDescription() {
        return this.getDocumentRequest().getRegistration().getDegreeDescription(this.getDocumentRequest().getExecutionYear(), (ProgramConclusion)null, this.getLocale());
    }

    private final String getApprovementsInfo() {
        ApprovementCertificateRequest request = this.getDocumentRequest();
        StringBuilder res = new StringBuilder();
        TreeSet<ICurriculumEntry> entries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
        Registration registration = this.getDocumentRequest().getRegistration();
        HashMap<Unit, String> ids = new HashMap<Unit, String>();
        if (registration.isBolonha()) {
            this.reportCycles(res, entries, ids);
        } else {
            ICurriculum curriculum = registration.getCurriculum(request.getFilteringDate());
            ApprovementCertificateRequest.filterEntries(entries, request, curriculum);
            this.reportEntries(res, entries, ids);
        }
        entries.clear();
        entries.addAll(request.getExtraCurricularEntriesToReport());
        if (!entries.isEmpty()) {
            this.reportRemainingEntries(res, entries, ids, (NoCourseGroupCurriculumGroup)((Object)registration.getLastStudentCurricularPlan().getExtraCurriculumGroup()));
        }
        entries.clear();
        entries.addAll(request.getPropaedeuticEntriesToReport());
        if (!entries.isEmpty()) {
            this.reportRemainingEntries(res, entries, ids, (NoCourseGroupCurriculumGroup)((Object)registration.getLastStudentCurricularPlan().getPropaedeuticCurriculumGroup()));
        }
        if (this.getDocumentRequest().isToShowCredits()) {
            res.append(this.getRemainingCreditsInfo(request.getRegistration().getCurriculum()));
        }
        res.append(this.generateEndLine());
        if (!ids.isEmpty()) {
            res.append("\n").append(this.getAcademicUnitInfo(ids, request.getMobilityProgram()));
        }
        return res.toString();
    }

    private final void reportEntries(StringBuilder result, Collection<ICurriculumEntry> entries, Map<Unit, String> academicUnitIdentifiers) {
        ExecutionYear lastReportedExecutionYear = null;
        for (ICurriculumEntry entry : entries) {
            ExecutionYear executionYear = entry.getExecutionYear();
            if (lastReportedExecutionYear == null) {
                lastReportedExecutionYear = executionYear;
            }
            if (executionYear != lastReportedExecutionYear) {
                lastReportedExecutionYear = executionYear;
            }
            this.reportEntry(result, entry, academicUnitIdentifiers, executionYear);
        }
    }

    private final void reportCycles(StringBuilder result, SortedSet<ICurriculumEntry> entries, Map<Unit, String> academicUnitIdentifiers) {
        TreeSet<CycleCurriculumGroup> cycles = new TreeSet<CycleCurriculumGroup>(CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
        cycles.addAll(this.getDocumentRequest().getRegistration().getLastStudentCurricularPlan().getInternalCycleCurriculumGrops());
        CycleCurriculumGroup lastReported = null;
        for (CycleCurriculumGroup cycle : cycles) {
            if (cycle.isConclusionProcessed() && !this.isDEARegistration()) continue;
            ApprovementCertificateRequest request = this.getDocumentRequest();
            Curriculum curriculum = cycle.getCurriculum(request.getFilteringDate());
            ApprovementCertificateRequest.filterEntries(entries, request, curriculum);
            if (!entries.isEmpty()) {
                if (lastReported == null) {
                    lastReported = cycle;
                } else {
                    result.append(this.generateEndLine()).append("\n");
                }
                result.append(this.getMLSTextContent(cycle.getName())).append(":").append("\n");
                this.reportEntries(result, entries, academicUnitIdentifiers);
            }
            entries.clear();
        }
    }

    private boolean isDEARegistration() {
        return this.getDocumentRequest().getRegistration().getDegreeType().isAdvancedSpecializationDiploma();
    }

    private final void reportRemainingEntries(StringBuilder result, Collection<ICurriculumEntry> entries, Map<Unit, String> academicUnitIdentifiers, NoCourseGroupCurriculumGroup group) {
        result.append(this.generateEndLine()).append("\n").append(this.getMLSTextContent(group.getName())).append(":").append("\n");
        for (ICurriculumEntry entry : entries) {
            this.reportEntry(result, entry, academicUnitIdentifiers, entry.getExecutionYear());
        }
    }

    private final void reportEntry(StringBuilder result, ICurriculumEntry entry, Map<Unit, String> academicUnitIdentifiers, ExecutionYear executionYear) {
        result.append(FenixStringTools.multipleLineRightPadWithSuffix(this.getCurriculumEntryName(academicUnitIdentifiers, entry), 64, '-', this.getCreditsAndGradeInfo(entry, executionYear))).append("\n");
    }

    @Override
    protected void addPriceFields() {
        ApprovementCertificateRequest certificateRequest = this.getDocumentRequest();
        CertificateRequestPR certificateRequestPR = (CertificateRequestPR)((Object)this.getPostingRule());
        Money amountPerPage = certificateRequestPR.getAmountPerPage();
        Money baseAmountPlusAmountForUnits = certificateRequestPR.getBaseAmount().add(certificateRequestPR.getAmountForUnits(certificateRequest.getNumberOfUnits()));
        Money urgencyAmount = certificateRequest.getUrgentRequest() != false ? certificateRequestPR.getBaseAmount() : Money.ZERO;
        this.addParameter("amountPerPage", amountPerPage);
        this.addParameter("baseAmountPlusAmountForUnits", baseAmountPlusAmountForUnits);
        this.addParameter("urgencyAmount", urgencyAmount);
        this.addParameter("printPriceFields", this.printPriceParameters((CertificateRequest)((Object)certificateRequest)));
    }
}

