/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.administrativeOffice.studentEnrolment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.CurriculumModuleBean;
import org.fenixedu.academic.dto.student.IStudentCurricularPlanBean;

public class StudentEnrolmentBean
implements Serializable,
IStudentCurricularPlanBean {
    private StudentCurricularPlan studentCurricularPlan;
    private ExecutionSemester executionSemester;
    private List<CurriculumModule> curriculumModules;
    private List<DegreeModuleToEnrol> degreeModulesToEnrol;
    private CurriculumModuleBean curriculumModuleBean;

    @Override
    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public List<CurriculumModule> getCurriculumModules() {
        if (this.curriculumModules == null) {
            return new ArrayList<CurriculumModule>();
        }
        ArrayList<CurriculumModule> result = new ArrayList<CurriculumModule>();
        for (CurriculumModule curriculumModule : this.curriculumModules) {
            result.add(curriculumModule);
        }
        return result;
    }

    public void setCurriculumModules(List<CurriculumModule> curriculumModules) {
        if (curriculumModules == null) {
            this.curriculumModules = null;
        } else {
            this.curriculumModules = new ArrayList<CurriculumModule>();
            for (CurriculumModule curriculumModule : curriculumModules) {
                this.curriculumModules.add(curriculumModule);
            }
        }
    }

    public List<DegreeModuleToEnrol> getDegreeModulesToEnrol() {
        return this.degreeModulesToEnrol;
    }

    public void setDegreeModulesToEnrol(List<DegreeModuleToEnrol> degreeModulesToEnrol) {
        this.degreeModulesToEnrol = degreeModulesToEnrol;
    }

    public CurriculumModuleBean getCurriculumModuleBean() {
        return this.curriculumModuleBean;
    }

    public void setCurriculumModuleBean(CurriculumModuleBean curriculumModuleBean) {
        this.curriculumModuleBean = curriculumModuleBean;
    }

    public Set<CurriculumModule> getInitialCurriculumModules() {
        return this.getInitialCurriculumModules(this.getCurriculumModuleBean());
    }

    private Set<CurriculumModule> getInitialCurriculumModules(CurriculumModuleBean curriculumModuleBean) {
        HashSet<CurriculumModule> result = new HashSet<CurriculumModule>();
        if (curriculumModuleBean.getCurricularCoursesEnroled().isEmpty() && curriculumModuleBean.getGroupsEnroled().isEmpty()) {
            result.add(curriculumModuleBean.getCurriculumModule());
        }
        for (CurriculumModuleBean moduleBean : curriculumModuleBean.getCurricularCoursesEnroled()) {
            result.add(moduleBean.getCurriculumModule());
        }
        for (CurriculumModuleBean moduleBean : curriculumModuleBean.getGroupsEnroled()) {
            result.addAll(this.getInitialCurriculumModules(moduleBean));
        }
        return result;
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }
}

