/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.registrationStates;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateLog_Base;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class RegistrationStateLog
extends RegistrationStateLog_Base {
    private RegistrationStateLog() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
    }

    public RegistrationStateLog(RegistrationState state, EnrolmentAction action, Person person) {
        this();
        String[] args = new String[]{};
        if (state == null) {
            throw new DomainException("error.RegistrationStateLog.invalid.state", args);
        }
        Registration obj = state.getRegistration();
        String[] args1 = new String[]{};
        if (obj == null) {
            throw new DomainException("error.RegistrationStateLog.invalid.registation", args1);
        }
        DateTime obj1 = state.getStateDate();
        String[] args2 = new String[]{};
        if (obj1 == null) {
            throw new DomainException("error.RegistrationStateLog.invalid.state.date", args2);
        }
        String[] args3 = new String[]{};
        if (action == null) {
            throw new DomainException("error.RegistrationStateLog.invalid.action", args3);
        }
        this.setRegistration(state.getRegistration());
        this.setStateDate(state.getStateDate());
        this.setStateType(state.getClass().getName());
        this.setAction(action);
        if (person != null) {
            this.setWho(person.getUsername());
        }
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.setRegistration(null);
        super.deleteDomainObject();
    }
}

