/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.reports;

import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter;
import org.fenixedu.academic.domain.phd.reports.PhdReport;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;

public class RecommendationLetterReport
extends PhdReport {
    public RecommendationLetterReport(HSSFWorkbook workbook) {
        super(workbook);
    }

    public HSSFSheet build(SearchPhdIndividualProgramProcessBean bean) {
        List<PhdIndividualProgramProcess> processes = PhdIndividualProgramProcess.search(bean.getExecutionYear(), bean.getPredicates());
        if (!this.hasEPFLCandidates(processes)) {
            return null;
        }
        HSSFSheet sheet = this.workbook.createSheet("Recommendations");
        this.setHeaders(sheet);
        int i = 2;
        for (PhdIndividualProgramProcess process2 : processes) {
            if (!this.isProcessFromEPFL(process2) || !process2.isAllowedToManageProcess(Authenticate.getUser())) continue;
            String processNumber = process2.getProcessNumber();
            for (PhdCandidacyReferee referee : process2.getPhdCandidacyReferees()) {
                HSSFRow row = sheet.createRow(i++);
                String email = referee.getEmail();
                String name = referee.getName();
                PhdCandidacyRefereeLetter letter = referee.getLetter();
                this.addCellValue(row, this.onNullEmptyString(processNumber), 0);
                this.addCellValue(row, this.onNullEmptyString(name), 1);
                this.addCellValue(row, this.onNullEmptyString(email), 2);
                if (letter == null) {
                    this.addCellValue(row, "NO", 3);
                    continue;
                }
                this.addCellValue(row, "YES", 3);
                this.addCellValue(row, this.onNullEmptyString(letter.getHowLongKnownApplicant()), 4);
                this.addCellValue(row, this.onNullEmptyString(letter.getCapacity()), 5);
                this.addCellValue(row, this.onNullEmptyString(letter.getComparisonGroup()), 6);
                this.addCellValue(row, this.onNullEmptyString(letter.getRankInClass()), 7);
                this.addCellValue(row, this.onNullEmptyString(letter.getAcademicPerformance().getLocalizedName()), 8);
                this.addCellValue(row, this.onNullEmptyString((Object)letter.getSocialAndCommunicationSkills()), 9);
                this.addCellValue(row, this.onNullEmptyString((Object)letter.getPotencialToExcelPhd()), 10);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeName()), 11);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereePosition()), 12);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeInstitution()), 13);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeAddress()), 14);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeCity()), 15);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeZipCode()), 16);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeCountry().getLocalizedName().getContent()), 17);
                this.addCellValue(row, this.onNullEmptyString(letter.getRefereeEmail()), 18);
            }
        }
        return sheet;
    }

    private boolean hasEPFLCandidates(List<PhdIndividualProgramProcess> processes) {
        for (PhdIndividualProgramProcess process2 : processes) {
            if (!this.isProcessFromEPFL(process2)) continue;
            return true;
        }
        return false;
    }

    private boolean isProcessFromEPFL(PhdIndividualProgramProcess process2) {
        return process2.getCandidacyProcess().getPublicPhdCandidacyPeriod() != null && process2.getCandidacyProcess().getPublicPhdCandidacyPeriod().isEpflCandidacyPeriod() || PhdIndividualProgramCollaborationType.EPFL == process2.getCollaborationType();
    }

    @Override
    protected void setHeaders(HSSFSheet sheet) {
        this.addHeaderCell(sheet, this.getHeaderInBundle("processNumber"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("refererName"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("refererEmaol"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("hasReferenceLetter"), 3);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.howLongKnownApplicant"), 4);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.capacity"), 5);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.comparisonGroup"), 6);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.rankInClass"), 7);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.academicPerformance"), 8);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.socialAndCommunicationSkills"), 9);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.potencialToExcelPhd"), 10);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereeName"), 11);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereePosition"), 12);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereeInstitution"), 13);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereeAddress"), 14);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereeCity"), 15);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereeZipCode"), 16);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.refereeCountry"), 17);
        this.addHeaderCell(sheet, this.getResource("label.org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter.email"), 18);
    }

    private String getHeaderInBundle(String field) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)("label.org.fenixedu.academic.domain.phd.reports.PhdIndividualProgramProcessesReport." + field), (String[])new String[0]);
    }

    private String getResource(String key) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)key, (String[])new String[0]);
    }
}

