/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.messaging;

import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.messaging.ConversationMessage;
import org.fenixedu.academic.domain.messaging.ConversationThread_Base;
import org.fenixedu.academic.domain.messaging.Forum;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ConversationThread
extends ConversationThread_Base
implements Comparable<ConversationThread> {
    public ConversationThread(Forum forum, Person creator, MultiLanguageString subject) {
        this.setCreationDate(new DateTime());
        this.init(forum, creator, subject);
    }

    private void init(Forum forum, Person creator, MultiLanguageString subject) {
        this.setForum(forum);
        this.setTitle(subject);
        this.setCreator(creator);
    }

    public void setForum(Forum forum) {
        if (forum == null) {
            throw new DomainException("conversationThread.forum.cannot.be.null", new String[0]);
        }
        super.setForum(forum);
    }

    public void setTitle(MultiLanguageString subject) {
        if (subject == null || subject.getContent() == null || subject.getContent().trim().isEmpty()) {
            throw new DomainException("conversationThread.subject.cannot.be.null", new String[0]);
        }
        super.setTitle(subject);
    }

    public void setCreator(Person creator) {
        if (creator == null) {
            throw new DomainException("conversationThread.creator.cannot.be.null", new String[0]);
        }
        super.setCreator(creator);
    }

    public void checkIfPersonCanWrite(Person person) {
        this.getForum().checkIfPersonCanWrite(person);
    }

    public ConversationMessage createConversationMessage(Person creator, MultiLanguageString body) {
        this.checkIfPersonCanWrite(creator);
        return new ConversationMessage(this, creator, body);
    }

    public ConversationMessage getNextToLastConversationMessage() {
        ConversationMessage lastConversationMessage = null;
        ConversationMessage nextToLastConversationMessage = null;
        for (ConversationMessage conversationMessage : this.getMessageSet()) {
            if (lastConversationMessage == null) {
                lastConversationMessage = conversationMessage;
                continue;
            }
            if (conversationMessage.getCreationDate().compareTo((ReadableInstant)lastConversationMessage.getCreationDate()) > 1) {
                nextToLastConversationMessage = lastConversationMessage;
                lastConversationMessage = conversationMessage;
                continue;
            }
            if (nextToLastConversationMessage == null) {
                nextToLastConversationMessage = conversationMessage;
                continue;
            }
            if (conversationMessage.getCreationDate().compareTo((ReadableInstant)nextToLastConversationMessage.getCreationDate()) <= 1) continue;
            nextToLastConversationMessage = conversationMessage;
        }
        return nextToLastConversationMessage;
    }

    public void addConversationMessages(ConversationMessage conversationMessage) {
        conversationMessage.setConversationThread(this);
    }

    @ConsistencyPredicate
    public final boolean checkTitle() {
        return this.getTitle() != null && this.getTitle().getContent() != null && !this.getTitle().getContent().trim().isEmpty();
    }

    public void delete() {
        for (ConversationMessage message : this.getMessageSet()) {
            message.delete();
        }
        this.setCreator(null);
        this.setForum(null);
        this.deleteDomainObject();
    }

    @Override
    public int compareTo(ConversationThread o) {
        return this.getCreationDate().compareTo((ReadableInstant)o.getCreationDate());
    }
}

