/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.executionCourse;

import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Summary;

public class SummariesSearchBean
implements Serializable {
    private final ExecutionCourse executionCourseDomainReference;
    private ShiftType shiftType;
    private Shift shiftDomainReference;
    private Professorship professorshipDomainReference;
    private Boolean showOtherProfessors;
    private Boolean ascendant = false;

    public SummariesSearchBean(ExecutionCourse executionCourse) {
        this.executionCourseDomainReference = executionCourse;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourseDomainReference;
    }

    public Professorship getProfessorship() {
        return this.professorshipDomainReference;
    }

    public void setProfessorship(Professorship professorship) {
        this.professorshipDomainReference = professorship;
    }

    public Shift getShift() {
        return this.shiftDomainReference;
    }

    public void setShift(Shift shift) {
        this.shiftDomainReference = shift;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public void setShiftType(ShiftType shiftType) {
        this.shiftType = shiftType;
    }

    public Boolean getShowOtherProfessors() {
        return this.showOtherProfessors;
    }

    public void setShowOtherProfessors(Boolean showOtherProfessors) {
        this.showOtherProfessors = showOtherProfessors;
    }

    public SortedSet<Summary> search() {
        TreeSet<Summary> summaries = this.isAscendant() != false ? new TreeSet<Summary>(Summary.COMPARATOR_BY_DATE_AND_HOUR_ASC) : new TreeSet<Summary>(Summary.COMPARATOR_BY_DATE_AND_HOUR);
        for (Summary summary : this.getExecutionCourse().getAssociatedSummariesSet()) {
            Shift shift = summary.getShift();
            if (this.getShift() != null && this.getShift() != shift || this.getShiftType() != null && this.getShiftType() != summary.getSummaryType()) continue;
            Professorship professorship = summary.getProfessorship();
            if (this.getProfessorship() == null && this.showOtherProfessors == null) {
                summaries.add(summary);
                continue;
            }
            if (professorship == null && this.showOtherProfessors != null && this.showOtherProfessors.booleanValue()) {
                summaries.add(summary);
                continue;
            }
            if (this.showOtherProfessors != null || (this.getProfessorship() != null || professorship == null) && this.getProfessorship() != professorship) continue;
            summaries.add(summary);
        }
        return summaries;
    }

    public SortedSet<Summary> getSummaries() {
        return this.search();
    }

    public SortedSet<Summary> getSummariesInverted() {
        TreeSet<Summary> summaries = new TreeSet<Summary>(Summary.COMPARATOR_BY_DATE_AND_HOUR_ASC);
        summaries.addAll(this.search());
        return summaries;
    }

    public SortedSet<ShiftType> getShiftTypes() {
        TreeSet<ShiftType> shiftTypes = new TreeSet<ShiftType>();
        for (Shift shift : this.getExecutionCourse().getAssociatedShifts()) {
            shiftTypes.addAll(shift.getTypes());
        }
        return shiftTypes;
    }

    public void setAscendant(Boolean descendant) {
        this.ascendant = descendant;
    }

    public Boolean isAscendant() {
        return this.ascendant;
    }
}

