/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.MobilePhone_Base;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhoneValidation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.ui.struts.action.externalServices.PhoneValidationUtils;
import org.joda.time.DateTime;

public class MobilePhone
extends MobilePhone_Base {
    public static Comparator<MobilePhone> COMPARATOR_BY_NUMBER = new Comparator<MobilePhone>(){

        @Override
        public int compare(MobilePhone contact, MobilePhone otherContact) {
            String number = contact.getNumber();
            String otherNumber = otherContact.getNumber();
            int result = 0;
            if (number != null && otherNumber != null) {
                result = number.compareTo(otherNumber);
            } else if (number != null) {
                result = 1;
            } else if (otherNumber != null) {
                result = -1;
            }
            return result == 0 ? PartyContact.COMPARATOR_BY_TYPE.compare((PartyContact)((Object)contact), (PartyContact)((Object)otherContact)) : result;
        }
    };

    public static MobilePhone createMobilePhone(Party party, String number, PartyContactType type, Boolean isDefault, Boolean visibleToPublic, Boolean visibleToStudents, Boolean visibleToStaff) {
        MobilePhone result = null;
        if (!StringUtils.isEmpty((String)number)) {
            result = new MobilePhone(party, type, visibleToPublic, visibleToStudents, visibleToStaff, isDefault, number);
        }
        return result;
    }

    public static MobilePhone createMobilePhone(Party party, String number, PartyContactType type, boolean isDefault) {
        for (MobilePhone phone : party.getMobilePhones()) {
            if (!phone.getNumber().equals(number)) continue;
            return phone;
        }
        return !StringUtils.isEmpty((String)number) ? new MobilePhone(party, type, isDefault, number) : null;
    }

    protected MobilePhone() {
        new PhoneValidation((PartyContact)((Object)this));
    }

    protected MobilePhone(Party party, PartyContactType type, boolean defaultContact, String number) {
        this();
        super.init(party, type, defaultContact);
        this.checkParameters(number);
        super.setNumber(number);
    }

    protected MobilePhone(Party party, PartyContactType type, boolean visibleToPublic, boolean visibleToStudents, boolean visibleToStaff, boolean defaultContact, String number) {
        this();
        super.init(party, type, visibleToPublic, visibleToStudents, visibleToStaff, defaultContact);
        this.checkParameters(number);
        super.setNumber(number);
    }

    private void checkParameters(String number) {
        if (StringUtils.isEmpty((String)number)) {
            throw new DomainException("error.contacts.Phone.invalid.number", new String[0]);
        }
    }

    public boolean isMobile() {
        return true;
    }

    public void edit(String number) {
        if (!StringUtils.equals((String)this.getNumber(), (String)number)) {
            super.setNumber(number);
            if (!this.waitsValidation()) {
                new PhoneValidation((PartyContact)((Object)this));
            }
            this.setLastModifiedDate(new DateTime());
        }
    }

    public String getPresentationValue() {
        return this.getNumber();
    }

    public boolean hasNumber() {
        return this.getNumber() != null && !this.getNumber().isEmpty();
    }

    public boolean hasValue(String value) {
        return this.hasNumber() && this.getNumber().equals(value);
    }

    public void logCreate(Person person) {
        this.logCreateAux(person, "label.partyContacts.MobilePhone");
    }

    public void logEdit(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
        this.logEditAux(person, propertiesChanged, valueChanged, createdNewContact, newValue, "label.partyContacts.MobilePhone");
    }

    public void logDelete(Person person) {
        this.logDeleteAux(person, "label.partyContacts.MobilePhone");
    }

    public void logValid(Person person) {
        this.logValidAux(person, "label.partyContacts.MobilePhone");
    }

    public void logRefuse(Person person) {
        this.logRefuseAux(person, "label.partyContacts.MobilePhone");
    }

    public boolean isToBeValidated() {
        return MobilePhone.requiresValidation();
    }

    public static boolean requiresValidation() {
        return PhoneValidationUtils.getInstance().shouldRun();
    }
}

