/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.District;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.util.workflow.Form;
import org.fenixedu.academic.util.LabelFormatter;

public class ResidenceInformationForm
extends Form {
    private static final long serialVersionUID = 1L;
    private String address;
    private String areaCode;
    private String areaOfAreaCode;
    private String area;
    private String parishOfResidence;
    private District districtOfResidence;
    private DistrictSubdivision districtSubdivisionOfResidence;
    private Boolean dislocatedFromPermanentResidence;
    private District schoolTimeDistrictOfResidence;
    private DistrictSubdivision schoolTimeDistrictSubdivisionOfResidence;
    private String schoolTimeAddress;
    private String schoolTimeAreaCode;
    private String schoolTimeAreaOfAreaCode;
    private String schoolTimeArea;
    private String schoolTimeParishOfResidence;
    private Country countryOfResidence;

    public ResidenceInformationForm() {
    }

    private ResidenceInformationForm(String address, String areaCode, String areaOfAreaCode, String area, String parishOfResidence, District districtOfResidence, DistrictSubdivision districtSubdivisionOfResidence, Country countryOfResidence) {
        this.setAddress(address);
        this.setAreaCode(areaCode);
        this.setAreaOfAreaCode(areaOfAreaCode);
        this.setArea(area);
        this.setParishOfResidence(parishOfResidence);
        this.setDistrictOfResidence(districtOfResidence);
        this.setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
        this.setCountryOfResidence(countryOfResidence);
        this.setDislocatedFromPermanentResidence(Boolean.FALSE);
    }

    public static ResidenceInformationForm createFromPerson(Person person) {
        if (person.hasDefaultPhysicalAddress()) {
            District districtOfResidence;
            PhysicalAddress physicalAddress = person.getDefaultPhysicalAddress();
            Country country = ResidenceInformationForm.getCountryOfResidenceFromPhysicalAddress(physicalAddress);
            District district = districtOfResidence = physicalAddress.getDistrictOfResidence() != null ? District.readByName(physicalAddress.getDistrictOfResidence()) : null;
            DistrictSubdivision districtSubdivisionOfResidence = districtOfResidence != null ? (physicalAddress.getDistrictSubdivisionOfResidence() != null ? districtOfResidence.getDistrictSubdivisionByName(physicalAddress.getDistrictSubdivisionOfResidence()) : null) : null;
            return new ResidenceInformationForm(physicalAddress.getAddress(), physicalAddress.getAreaCode(), physicalAddress.getAreaOfAreaCode(), physicalAddress.getArea(), physicalAddress.getParishOfResidence(), districtOfResidence, districtSubdivisionOfResidence, country);
        }
        ResidenceInformationForm residenceInformationForm = new ResidenceInformationForm();
        residenceInformationForm.setCountryOfResidence(Country.readDefault());
        return residenceInformationForm;
    }

    private static Country getCountryOfResidenceFromPhysicalAddress(PhysicalAddress physicalAddress) {
        return physicalAddress.getCountryOfResidence() != null ? physicalAddress.getCountryOfResidence() : Country.readDefault();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaOfAreaCode() {
        return this.areaOfAreaCode;
    }

    public void setAreaOfAreaCode(String areaOfAreaCode) {
        this.areaOfAreaCode = areaOfAreaCode;
    }

    public District getDistrictOfResidence() {
        return this.districtOfResidence;
    }

    public void setDistrictOfResidence(District district) {
        this.districtOfResidence = district;
    }

    public DistrictSubdivision getDistrictSubdivisionOfResidence() {
        return this.districtSubdivisionOfResidence;
    }

    public void setDistrictSubdivisionOfResidence(DistrictSubdivision districtSubdivision) {
        this.districtSubdivisionOfResidence = districtSubdivision;
    }

    public String getParishOfResidence() {
        return this.parishOfResidence;
    }

    public void setParishOfResidence(String parishOfResidence) {
        this.parishOfResidence = parishOfResidence;
    }

    public Country getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setCountryOfResidence(Country countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    public Boolean getDislocatedFromPermanentResidence() {
        return this.dislocatedFromPermanentResidence;
    }

    public void setDislocatedFromPermanentResidence(Boolean dislocatedFromPermanentResidence) {
        this.dislocatedFromPermanentResidence = dislocatedFromPermanentResidence;
    }

    public District getSchoolTimeDistrictOfResidence() {
        return this.schoolTimeDistrictOfResidence;
    }

    public void setSchoolTimeDistrictOfResidence(District district) {
        this.schoolTimeDistrictOfResidence = district;
    }

    public DistrictSubdivision getSchoolTimeDistrictSubdivisionOfResidence() {
        return this.schoolTimeDistrictSubdivisionOfResidence;
    }

    public void setSchoolTimeDistrictSubdivisionOfResidence(DistrictSubdivision districtSubdivision) {
        this.schoolTimeDistrictSubdivisionOfResidence = districtSubdivision;
    }

    public String getSchoolTimeAddress() {
        return this.schoolTimeAddress;
    }

    public void setSchoolTimeAddress(String schoolTimeAddress) {
        this.schoolTimeAddress = schoolTimeAddress;
    }

    public String getSchoolTimeAreaCode() {
        return this.schoolTimeAreaCode;
    }

    public void setSchoolTimeAreaCode(String schoolTimeAreaCode) {
        this.schoolTimeAreaCode = schoolTimeAreaCode;
    }

    public String getSchoolTimeAreaOfAreaCode() {
        return this.schoolTimeAreaOfAreaCode;
    }

    public void setSchoolTimeAreaOfAreaCode(String schoolTimeAreaOfAreaCode) {
        this.schoolTimeAreaOfAreaCode = schoolTimeAreaOfAreaCode;
    }

    public String getSchoolTimeArea() {
        return this.schoolTimeArea;
    }

    public void setSchoolTimeArea(String schoolTimeArea) {
        this.schoolTimeArea = schoolTimeArea;
    }

    public String getSchoolTimeParishOfResidence() {
        return this.schoolTimeParishOfResidence;
    }

    public void setSchoolTimeParishOfResidence(String schoolTimeParishOfResidence) {
        this.schoolTimeParishOfResidence = schoolTimeParishOfResidence;
    }

    @Override
    public List<LabelFormatter> validate() {
        ArrayList<LabelFormatter> result = new ArrayList<LabelFormatter>();
        this.checkAddressInformationForForeignStudents(result);
        this.checkAddressInformationForNationalStudents(result);
        this.checkAddressInformationForDislocatedStudents(result);
        return result;
    }

    private void checkAddressInformationForForeignStudents(List<LabelFormatter> result) {
        if (!this.getCountryOfResidence().isDefaultCountry() && !this.dislocatedFromPermanentResidence.booleanValue()) {
            result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.ResidenceInformationForm.non.nacional.students.should.select.dislocated.option.and.fill.address", "resources.ApplicationResources"));
        }
    }

    private void checkAddressInformationForNationalStudents(List<LabelFormatter> result) {
        if (this.getCountryOfResidence().isDefaultCountry() && !this.isResidenceInformationFilled()) {
            result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.ResidenceInformationForm.address.national.students.should.supply.complete.address.information", "resources.ApplicationResources"));
        }
    }

    private boolean isResidenceInformationFilled() {
        return this.getDistrictOfResidence() != null && this.getDistrictSubdivisionOfResidence() != null && !StringUtils.isEmpty((String)this.parishOfResidence) && !StringUtils.isEmpty((String)this.address) && !StringUtils.isEmpty((String)this.areaCode) && !StringUtils.isEmpty((String)this.areaOfAreaCode) && !StringUtils.isEmpty((String)this.area);
    }

    private void checkAddressInformationForDislocatedStudents(List<LabelFormatter> result) {
        if (this.isAnySchoolTimeAddressInformationFilled() && !this.dislocatedFromPermanentResidence.booleanValue()) {
            result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.ResidenceInformationForm.only.dislocated.students.should.fill.school.time.address.information", "resources.ApplicationResources"));
        }
        if (this.dislocatedFromPermanentResidence.booleanValue()) {
            if (!this.isSchoolTimeRequiredInformationAddressFilled()) {
                result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.ResidenceInformationForm.address.information.is.required.for.dislocated.students", "resources.ApplicationResources"));
            } else if (this.isAnyFilled(this.schoolTimeAddress, this.schoolTimeAreaCode, this.schoolTimeAreaOfAreaCode, this.schoolTimeArea, this.schoolTimeParishOfResidence) && this.isAnyEmpty(this.schoolTimeAddress, this.schoolTimeAreaCode, this.schoolTimeAreaOfAreaCode, this.schoolTimeArea, this.schoolTimeParishOfResidence)) {
                result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.ResidenceInformationForm.school.time.address.must.be.filled.completly.otherwise.fill.minimun.required", "resources.ApplicationResources"));
            }
        }
    }

    public boolean isAnySchoolTimeAddressInformationFilled() {
        return this.getSchoolTimeDistrictOfResidence() != null || this.getSchoolTimeDistrictSubdivisionOfResidence() != null || this.isAnyFilled(this.schoolTimeAddress, this.schoolTimeAreaCode, this.schoolTimeAreaOfAreaCode, this.schoolTimeParishOfResidence, this.schoolTimeArea);
    }

    private boolean isAnyFilled(String ... fields) {
        for (String each : fields) {
            if (StringUtils.isEmpty((String)each)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyEmpty(String ... fields) {
        for (String each : fields) {
            if (!StringUtils.isEmpty((String)each)) continue;
            return true;
        }
        return false;
    }

    private boolean isSchoolTimeRequiredInformationAddressFilled() {
        return this.getSchoolTimeDistrictOfResidence() != null && this.getSchoolTimeDistrictSubdivisionOfResidence() != null;
    }

    public boolean isSchoolTimeAddressComplete() {
        return this.isSchoolTimeRequiredInformationAddressFilled() && !this.isAnyEmpty(this.schoolTimeAddress, this.schoolTimeAreaCode, this.schoolTimeAreaOfAreaCode, this.schoolTimeParishOfResidence, this.schoolTimeArea);
    }

    @Override
    public String getFormName() {
        return "label.candidacy.workflow.residenceInformationForm";
    }

    @Override
    public String getFormDescription() {
        return "label.candidacy.workflow.residenceInformationForm.description";
    }
}

