/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.lang.annotation.Annotation;
import java.util.Random;
import java.util.concurrent.Callable;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.candidacy.GenericApplication;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation$callable$sendEmailForRecommendation;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation$callable$sendEmailForRecommendationDelete;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GenericApplicationRecomentation
extends GenericApplicationRecomentation_Base {
    public static final Advice advice$sendEmailForRecommendation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$sendEmailForRecommendationDelete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public GenericApplicationRecomentation(GenericApplication application, String title, String name, String institution, String email) {
        this.setRootDomainObject(Bennu.getInstance());
        String confirmationCode = Hashing.sha512().hashString((CharSequence)(this.getEmail() + System.currentTimeMillis() + this.hashCode() + new Random(System.currentTimeMillis()).nextGaussian()), Charsets.UTF_8).toString();
        this.setConfirmationCode(confirmationCode);
        this.setEmail(email);
        this.setGenericApplication(application);
        this.setInstitution(institution);
        this.setTitle(title);
        this.setName(name);
        this.setRequestTime(new DateTime());
        this.sendEmailForRecommendation();
    }

    public void sendEmailForRecommendation() {
        Object object = advice$sendEmailForRecommendation.perform((Callable)new GenericApplicationRecomentation$callable$sendEmailForRecommendation(this));
    }

    static /* synthetic */ void advised$sendEmailForRecommendation(GenericApplicationRecomentation this_) {
        String subject = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.recomentation.email.subject", (String[])new String[]{this_.getGenericApplication().getName()});
        String body = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.recomentation.email.body", (String[])new String[]{this_.getTitle(), this_.getName(), this_.getGenericApplication().getName(), this_.getGenericApplication().getGenericApplicationPeriod().getTitle().getContent(), this_.generateConfirmationLink()});
        new Message((Sender)((Object)this_.getRootDomainObject().getSystemSender()), this_.getEmail(), subject, body);
    }

    public void sendEmailForRecommendationDelete() {
        Object object = advice$sendEmailForRecommendationDelete.perform((Callable)new GenericApplicationRecomentation$callable$sendEmailForRecommendationDelete(this));
    }

    static /* synthetic */ void advised$sendEmailForRecommendationDelete(GenericApplicationRecomentation this_) {
        String subject = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.recomentation.email.subject", (String[])new String[]{this_.getGenericApplication().getName()});
        String body = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.recomentation.email.delete.body", (String[])new String[]{this_.getTitle(), this_.getName(), this_.getGenericApplication().getName(), this_.getGenericApplication().getGenericApplicationPeriod().getTitle().getContent()});
        new Message((Sender)((Object)this_.getRootDomainObject().getSystemSender()), this_.getEmail(), subject, body);
    }

    private String generateConfirmationLink() {
        return FenixEduAcademicConfiguration.getConfiguration().getGenericApplicationEmailRecommendationLink() + this.getConfirmationCode() + "&recommendationExternalId=" + this.getExternalId();
    }
}

