/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.AdmittedCandidacySituation;
import org.fenixedu.academic.domain.candidacy.CancelledCandidacySituation;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.CandidacySituation;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.Candidacy_Base;
import org.fenixedu.academic.domain.candidacy.DFACandidacy;
import org.fenixedu.academic.domain.candidacy.DegreeCandidacy;
import org.fenixedu.academic.domain.candidacy.NotAdmittedCandidacySituation;
import org.fenixedu.academic.domain.candidacy.PreCandidacySituation;
import org.fenixedu.academic.domain.candidacy.RegisteredCandidacySituation;
import org.fenixedu.academic.domain.candidacy.StandByCandidacySituation;
import org.fenixedu.academic.domain.candidacy.StandByConfirmedDataCandidacySituation;
import org.fenixedu.academic.domain.candidacy.StandByFilledDataCandidacySituation;
import org.fenixedu.academic.domain.candidacy.SubstituteCandidacySituation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.util.workflow.IState;
import org.fenixedu.academic.domain.util.workflow.Operation;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.YearMonthDay;

public abstract class Candidacy
extends Candidacy_Base {
    protected Candidacy() {
        this.setNumber(this.createCandidacyNumber());
        this.setRootDomainObject(Bennu.getInstance());
        this.setStartDate(new YearMonthDay());
    }

    public Candidacy(CandidacySituation candidacySituation) {
        this();
        if (candidacySituation == null) {
            throw new DomainException("candidacy situation cannot be null", new String[0]);
        }
        this.addCandidacySituations(candidacySituation);
    }

    public final Integer createCandidacyNumber() {
        if (Bennu.getInstance().getCandidaciesSet().size() == 0) {
            return 1;
        }
        Candidacy candidacy = (Candidacy)((Object)Collections.max(Bennu.getInstance().getCandidaciesSet(), new BeanComparator("number")));
        return candidacy.getNumber() + 1;
    }

    public CandidacySituation getActiveCandidacySituation() {
        return !this.getCandidacySituationsSet().isEmpty() ? Collections.max(this.getCandidacySituationsSet(), CandidacySituation.DATE_COMPARATOR) : null;
    }

    public CandidacySituationType getActiveCandidacySituationType() {
        CandidacySituation situation = this.getActiveCandidacySituation();
        return situation != null ? situation.getCandidacySituationType() : null;
    }

    private CandidacySituation getFirstCandidacySituation() {
        return Collections.min(this.getCandidacySituationsSet(), CandidacySituation.DATE_COMPARATOR);
    }

    public static Candidacy readByCandidacyNumber(Integer candidacyNumber) {
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            if (!candidacy.getNumber().equals(candidacyNumber)) continue;
            return candidacy;
        }
        return null;
    }

    public static Set<Candidacy> readCandidaciesBetween(Integer from, Integer to) {
        HashSet<Candidacy> result = new HashSet<Candidacy>();
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            if (candidacy.getNumber() < from || candidacy.getNumber() > to) continue;
            result.add(candidacy);
        }
        return result;
    }

    public static Set<Candidacy> readDegreeCandidaciesBetween(Integer from, Integer to) {
        HashSet<Candidacy> result = new HashSet<Candidacy>();
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            if (!(candidacy instanceof DegreeCandidacy) || candidacy.getNumber() < from || candidacy.getNumber() > to) continue;
            result.add(candidacy);
        }
        return result;
    }

    public static Set<Candidacy> readDFACandidaciesBetween(Integer from, Integer to) {
        HashSet<Candidacy> result = new HashSet<Candidacy>();
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            if (!(candidacy instanceof DFACandidacy) || candidacy.getNumber() < from || candidacy.getNumber() > to) continue;
            result.add(candidacy);
        }
        return result;
    }

    public abstract String getDescription();

    protected abstract Set<Operation> getOperations(CandidacySituation var1);

    protected abstract void moveToNextState(CandidacyOperationType var1, Person var2);

    public abstract boolean isConcluded();

    public YearMonthDay getStartDate() {
        return super.getStartDate() != null ? super.getStartDate() : this.getFirstCandidacySituation().getSituationDate().toYearMonthDay();
    }

    public void delete() {
        this.setPerson(null);
        while (!this.getCandidacySituationsSet().isEmpty()) {
            ((CandidacySituation)this.getCandidacySituationsSet().iterator().next()).delete();
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public abstract Map<String, Set<String>> getStateMapping();

    public abstract String getDefaultState();

    public CandidacySituation nextState(String nextState) {
        CandidacySituationType situationType = CandidacySituationType.valueOf(nextState);
        if (!situationType.equals((Object)this.getActiveCandidacySituation().getCandidacySituationType()) && this.getValidNextStates().contains(nextState)) {
            switch (situationType) {
                case CANCELLED: {
                    return new CancelledCandidacySituation(this);
                }
                case PRE_CANDIDACY: {
                    return new PreCandidacySituation(this);
                }
                case STAND_BY: {
                    return new StandByCandidacySituation(this);
                }
                case STAND_BY_CONFIRMED_DATA: {
                    return new StandByConfirmedDataCandidacySituation(this);
                }
                case STAND_BY_FILLED_DATA: {
                    return new StandByFilledDataCandidacySituation(this);
                }
                case REGISTERED: {
                    return new RegisteredCandidacySituation(this);
                }
                case ADMITTED: {
                    return new AdmittedCandidacySituation(this);
                }
                case NOT_ADMITTED: {
                    return new NotAdmittedCandidacySituation(this);
                }
                case SUBSTITUTE: {
                    return new SubstituteCandidacySituation(this);
                }
            }
        }
        return null;
    }

    public IState nextState() {
        return this.nextState(this.getDefaultState());
    }

    public void checkConditionsToForward() {
        this.checkConditionsToForward(this.getDefaultState());
    }

    public void checkConditionsToForward(String nextState) {
        switch (this.getActiveCandidacySituation().getCandidacySituationType()) {
            case CANCELLED: {
                throw new DomainException("error.impossible.to.forward.from.cancelled", new String[0]);
            }
            case ADMITTED: {
                break;
            }
            case STAND_BY: {
                if (this.isCancelling(nextState)) break;
                if (!this.checkIfDataIsFilled()) {
                    throw new DomainException("error.mandatory.data.not.filled.yet", new String[0]);
                }
                if (!(this instanceof DFACandidacy) || this.checkIfPrecedenceDataIsFilled()) break;
                throw new DomainException("error.mandatory.data.not.filled.yet", new String[0]);
            }
        }
    }

    private boolean isCancelling(String nextState) {
        return CandidacySituationType.valueOf(nextState) == CandidacySituationType.CANCELLED;
    }

    public Set<String> getValidNextStates() {
        return this.getStateMapping().get(this.getActiveCandidacySituation().getCandidacySituationType().toString());
    }

    private boolean checkIfPrecedenceDataIsFilled() {
        if (!(this instanceof DFACandidacy)) {
            return false;
        }
        PrecedentDegreeInformation precedentDegreeInformation = ((DFACandidacy)((Object)this)).getPrecedentDegreeInformation();
        return precedentDegreeInformation.getConclusionGrade() != null && precedentDegreeInformation.getConclusionYear() != null && precedentDegreeInformation.getCountry() != null && precedentDegreeInformation.getDegreeDesignation() != null && precedentDegreeInformation.getInstitution() != null;
    }

    protected boolean checkIfDataIsFilled() {
        Person person = this.getPerson();
        return person.getGender() != null && person.getEmissionDateOfDocumentIdYearMonthDay() != null && person.getEmissionLocationOfDocumentId() != null && person.getExpirationDateOfDocumentIdYearMonthDay() != null && person.getSocialSecurityNumber() != null && person.getProfession() != null && person.getMaritalStatus() != null && person.getDateOfBirthYearMonthDay() != null && person.getCountry() != null && person.getParishOfBirth() != null && person.getDistrictSubdivisionOfBirth() != null && person.getDistrictOfBirth() != null && person.getCountryOfBirth() != null && person.getNameOfFather() != null && person.getNameOfMother() != null && person.hasDefaultPhysicalAddress() && person.getInstitutionalOrDefaultEmailAddressValue() != null;
    }

    public boolean isActive() {
        CandidacySituationType situationType = this.getActiveCandidacySituationType();
        return situationType != null && situationType.isActive();
    }
}

