/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping$callable$create;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping$callable$delete;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentCodeMapping
extends PaymentCodeMapping_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PaymentCodeMapping() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public PaymentCodeMapping(ExecutionInterval executionInterval, PaymentCode oldCode, PaymentCode newCode) {
        this();
        String[] args = new String[]{};
        if (executionInterval == null) {
            throw new DomainException("error.PaymentCodeMapping.invalid.execution.interval", args);
        }
        String[] args1 = new String[]{};
        if (oldCode == null) {
            throw new DomainException("error.PaymentCodeMapping.invalid.old.code", args1);
        }
        String[] args2 = new String[]{};
        if (newCode == null) {
            throw new DomainException("error.PaymentCodeMapping.invalid.new.code", args2);
        }
        this.check(executionInterval, oldCode, newCode);
        this.setExecutionInterval(executionInterval);
        this.setOldPaymentCode(oldCode);
        this.setNewPaymentCode(newCode);
    }

    private void check(ExecutionInterval executionInterval, PaymentCode oldCode, PaymentCode newCode) {
        if (oldCode.equals((Object)newCode)) {
            throw new DomainException("error.PaymentCodeMapping.old.code.equals.new.code", new String[0]);
        }
        PaymentCode code = executionInterval.findNewCodeInPaymentCodeMapping(oldCode);
        if (code != null) {
            throw new DomainException("error.PaymentCodeMapping.find.existing.code", oldCode.getFormattedCode(), code.getFormattedCode());
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentCodeMapping$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentCodeMapping this_) {
        this_.setExecutionInterval(null);
        this_.setOldPaymentCode(null);
        this_.setNewPaymentCode(null);
        this_.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean hasOldPaymentCode(PaymentCode oldCode) {
        return this.getOldPaymentCode() != null && this.getOldPaymentCode().equals((Object)oldCode);
    }

    public boolean has(ExecutionInterval executionInterval) {
        return this.getExecutionInterval().equals((Object)executionInterval);
    }

    public static PaymentCodeMapping create(ExecutionInterval executionInterval, PaymentCode paymentCode, PaymentCode paymentCode2) {
        return (PaymentCodeMapping)((Object)advice$create.perform((Callable)new PaymentCodeMapping$callable$create(executionInterval, paymentCode, paymentCode2)));
    }

    static /* synthetic */ PaymentCodeMapping advised$create(ExecutionInterval executionInterval, PaymentCode oldCode, PaymentCode newCode) {
        return new PaymentCodeMapping(executionInterval, oldCode, newCode);
    }

    public static class PaymentCodeMappingBean
    implements Serializable {
        private ExecutionInterval executionInterval;
        private PaymentCode oldCode;
        private PaymentCode newCode;

        public ExecutionInterval getExecutionInterval() {
            return this.executionInterval;
        }

        public void setExecutionInterval(ExecutionInterval executionInterval) {
            this.executionInterval = executionInterval;
        }

        public boolean hasExecutionInterval() {
            return this.getExecutionInterval() != null;
        }

        public PaymentCode getOldCode() {
            return this.oldCode;
        }

        public void setOldCode(PaymentCode oldCode) {
            this.oldCode = oldCode;
        }

        public PaymentCode getNewCode() {
            return this.newCode;
        }

        public void setNewCode(PaymentCode newCode) {
            this.newCode = newCode;
        }

        public PaymentCodeMapping create() {
            return PaymentCodeMapping.create(this.getExecutionInterval(), this.getOldCode(), this.getNewCode());
        }

        public void clear() {
            this.setOldCode(null);
            this.setNewCode(null);
        }
    }
}

