/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentStudentSharingDegreeOfExecutionCourseGroup;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="studentSharingDegreeOfExecutionCourse")
public class StudentSharingDegreeOfExecutionCourseGroup
extends FenixGroup {
    private static final long serialVersionUID = -5847181312665627041L;
    @GroupArgument
    private ExecutionCourse executionCourse;

    private StudentSharingDegreeOfExecutionCourseGroup() {
    }

    private StudentSharingDegreeOfExecutionCourseGroup(ExecutionCourse executionCourse) {
        this();
        this.executionCourse = executionCourse;
    }

    public static StudentSharingDegreeOfExecutionCourseGroup get(ExecutionCourse executionCourse) {
        return new StudentSharingDegreeOfExecutionCourseGroup(executionCourse);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.executionCourse.getName()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        HashSet<Degree> degrees = new HashSet<Degree>();
        for (CurricularCourse curricularCourse : this.executionCourse.getAssociatedCurricularCoursesSet()) {
            degrees.add(curricularCourse.getDegree());
        }
        for (Degree degree : degrees) {
            for (Registration registration : degree.getActiveRegistrations()) {
                User user = registration.getPerson().getUser();
                if (user == null) continue;
                users.add(user);
            }
        }
        for (Attends attends : this.executionCourse.getAttendsSet()) {
            User user = attends.getRegistration().getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        if (user.getPerson().getStudent() != null) {
            HashSet<Degree> degrees = new HashSet<Degree>();
            for (CurricularCourse curricularCourse : this.executionCourse.getAssociatedCurricularCoursesSet()) {
                degrees.add(curricularCourse.getDegree());
            }
            for (Registration registration : user.getPerson().getStudent().getRegistrationsSet()) {
                if (degrees.contains(registration.getDegree())) {
                    return true;
                }
                if (!registration.getAttendingExecutionCoursesFor().contains((Object)this.executionCourse)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentStudentSharingDegreeOfExecutionCourseGroup.getInstance(this.executionCourse);
    }

    public boolean equals(Object object) {
        if (object instanceof StudentSharingDegreeOfExecutionCourseGroup) {
            return Objects.equal((Object)((Object)this.executionCourse), (Object)((Object)((StudentSharingDegreeOfExecutionCourseGroup)((Object)object)).executionCourse));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.executionCourse});
    }
}

