/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.accessControl.SearchDegreeStudentsGroup;
import org.fenixedu.academic.domain.util.email.CoordinatorSender;
import org.fenixedu.academic.domain.util.email.ExecutionCourseSender;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.dto.teacher.executionCourse.SearchExecutionCourseAttendsBean;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.messaging.EmailsDA;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.teacher.executionCourse.ExecutionCourseBaseAction;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.academic.util.WorkingStudentSelectionType;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/searchECAttends", module="teacher", functionality=ManageExecutionCourseDA.class)
@Forwards(value={@Forward(name="viewAttendsSearch", path="/teacher/viewAttendsSearch.jsp")})
public class SearchExecutionCourseAttendsAction
extends ExecutionCourseBaseAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        SearchExecutionCourseAttendsBean searchExecutionCourseAttendsBean = this.readSearchBean(request, executionCourse);
        executionCourse.searchAttends(searchExecutionCourseAttendsBean);
        request.setAttribute("searchBean", (Object)searchExecutionCourseAttendsBean);
        request.setAttribute("executionCourse", (Object)searchExecutionCourseAttendsBean.getExecutionCourse());
        this.prepareAttendsCollectionPages(request, searchExecutionCourseAttendsBean, executionCourse);
        return mapping.findForward("viewAttendsSearch");
    }

    private SearchExecutionCourseAttendsBean readSearchBean(HttpServletRequest request, ExecutionCourse executionCourse) {
        String shifts;
        String degreeCurricularPlans;
        String workingStudentTypes;
        String executionCourseID = request.getParameter("executionCourse");
        SearchExecutionCourseAttendsBean searchExecutionCourseAttendsBean = executionCourseID != null ? new SearchExecutionCourseAttendsBean((ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID)) : new SearchExecutionCourseAttendsBean(executionCourse);
        String viewPhoto = request.getParameter("viewPhoto");
        if (viewPhoto != null && viewPhoto.equalsIgnoreCase("true")) {
            searchExecutionCourseAttendsBean.setViewPhoto(true);
        } else {
            searchExecutionCourseAttendsBean.setViewPhoto(false);
        }
        String attendsStates = request.getParameter("attendsStates");
        if (attendsStates != null) {
            ArrayList<Attends.StudentAttendsStateType> list = new ArrayList<Attends.StudentAttendsStateType>();
            for (String attendsState : attendsStates.split(":")) {
                list.add(Attends.StudentAttendsStateType.valueOf(attendsState));
            }
            searchExecutionCourseAttendsBean.setAttendsStates(list);
        }
        if ((workingStudentTypes = request.getParameter("workingStudentTypes")) != null) {
            ArrayList<WorkingStudentSelectionType> list = new ArrayList<WorkingStudentSelectionType>();
            for (String workingStudentType : workingStudentTypes.split(":")) {
                list.add(WorkingStudentSelectionType.valueOf(workingStudentType));
            }
            searchExecutionCourseAttendsBean.setWorkingStudentTypes(list);
        }
        if ((degreeCurricularPlans = request.getParameter("degreeCurricularPlans")) != null) {
            ArrayList<DegreeCurricularPlan> list = new ArrayList<DegreeCurricularPlan>();
            for (String degreeCurricularPlan : degreeCurricularPlans.split(":")) {
                list.add((DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlan));
            }
            searchExecutionCourseAttendsBean.setDegreeCurricularPlans(list);
        }
        if ((shifts = request.getParameter("shifts")) != null) {
            ArrayList<Shift> list = new ArrayList<Shift>();
            for (String shift : shifts.split(":")) {
                if (StringUtils.isEmpty((String)shift)) continue;
                list.add((Shift)FenixFramework.getDomainObject((String)shift));
            }
            searchExecutionCourseAttendsBean.setShifts(list);
        }
        return searchExecutionCourseAttendsBean;
    }

    private void prepareAttendsCollectionPages(HttpServletRequest request, SearchExecutionCourseAttendsBean searchExecutionCourseAttendsBean, ExecutionCourse executionCourse) {
        Collection<Attends> executionCourseAttends = searchExecutionCourseAttendsBean.getAttendsResult();
        ArrayList<Attends> listExecutionCourseAttends = new ArrayList<Attends>(executionCourseAttends);
        Collections.sort(listExecutionCourseAttends, Attends.COMPARATOR_BY_STUDENT_NUMBER);
        CollectionPager<Attends> pager = new CollectionPager<Attends>(listExecutionCourseAttends, 50);
        request.setAttribute("numberOfPages", (Object)(listExecutionCourseAttends.size() / 50 + 1));
        String pageParameter = request.getParameter("pageNumber");
        Integer page = StringUtils.isEmpty((String)pageParameter) ? Integer.valueOf(1) : Integer.valueOf(pageParameter);
        request.setAttribute("pageNumber", (Object)page);
        SearchExecutionCourseAttendsBean attendsPagesBean = new SearchExecutionCourseAttendsBean(executionCourse);
        executionCourse.searchAttends(attendsPagesBean);
        HashMap<Integer, Integer> enrolmentsNumberMap = new HashMap<Integer, Integer>();
        for (Attends attends : pager.getCollection()) {
            executionCourse.addAttendsToEnrolmentNumberMap(attends, enrolmentsNumberMap);
        }
        attendsPagesBean.setEnrolmentsNumberMap(enrolmentsNumberMap);
        attendsPagesBean.setAttendsResult(pager.getPage(page));
        if (searchExecutionCourseAttendsBean.getViewPhoto().booleanValue()) {
            attendsPagesBean.setViewPhoto(true);
        }
        request.setAttribute("attendsPagesBean", (Object)attendsPagesBean);
    }

    public ActionForward sendEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Object sender;
        String label;
        Group studentsGroup = null;
        SearchExecutionCourseAttendsBean bean = (SearchExecutionCourseAttendsBean)this.getRenderedObject("mailViewState");
        if (bean != null) {
            ExecutionCourse executionCourse = bean.getExecutionCourse();
            studentsGroup = bean.getAttendsGroup();
            label = bean.getLabel();
            sender = ExecutionCourseSender.newInstance(executionCourse);
        } else {
            SearchDegreeStudentsGroup degreeStudentsGroup = SearchDegreeStudentsGroup.parse((String)this.getFromRequestOrForm(request, (DynaActionForm)form, "searchGroup"));
            label = degreeStudentsGroup.getLabel();
            String executionDegreeId = (String)this.getFromRequestOrForm(request, (DynaActionForm)form, "executionDegreeId");
            studentsGroup = degreeStudentsGroup.getUserGroup();
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
            sender = CoordinatorSender.newInstance(executionDegree.getDegree());
        }
        Recipient recipient = Recipient.newInstance(label, studentsGroup);
        return EmailsDA.sendEmail(request, (Sender)((Object)sender), recipient);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("objectCode", request.getAttribute("objectCode"));
        SearchExecutionCourseAttendsBean bean = (SearchExecutionCourseAttendsBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        bean.getExecutionCourse().searchAttends(bean);
        request.setAttribute("searchBean", (Object)bean);
        request.setAttribute("executionCourse", (Object)bean.getExecutionCourse());
        this.prepareAttendsCollectionPages(request, bean, bean.getExecutionCourse());
        return mapping.findForward("viewAttendsSearch");
    }
}

