/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.TreeSet;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.util.DateFormatUtil;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class ShiftPlainRenderer
extends OutputRenderer {
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                if (object == null) {
                    return new HtmlText();
                }
                Shift shift = (Shift)((Object)object);
                StringBuilder lessonsLabel = new StringBuilder();
                int index = 0;
                TreeSet<Lesson> shiftLessons = new TreeSet<Lesson>(Lesson.LESSON_COMPARATOR_BY_WEEKDAY_AND_STARTTIME);
                shiftLessons.addAll(shift.getAssociatedLessonsSet());
                for (Lesson lesson : shiftLessons) {
                    ++index;
                    lessonsLabel.append(lesson.getDiaSemana().toString()).append(" (");
                    lessonsLabel.append(DateFormatUtil.format("HH:mm", lesson.getInicio().getTime())).append("-");
                    lessonsLabel.append(DateFormatUtil.format("HH:mm", lesson.getFim().getTime())).append(") ");
                    if (lesson.hasSala()) {
                        lessonsLabel.append(lesson.getSala().getName());
                    }
                    if (index < shift.getAssociatedLessonsSet().size()) {
                        lessonsLabel.append(" ; ");
                        continue;
                    }
                    lessonsLabel.append(" ");
                }
                return new HtmlText(lessonsLabel.toString());
            }
        };
    }
}

