/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.ui.renderers.PersonNameRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;

public class PersonNameWithAliasRenderer
extends PersonNameRenderer {
    private String label;
    private String bundle;
    private boolean key;
    private String labelClass;
    private String labelStyle;

    public PersonNameWithAliasRenderer() {
        this.setKey(true);
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabelClass() {
        return this.labelClass;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    public String getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    @Override
    public HtmlComponent render(Object object, Class type) {
        Person person = (Person)((Object)object);
        if (person == null) {
            return super.render(object, type);
        }
        String name = person.getName();
        HtmlComponent component = super.render(name, String.class);
        return this.addLabel(person, component, person.getUsername());
    }

    private HtmlComponent addLabel(Person person, HtmlComponent component, String label) {
        if (label == null) {
            return component;
        }
        HtmlInlineContainer container = new HtmlInlineContainer();
        container.addChild(component);
        container.addChild((HtmlComponent)this.getStyledLabel(label));
        return container;
    }

    private HtmlText getStyledLabel(String label) {
        HtmlText text = new HtmlText("(" + label + ")");
        text.setClasses(this.getLabelClass());
        text.setStyle(this.getLabelStyle());
        return text;
    }
}

