/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.fenixedu.academic.util.StringFormatter;
import pt.ist.fenixWebFramework.renderers.StringRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;

public class PersonNameRenderer
extends StringRenderer {
    private boolean firstLastOnly;
    private boolean middleNamesInicials;
    private String normalizedName;

    public boolean isFirstLastOnly() {
        return this.firstLastOnly;
    }

    public void setFirstLastOnly(boolean firstLastOnly) {
        this.firstLastOnly = firstLastOnly;
    }

    public boolean isMiddleNamesInicials() {
        return this.middleNamesInicials;
    }

    public void setMiddleNamesInicials(boolean middleNamesInicials) {
        this.middleNamesInicials = middleNamesInicials;
    }

    public HtmlComponent render(Object object, Class type) {
        if (object != null) {
            String name = this.parseName((String)object);
            HtmlComponent component = super.render((Object)name, type);
            if (this.isFirstLastOnly() || this.isMiddleNamesInicials()) {
                component.setTitle(this.normalizedName);
            }
            return component;
        }
        return super.render(object, type);
    }

    private String parseName(String name) {
        this.normalizedName = this.capitalize(name.toLowerCase());
        String[] allNames = this.normalizedName.split("\\p{Space}+");
        if (allNames.length == 0) {
            return "";
        }
        if (allNames.length == 1) {
            return allNames[0];
        }
        String finalName = allNames[0];
        if (!this.isFirstLastOnly()) {
            for (int i = 1; i < allNames.length - 1; ++i) {
                if (this.isMiddleNamesInicials()) {
                    if (!Character.isUpperCase(allNames[i].charAt(0))) continue;
                    finalName = finalName + " " + allNames[i].substring(0, 1) + ".";
                    continue;
                }
                finalName = finalName + " " + allNames[i];
            }
        }
        finalName = finalName + " " + allNames[allNames.length - 1];
        return finalName;
    }

    private String capitalize(String text) {
        StringBuilder buffer = new StringBuilder();
        for (String part : text.split("\\p{Space}+")) {
            if (part.length() == 0) continue;
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(StringFormatter.capitalizeWord(part, false));
        }
        return buffer.toString();
    }
}

