/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.publico;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;

public class WrittenEvaluationsByRoomBackingBean
extends org.fenixedu.academic.ui.faces.bean.sop.evaluation.WrittenEvaluationsByRoomBackingBean {
    @Override
    public Map<InfoRoom, List<CalendarLink>> getWrittenEvaluationCalendarLinks() throws FenixServiceException {
        Collection<InfoRoom> rooms = this.getRoomsToDisplayMap();
        if (rooms != null) {
            HashMap<InfoRoom, List<CalendarLink>> calendarLinksMap = new HashMap<InfoRoom, List<CalendarLink>>();
            for (InfoRoom infoRoom : rooms) {
                Space room = infoRoom.getRoom();
                ArrayList<CalendarLink> calendarLinks = new ArrayList<CalendarLink>();
                for (Occupation roomOccupation : room.getOccupationSet()) {
                    if (!(roomOccupation instanceof WrittenEvaluationSpaceOccupation)) continue;
                    Set writtenEvaluations = ((WrittenEvaluationSpaceOccupation)roomOccupation).getWrittenEvaluationsSet();
                    for (WrittenEvaluation writtenEvaluation : writtenEvaluations) {
                        if (!this.verifyWrittenEvaluationExecutionPeriod(writtenEvaluation, this.getAcademicIntervalObject(), null)) continue;
                        ExecutionCourse executionCourse = (ExecutionCourse)((Object)writtenEvaluation.getAssociatedExecutionCoursesSet().iterator().next());
                        CalendarLink calendarLink = new CalendarLink(executionCourse, writtenEvaluation, I18N.getLocale());
                        calendarLink.setAsLink(false);
                        calendarLink.setLinkParameters(this.constructLinkParameters(executionCourse, writtenEvaluation));
                        calendarLinks.add(calendarLink);
                    }
                }
                calendarLinksMap.put(infoRoom, calendarLinks);
            }
            return calendarLinksMap;
        }
        return null;
    }

    private Map<String, String> constructLinkParameters(ExecutionCourse executionCourse, WrittenEvaluation writtenEvaluation) {
        HashMap<String, String> linkParameters = new HashMap<String, String>();
        linkParameters.put("executionCourseID", executionCourse.getExternalId().toString());
        linkParameters.put("method", "firstPage");
        return linkParameters;
    }
}

