/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.transactions;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.transactions.Transaction_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class Transaction
extends Transaction_Base {
    public static Comparator<Transaction> COMPARATOR_BY_TRANSACTION_DATE_TIME = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction leftTransaction, Transaction rightTransaction) {
            int comparationResult = leftTransaction.getTransactionDateDateTime().compareTo((ReadableInstant)rightTransaction.getTransactionDateDateTime());
            return comparationResult == 0 ? leftTransaction.getExternalId().compareTo(rightTransaction.getExternalId()) : comparationResult;
        }
    };

    public Transaction() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    @Deprecated
    public Double getValue() {
        return this.getValueBigDecimal().doubleValue();
    }

    @Deprecated
    public void setValue(Double value) {
        this.setValueBigDecimal(BigDecimal.valueOf(value));
    }

    public void delete() {
        this.setPersonAccount(null);
        this.setResponsiblePerson(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    @Deprecated
    public Date getTransactionDate() {
        DateTime dt = this.getTransactionDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setTransactionDate(Date date) {
        if (date == null) {
            this.setTransactionDateDateTime(null);
        } else {
            this.setTransactionDateDateTime(new DateTime(date.getTime()));
        }
    }
}

