/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.ExtraExamRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.fenixedu.academic.dto.student.StudentStatuteBean;

public class ExtraExamRequest
extends ExtraExamRequest_Base {
    protected ExtraExamRequest() {
    }

    public ExtraExamRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setEnrolment(bean.getEnrolment());
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        Registration registration = bean.getRegistration();
        ExecutionYear executionYear = bean.getExecutionYear();
        Enrolment enrolment = bean.getEnrolment();
        if (executionYear == null) {
            throw new DomainException("error.ExtraExamRequest.executionYear.cannot.be.null", new String[0]);
        }
        if (!registration.hasEnrolments(enrolment)) {
            throw new DomainException("error.ExtraExamRequest.registration.doesnot.have.enrolment", new String[0]);
        }
        if (!this.studentHasValidStatutes(registration, enrolment)) {
            throw new DomainException("error.ExtraExamRequest.registration.doesnot.have.valid.statutes", new String[0]);
        }
        if (this.registrationAlreadyHasRequest(registration, enrolment, executionYear)) {
            throw new DomainException("error.ExtraExamRequest.registration.already.has.same.request", enrolment.getName().getContent(), executionYear.getYear());
        }
    }

    private boolean registrationAlreadyHasRequest(Registration registration, Enrolment enrolment, ExecutionYear executionYear) {
        for (AcademicServiceRequest academicServiceRequest : registration.getAcademicServiceRequests(((Object)((Object)this)).getClass())) {
            ExtraExamRequest extraExamRequest = (ExtraExamRequest)((Object)academicServiceRequest);
            if (!extraExamRequest.hasEnrolment(enrolment) || !extraExamRequest.isFor(executionYear)) continue;
            return true;
        }
        return false;
    }

    private boolean studentHasValidStatutes(Registration registration, Enrolment enrolment) {
        Student student = registration.getStudent();
        for (StudentStatuteBean bean : student.getStatutes(enrolment.getExecutionPeriod())) {
            if (!bean.getStatuteType().isAssociativeLeaderStatute()) continue;
            return true;
        }
        for (StudentStatuteBean bean : student.getStatutes(enrolment.getExecutionPeriod().getPreviousExecutionPeriod())) {
            if (!bean.getStatuteType().isAssociativeLeaderStatute()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnrolment(Enrolment enrolment) {
        return this.getEnrolment() != null && this.getEnrolment().equals(enrolment);
    }

    public void setEnrolment(Enrolment enrolment) {
        throw new DomainException("error.ExtraExamRequest.cannot.modify.enrolment", new String[0]);
    }

    public String getEnrolmentName() {
        return this.getEnrolment() != null ? this.getEnrolment().getName().getContent() : "";
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.EXTRA_EXAM_REQUEST;
    }

    public EventType getEventType() {
        return null;
    }

    protected void disconnect() {
        super.setEnrolment(null);
        super.disconnect();
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        super.createAcademicServiceRequestSituations(academicServiceRequestBean);
        if (academicServiceRequestBean.isToConclude()) {
            AcademicServiceRequestSituation.create((AcademicServiceRequest)((Object)this), new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, academicServiceRequestBean.getResponsible()));
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        }
        if (academicServiceRequestBean.isToCancelOrReject()) {
            this.setEnrolment(null);
        }
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

