/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import java.util.Optional;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcess;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserLoginPeriod;

public class ConcludePhdProcess
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isConcluded()) {
            throw new PreConditionNotValidException();
        }
        if (!this.isStudentCurricularPlanFinishedForPhd(process2)) {
            throw new PreConditionNotValidException();
        }
    }

    private boolean isStudentCurricularPlanFinishedForPhd(PhdThesisProcess process2) {
        return Optional.ofNullable(process2.getIndividualProgramProcess().getRegistration()).map(r -> r.getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).isConclusionProcessed()).orElse(Boolean.TRUE);
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdConclusionProcessBean bean = (PhdConclusionProcessBean)object;
        PhdConclusionProcess.create(bean, userView.getPerson());
        PhdIndividualProgramProcess individualProgramProcess = process2.getIndividualProgramProcess();
        if (!PhdIndividualProgramProcessState.CONCLUDED.equals(individualProgramProcess.getActiveState())) {
            individualProgramProcess.createState(PhdIndividualProgramProcessState.CONCLUDED, userView.getPerson(), "");
        }
        UserLoginPeriod.createOpenPeriod((User)process2.getPerson().getUser());
        return process2;
    }
}

