/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.seminar;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcess;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessStateType;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarState_Base;
import org.joda.time.DateTime;

public class PublicPresentationSeminarState
extends PublicPresentationSeminarState_Base {
    private PublicPresentationSeminarState() {
    }

    PublicPresentationSeminarState(PublicPresentationSeminarProcess process2, PublicPresentationSeminarProcessStateType type, Person person, String remarks, DateTime stateDate) {
        this();
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PublicPresentationSeminarState.invalid.process", args);
        }
        String[] args1 = new String[]{};
        if (type == null) {
            throw new DomainException("error.PublicPresentationSeminarState.invalid.type", args1);
        }
        this.checkType(process2, type);
        this.setProcess(process2);
        super.init(person, remarks, stateDate, (PhdProcessStateType)type);
        this.setType(type);
    }

    protected void init(Person person, String remarks, DateTime stateDate) {
        throw new RuntimeException("invoke other init");
    }

    private void checkType(PublicPresentationSeminarProcess process2, PublicPresentationSeminarProcessStateType type) {
        PublicPresentationSeminarProcessStateType currentType = process2.getActiveState();
        if (currentType != null && currentType.equals(type)) {
            throw new PhdDomainOperationException("error.PublicPresentationSeminarState.equals.previous.state", type.getLocalizedName());
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    public boolean isLast() {
        return this.getProcess().getMostRecentState() == this;
    }

    public static PublicPresentationSeminarState createWithInferredStateDate(PublicPresentationSeminarProcess process2, PublicPresentationSeminarProcessStateType type, Person person, String remarks) {
        DateTime stateDate = null;
        PublicPresentationSeminarState mostRecentState = process2.getMostRecentState();
        switch (type) {
            case WAITING_FOR_COMMISSION_CONSTITUTION: {
                if (process2.getPresentationRequestDate() == null) {
                    throw new PhdDomainOperationException("error.phd.seminar.PublicPresentationSeminarState.presentationRequestDate.required", new String[0]);
                }
                stateDate = process2.getPresentationRequestDate().toDateTimeAtStartOfDay();
                break;
            }
            case COMMISSION_WAITING_FOR_VALIDATION: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case COMMISSION_VALIDATED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case PUBLIC_PRESENTATION_DATE_SCHEDULED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case REPORT_WAITING_FOR_VALIDATION: {
                if (process2.getMostRecentStateByType(PublicPresentationSeminarProcessStateType.REPORT_WAITING_FOR_VALIDATION) != null) {
                    stateDate = mostRecentState.getStateDate().plusMinutes(1);
                    break;
                }
                if (process2.getPresentationDate() == null) {
                    throw new PhdDomainOperationException("error.phd.seminar.PublicPresentationSeminarState.presentationDate.required", new String[0]);
                }
                stateDate = process2.getPresentationDate().toDateTimeAtStartOfDay();
                break;
            }
            case REPORT_VALIDATED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case EXEMPTED: {
                stateDate = new DateTime();
            }
        }
        return PublicPresentationSeminarState.createWithGivenStateDate(process2, type, person, remarks, stateDate);
    }

    public static PublicPresentationSeminarState createWithGivenStateDate(PublicPresentationSeminarProcess process2, PublicPresentationSeminarProcessStateType type, Person person, String remarks, DateTime stateDate) {
        List<PublicPresentationSeminarProcessStateType> possibleNextStates = PublicPresentationSeminarProcessStateType.getPossibleNextStates(process2);
        if (!possibleNextStates.contains(type)) {
            String expectedStatesDescription = PublicPresentationSeminarState.buildExpectedStatesDescription(possibleNextStates);
            throw new PhdDomainOperationException("error.phd.seminar.PublicPresentationSeminarState.invalid.next.state", type.getLocalizedName(), expectedStatesDescription);
        }
        return new PublicPresentationSeminarState(process2, type, person, remarks, stateDate);
    }
}

