/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.period;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.GenericApplication;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.period.GenericApplicationPeriod$callable$createApplication;
import org.fenixedu.academic.domain.period.GenericApplicationPeriod$callable$removeManagerService;
import org.fenixedu.academic.domain.period.GenericApplicationPeriod_Base;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GenericApplicationPeriod
extends GenericApplicationPeriod_Base {
    public static final Comparator<GenericApplicationPeriod> COMPARATOR_BY_DATES;
    public static final Advice advice$createApplication;
    public static final Advice advice$removeManagerService;

    public GenericApplicationPeriod(MultiLanguageString title, MultiLanguageString description, DateTime start, DateTime end) {
        this.setTitle(title);
        this.setDescription(description);
        this.setPeriodNumber(Bennu.getInstance().getCandidacyPeriodsSet().size());
        this.init((ExecutionInterval)((Object)ExecutionYear.readCurrentExecutionYear()), start, end);
    }

    public String generateApplicationNumber() {
        return "C" + new LocalDate().getYear() + "/" + this.getPeriodNumber() + "/" + (this.getGenericApplicationSet().size() + 1);
    }

    public static SortedSet<GenericApplicationPeriod> getPeriods() {
        TreeSet<GenericApplicationPeriod> result = new TreeSet<GenericApplicationPeriod>(COMPARATOR_BY_DATES);
        for (CandidacyPeriod candidacyPeriod : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!(candidacyPeriod instanceof GenericApplicationPeriod)) continue;
            result.add((GenericApplicationPeriod)((Object)candidacyPeriod));
        }
        return result;
    }

    public GenericApplication createApplication(String string) {
        return (GenericApplication)((Object)advice$createApplication.perform((Callable)new GenericApplicationPeriod$callable$createApplication(this, string)));
    }

    static /* synthetic */ GenericApplication advised$createApplication(GenericApplicationPeriod this_, String email) {
        if (this_.getStart().isAfterNow() || this_.getEnd().isBeforeNow()) {
            throw new DomainException("message.application.submission.period.ended", new String[0]);
        }
        for (GenericApplication genericApplication : this_.getGenericApplicationSet()) {
            if (!genericApplication.getEmail().equalsIgnoreCase(email)) continue;
            genericApplication.sendEmailForApplication();
            return genericApplication;
        }
        return new GenericApplication(this_, email);
    }

    public SortedSet<GenericApplication> getOrderedGenericApplicationSet() {
        TreeSet<GenericApplication> result = new TreeSet<GenericApplication>(GenericApplication.COMPARATOR_BY_APPLICATION_NUMBER);
        result.addAll(this.getGenericApplicationSet());
        return result;
    }

    public void removeManagerService(User user) {
        Object object = advice$removeManagerService.perform((Callable)new GenericApplicationPeriod$callable$removeManagerService(this, user));
    }

    static /* synthetic */ void advised$removeManagerService(GenericApplicationPeriod this_, User user) {
        if (this_.isCurrentUserAllowedToMange()) {
            this_.removeManager(user);
        }
    }

    public boolean isCurrentUserAllowedToMange() {
        User userView = Authenticate.getUser();
        return userView != null && (RoleType.MANAGER.isMember(userView.getPerson().getUser()) || this.getManagerSet().contains(userView.getPerson().getUser()));
    }

    static {
        advice$createApplication = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeManagerService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_DATES = new Comparator<GenericApplicationPeriod>(){

            @Override
            public int compare(GenericApplicationPeriod o1, GenericApplicationPeriod o2) {
                int s = o1.getStart().compareTo((ReadableInstant)o2.getStart());
                if (s == 0) {
                    int e = o1.getEnd().compareTo((ReadableInstant)o2.getEnd());
                    return e == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : e;
                }
                return s;
            }
        };
    }
}

