/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publicRelationsOffice;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry;
import org.fenixedu.academic.domain.alumni.CerimonyInquiryAnswer;
import org.fenixedu.academic.domain.alumni.CerimonyInquiryPerson;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.messaging.EmailsDA;
import org.fenixedu.academic.ui.struts.action.publicRelationsOffice.PublicRelationsApplication;
import org.fenixedu.academic.ui.struts.action.publicRelationsOffice.UsernameFileBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicRelationsApplication.class, path="alumni-cerimony", titleKey="label.publicRelationOffice.alumniCerimony.inquiries")
@Mapping(path="/alumniCerimony", module="publicRelations")
@Forwards(value={@Forward(name="manageAlumniCerimony", path="/publicRelations/alumni/manageAlumniCerimony.jsp"), @Forward(name="viewAlumniCerimonyInquiry", path="/publicRelations/alumni/viewAlumniCerimonyInquiry.jsp"), @Forward(name="editAlumniCerimonyInquiry", path="/publicRelations/alumni/editAlumniCerimonyInquiry.jsp"), @Forward(name="editAlumniCerimonyInquiryAnswer", path="/publicRelations/alumni/editAlumniCerimonyInquiryAnswer.jsp"), @Forward(name="viewAlumniCerimonyInquiryAnswer", path="/publicRelations/alumni/viewAlumniCerimonyInquiryAnswer.jsp"), @Forward(name="addPeopleToCerimonyInquiry", path="/publicRelations/alumni/addPeopleToCerimonyInquiry.jsp"), @Forward(name="viewInquiryPeople", path="/publicRelations/alumni/viewInquiryPeople.jsp")})
public class AlumniCerimonyDA
extends FenixDispatchAction {
    private static final String LOCALDATE_FORMAT = "yyyy-MM-dd";
    protected static final String MODULE = "alumni";

    @EntryPoint
    public ActionForward manage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set cerimonyInquirySet = rootDomainObject.getCerimonyInquirySet();
        request.setAttribute("cerimonyInquirySet", new TreeSet(cerimonyInquirySet));
        return mapping.findForward("manageAlumniCerimony");
    }

    public ActionForward deleteInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        cerimonyInquiry.delete();
        return this.manage(mapping, form, request, response);
    }

    public ActionForward forwardToInquiry(ActionMapping mapping, HttpServletRequest request, String forward) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        return this.forwardToInquiry(mapping, request, forward, cerimonyInquiry);
    }

    public ActionForward forwardToInquiry(ActionMapping mapping, HttpServletRequest request, String forward, CerimonyInquiry cerimonyInquiry) throws Exception {
        request.setAttribute("cerimonyInquiry", (Object)cerimonyInquiry);
        return mapping.findForward(forward);
    }

    public ActionForward viewInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.forwardToInquiry(mapping, request, "viewAlumniCerimonyInquiry");
    }

    public ActionForward createNewInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = CerimonyInquiry.createNew();
        return this.forwardToInquiry(mapping, request, "editAlumniCerimonyInquiry", cerimonyInquiry);
    }

    public ActionForward editInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.forwardToInquiry(mapping, request, "editAlumniCerimonyInquiry");
    }

    public ActionForward addInquiryAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        CerimonyInquiryAnswer cerimonyInquiryAnswer = cerimonyInquiry.createNewAnswer();
        return this.editInquiryAnswer(mapping, request, cerimonyInquiryAnswer);
    }

    public ActionForward editInquiryAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiryAnswer cerimonyInquiryAnswer = (CerimonyInquiryAnswer)this.getDomainObject(request, "cerimonyInquiryAnswerId");
        return this.editInquiryAnswer(mapping, request, cerimonyInquiryAnswer);
    }

    public ActionForward editInquiryAnswer(ActionMapping mapping, HttpServletRequest request, CerimonyInquiryAnswer cerimonyInquiryAnswer) throws Exception {
        request.setAttribute("cerimonyInquiryAnswer", (Object)cerimonyInquiryAnswer);
        return this.forwardToInquiry(mapping, request, "editAlumniCerimonyInquiryAnswer");
    }

    public ActionForward deleteInquiryAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiryAnswer cerimonyInquiryAnswer = (CerimonyInquiryAnswer)this.getDomainObject(request, "cerimonyInquiryAnswerId");
        CerimonyInquiry cerimonyInquiry = cerimonyInquiryAnswer.getCerimonyInquiry();
        cerimonyInquiryAnswer.delete();
        RenderUtils.invalidateViewState();
        return this.forwardToInquiry(mapping, request, "viewAlumniCerimonyInquiry", cerimonyInquiry);
    }

    public ActionForward viewInquiryAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiryAnswer cerimonyInquiryAnswer = (CerimonyInquiryAnswer)this.getDomainObject(request, "cerimonyInquiryAnswerId");
        request.setAttribute("cerimonyInquiryAnswer", (Object)cerimonyInquiryAnswer);
        return this.forwardToInquiry(mapping, request, "viewAlumniCerimonyInquiryAnswer");
    }

    public ActionForward toggleObservationFlag(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        cerimonyInquiry.toggleObservationFlag();
        return this.forwardToInquiry(mapping, request, "viewAlumniCerimonyInquiry", cerimonyInquiry);
    }

    public ActionForward prepareAddPeople(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        request.setAttribute("cerimonyInquiry", (Object)cerimonyInquiry);
        UsernameFileBean usernameFileBean = new UsernameFileBean();
        request.setAttribute("usernameFileBean", (Object)usernameFileBean);
        return mapping.findForward("addPeopleToCerimonyInquiry");
    }

    public ActionForward addPeople(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        UsernameFileBean usernameFileBean = (UsernameFileBean)this.getRenderedObject();
        String contents = CharStreams.toString((Readable)new InputStreamReader(usernameFileBean.getInputStream(), Charset.defaultCharset()));
        Set<String> usernames = this.findUsernames(contents);
        cerimonyInquiry.addPeople(usernames);
        return this.forwardToInquiry(mapping, request, "viewAlumniCerimonyInquiry", cerimonyInquiry);
    }

    private Set<String> findUsernames(String contents) {
        HashSet<String> result = new HashSet<String>();
        for (String string : contents.split("\n")) {
            result.add(string.trim());
        }
        return result;
    }

    public ActionForward viewInquiryPeople(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        request.setAttribute("cerimonyInquiry", (Object)cerimonyInquiry);
        return mapping.findForward("viewInquiryPeople");
    }

    public ActionForward sendEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        Sender sender = this.getPublicRelationsSender();
        Recipient recipient = cerimonyInquiry.createRecipient();
        return EmailsDA.sendEmail(request, sender, recipient);
    }

    private Sender getPublicRelationsSender() {
        for (Sender sender : Sender.getAvailableSenders()) {
            if (!sender.getFromName().equalsIgnoreCase("Gabinete de Comunica\ufffd\ufffdo e Rela\ufffd\ufffdes P\ufffdblicas")) continue;
            return sender;
        }
        return null;
    }

    public ActionForward exportInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CerimonyInquiry cerimonyInquiry = (CerimonyInquiry)this.getDomainObject(request, "cerimonyInquiryId");
        if (cerimonyInquiry != null) {
            Set requests = cerimonyInquiry.getCerimonyInquiryPersonSet();
            String inquiryName = (cerimonyInquiry.getDescription() != null ? cerimonyInquiry.getDescription() : "UnnamedInquiry").replaceAll(" ", "_");
            String filename = BundleUtil.getString((String)"resources.AlumniResources", (String)"label.publicRelationOffice.alumniCerimony.inquiry.report", (String[])new String[0]) + "_" + inquiryName + "_" + new DateTime().toString("ddMMyyyyHHmmss");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
            ServletOutputStream writer = response.getOutputStream();
            this.exportToXls(requests, (OutputStream)writer);
            writer.flush();
            response.flushBuffer();
        }
        return null;
    }

    private void exportToXls(Collection<CerimonyInquiryPerson> requests, OutputStream os) throws IOException {
        StyledExcelSpreadsheet spreadsheet = new StyledExcelSpreadsheet(AlumniCerimonyDA.getResourceMessage("label.alumni.main.title"));
        this.fillSpreadSheet(requests, spreadsheet);
        spreadsheet.getWorkbook().write(os);
    }

    private void fillSpreadSheet(Collection<CerimonyInquiryPerson> requests, StyledExcelSpreadsheet sheet) {
        this.setHeaders(sheet);
        for (CerimonyInquiryPerson inquiryPerson : requests) {
            Person person = inquiryPerson.getPerson();
            CerimonyInquiryAnswer inquiryAnswer = inquiryPerson.getCerimonyInquiryAnswer();
            sheet.newRow();
            sheet.addCell((Object)person.getUsername());
            sheet.addCell((Object)person.getName());
            sheet.addCell((Object)person.getEmail());
            StringBuilder contacts = new StringBuilder();
            for (PartyContact partyContact : person.getPartyContactsSet()) {
                if (!(partyContact instanceof Phone) && !(partyContact instanceof MobilePhone)) continue;
                if (contacts.length() > 0) {
                    contacts.append(", ");
                }
                contacts.append(partyContact.getPresentationValue());
            }
            sheet.addCell((Object)contacts.toString());
            sheet.addCell((Object)(inquiryAnswer != null ? inquiryAnswer.getText() : new String("-")));
            sheet.addCell((Object)this.getDegrees(person));
            sheet.addCell((Object)inquiryPerson.getComment());
        }
    }

    private String getDegrees(Person person) {
        StringBuilder stringBuilder = new StringBuilder();
        Student student = person.getStudent();
        if (student != null) {
            TreeSet<String> names = new TreeSet<String>();
            for (Registration registration : student.getRegistrationsSet()) {
                Degree degree = registration.getDegree();
                names.add(degree.getSigla());
            }
            for (String name : names) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(name);
            }
        }
        return stringBuilder.toString();
    }

    private void setHeaders(StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.username"));
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.name"));
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.email"));
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.phone"));
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.publicRelationOffice.alumniCerimony.inquiry.people.answer"));
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.degrees"));
        spreadsheet.addHeader(AlumniCerimonyDA.getResourceMessage("label.observations"));
    }

    private static String getResourceMessage(String key) {
        return BundleUtil.getString((String)"resources.AlumniResources", (String)key, (String[])new String[0]);
    }
}

