/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.messaging;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;

public class SearchSendersBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String searchString;
    private String[] words;

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        this.words = searchString == null || searchString.trim().isEmpty() ? null : StringNormalizer.normalize((String)searchString).trim().split(" ");
    }

    public Set<Sender> getResult() {
        TreeSet<Sender> result = new TreeSet<Sender>(Sender.COMPARATOR_BY_FROM_NAME);
        if (this.searchString != null && !this.searchString.trim().isEmpty()) {
            for (Sender sender : Bennu.getInstance().getUtilEmailSendersSet()) {
                if (!this.match(sender.getFromName())) continue;
                result.add(sender);
            }
        }
        return result;
    }

    private boolean match(String fromName) {
        String n = StringNormalizer.normalize((String)fromName);
        for (String word : this.words) {
            if (n.indexOf(word) < 0) continue;
            return true;
        }
        return false;
    }
}

