/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager;

import java.io.Serializable;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Holiday;
import org.fenixedu.academic.domain.Locality;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.DeleteHoliday;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ManagerApplications.ManagerPeopleApp.class, path="manage-holidays", titleKey="label.manage.holidays", accessGroup="#managers")
@Mapping(module="manager", path="/manageHolidays")
@Forwards(value={@Forward(name="showHolidays", path="/manager/showHolidays.jsp")})
public class ManageHolidaysDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Set holidays = rootDomainObject.getHolidaysSet();
        request.setAttribute("holidays", (Object)holidays);
        return mapping.findForward("showHolidays");
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.executeFactoryMethod();
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String holidayIDString = request.getParameter("holidayID");
        if (holidayIDString != null && StringUtils.isNumeric((String)holidayIDString)) {
            Holiday holiday = (Holiday)FenixFramework.getDomainObject((String)holidayIDString);
            DeleteHoliday.run(holiday);
        }
        return this.prepare(mapping, form, request, response);
    }

    public static class HolidayFactoryCreator
    implements Serializable,
    FactoryExecutor {
        private Integer year;
        private Integer monthOfYear;
        private Integer dayOfMonth;
        private Locality localityReference;

        public Integer getDayOfMonth() {
            return this.dayOfMonth;
        }

        public void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        public Integer getMonthOfYear() {
            return this.monthOfYear;
        }

        public void setMonthOfYear(Integer monthOfYear) {
            this.monthOfYear = monthOfYear;
        }

        public Integer getYear() {
            return this.year;
        }

        public void setYear(Integer year) {
            this.year = year;
        }

        public Locality getLocality() {
            return this.localityReference;
        }

        public void setLocality(Locality locality) {
            if (locality != null) {
                this.localityReference = locality;
            }
        }

        public Holiday execute() {
            Partial date = new Partial();
            if (this.getYear() != null) {
                date = date.with(DateTimeFieldType.year(), this.getYear().intValue());
            }
            if (this.getMonthOfYear() != null) {
                date = date.with(DateTimeFieldType.monthOfYear(), this.getMonthOfYear().intValue());
            }
            if (this.getDayOfMonth() != null) {
                date = date.with(DateTimeFieldType.dayOfMonth(), this.getDayOfMonth().intValue());
            }
            return new Holiday(date, this.getLocality());
        }
    }
}

