/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EquivalencePlan;
import org.fenixedu.academic.domain.EquivalencePlanEntry;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.service.services.coordinator.DeleteEquivalencePlanEntry;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCurricularPlanBean;
import org.fenixedu.academic.ui.struts.action.coordinator.EquivalencePlanEntryCreator;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="coordinator", path="/degreeCurricularPlan/equivalencyPlan", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="showPlan", path="/coordinator/degreeCurricularPlan/showEquivalencyPlan.jsp")})
public class EquivalencyPlanDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        if (degreeCurricularPlan == null) {
            request.setAttribute("degreeCurricularPlans", DegreeCurricularPlan.getDegreeCurricularPlans(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree)));
        } else {
            request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
            DegreeCurricularPlanBean degreeCurricularPlanBean = new DegreeCurricularPlanBean(degreeCurricularPlan);
            request.setAttribute("degreeCurricularPlanBean", (Object)degreeCurricularPlanBean);
        }
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward showPlan(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("showPlan");
    }

    public ActionForward showTable(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("viewTable", (Object)Boolean.TRUE);
        DegreeModule degreeModule = this.getDegreeModule(request);
        if (degreeModule != null) {
            EquivalencePlan equivalencePlan = this.getEquivalencePlan(request);
            Set<EquivalencePlanEntry> equivalencePlanEntries = degreeModule.getNewDegreeModuleEquivalencePlanEntries(equivalencePlan);
            request.setAttribute("equivalencePlanEntries", equivalencePlanEntries);
        }
        return mapping.findForward("showPlan");
    }

    public ActionForward prepareAddEquivalency(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EquivalencePlan equivalencePlan;
        EquivalencePlanEntryCreator equivalencePlanEntryCreator = (EquivalencePlanEntryCreator)this.getRenderedObject();
        if (equivalencePlanEntryCreator == null) {
            equivalencePlan = this.getEquivalencePlan(request);
            DegreeModule degreeModule = this.getDegreeModule(request);
            equivalencePlanEntryCreator = new EquivalencePlanEntryCreator(equivalencePlan);
            equivalencePlanEntryCreator.setDestinationDegreeModuleToAdd(degreeModule);
            equivalencePlanEntryCreator.addDestination(degreeModule);
        } else {
            equivalencePlan = equivalencePlanEntryCreator.getEquivalencePlan();
            equivalencePlanEntryCreator.setDestinationDegreeModuleToAdd(null);
            equivalencePlanEntryCreator.setOriginDegreeModuleToAdd(null);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("equivalencePlan", (Object)equivalencePlan);
        request.setAttribute("equivalencePlanEntryCreator", (Object)equivalencePlanEntryCreator);
        return mapping.findForward("addEquivalency");
    }

    public ActionForward deleteEquivalency(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EquivalencePlanEntry equivalencePlanEntry = this.getEquivalencePlanEntry(request);
        DeleteEquivalencePlanEntry.runDeleteEquivalencePlanEntry(equivalencePlanEntry);
        return mapping.findForward("showPlan");
    }

    private EquivalencePlanEntry getEquivalencePlanEntry(HttpServletRequest request) {
        String equivalencePlanEntryIDString = request.getParameter("equivalencePlanEntryID");
        return (EquivalencePlanEntry)FenixFramework.getDomainObject((String)equivalencePlanEntryIDString);
    }

    private DegreeModule getDegreeModule(HttpServletRequest request) {
        String degreeModuleIDString = request.getParameter("degreeModuleID");
        return (DegreeModule)FenixFramework.getDomainObject((String)degreeModuleIDString);
    }

    private EquivalencePlan getEquivalencePlan(HttpServletRequest request) {
        String equivalencePlanIDString = request.getParameter("equivalencePlanID");
        return (EquivalencePlan)FenixFramework.getDomainObject((String)equivalencePlanIDString);
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        String degreeCurricularPlanIDString = request.getParameter("degreeCurricularPlanID");
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanIDString);
    }
}

