/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationGroupBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.NobodyGroup;
import pt.ist.fenixframework.FenixFramework;

public class AuthorizationsManagementBean
implements Serializable {
    private static final long serialVersionUID = 604369029723208403L;
    private AcademicOperationType operation;
    private List<AuthorizationGroupBean> groups;
    private static final Splitter SPLITTER = Splitter.on((char)';');

    public AuthorizationsManagementBean() {
    }

    public AuthorizationsManagementBean(AcademicOperationType operation) {
        this.operation = operation;
        if (operation != null) {
            this.groups = AcademicAccessRule.accessRules().filter(r -> r.getOperation().equals(operation)).map(AuthorizationGroupBean::new).collect(Collectors.toList());
        }
    }

    public AcademicOperationType getOperation() {
        return this.operation;
    }

    public boolean getHasNewObject() {
        for (AuthorizationGroupBean bean : this.groups) {
            if (!bean.getNewObject()) continue;
            return true;
        }
        return false;
    }

    public List<Degree> getDegrees() {
        ArrayList<Degree> degrees = new ArrayList<Degree>(Bennu.getInstance().getDegreesSet());
        Collections.sort(degrees);
        return degrees;
    }

    public List<PhdProgram> getPhdPrograms() {
        ArrayList<PhdProgram> programs = new ArrayList<PhdProgram>(Bennu.getInstance().getPhdProgramsSet());
        Collections.sort(programs, PhdProgram.COMPARATOR_BY_NAME);
        return programs;
    }

    public List<AuthorizationGroupBean> getGroups() {
        return this.groups;
    }

    public Set<DegreeType> getDegreeTypes() {
        return DegreeType.all().filter(type -> !type.isEmpty()).collect(Collectors.toSet());
    }

    public Set<AdministrativeOffice> getAdministrativeOffices() {
        return Bennu.getInstance().getAdministrativeOfficesSet();
    }

    public void removeAuthorization(String parameter) {
        AuthorizationGroupBean bean = this.getBeanByOid(parameter);
        if (bean != null) {
            if (bean.getRule() != null) {
                bean.revoke();
            }
            this.getGroups().remove(bean);
        }
    }

    public void editAuthorization(String parameter) {
        AuthorizationGroupBean bean = this.getBeanByOid(parameter);
        if (bean != null) {
            bean.edit();
        }
    }

    public void addNewAuthorization() {
        this.groups.add(0, new AuthorizationGroupBean());
    }

    private AuthorizationGroupBean getBeanByOid(String parameter) {
        for (AuthorizationGroupBean bean : this.getGroups()) {
            if (!bean.getId().equals(parameter)) continue;
            return bean;
        }
        return null;
    }

    public void createAuthorization(String courses, String officesStr) {
        AuthorizationGroupBean bean = this.getBeanByOid("-1");
        if (bean != null) {
            bean.create(this.operation, this.extractTargets(courses, officesStr));
        }
    }

    public void editAuthorizationPrograms(String oid, String courses, String officesStr) {
        AuthorizationGroupBean bean = this.getBeanByOid(oid);
        if (bean != null) {
            bean.editAuthorizationPrograms(this.operation, this.extractTargets(courses, officesStr));
        }
    }

    private Set<AcademicAccessRule.AcademicAccessTarget> extractTargets(String courses, String officesStr) {
        HashSet<AcademicAccessRule.AcademicAccessTarget> targets = new HashSet<AcademicAccessRule.AcademicAccessTarget>();
        if (!courses.trim().isEmpty()) {
            for (String course : SPLITTER.split((CharSequence)courses)) {
                AcademicProgram program = (AcademicProgram)FenixFramework.getDomainObject((String)course);
                targets.add(new AcademicAccessRule.AcademicProgramAccessTarget(program));
            }
        }
        if (!officesStr.trim().isEmpty()) {
            for (String officeStr : SPLITTER.split((CharSequence)officesStr)) {
                AdministrativeOffice office = (AdministrativeOffice)FenixFramework.getDomainObject((String)officeStr);
                targets.add(new AcademicAccessRule.AdministrativeOfficeAccessTarget(office));
            }
        }
        return targets;
    }

    public Set<User> getMembers() {
        if (this.operation != null) {
            TreeSet<User> members = new TreeSet<User>(User.COMPARATOR_BY_NAME);
            members.addAll(AcademicAccessRule.accessRules().filter(r -> r.getOperation().equals(this.operation)).map(r -> r.getWhoCanAccess()).reduce((result, group) -> result.or(group)).orElseGet(NobodyGroup::get).getMembers());
            return members;
        }
        return Collections.emptySet();
    }
}

