/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.teacher;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationManagementLog;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.InvalidMarkDomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceMultipleException;
import org.fenixedu.academic.service.services.teacher.WriteMarks$callable$writeByAttend;
import org.fenixedu.academic.service.services.teacher.WriteMarks$callable$writeByStudent;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class WriteMarks {
    public static final Advice advice$writeByStudent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$writeByAttend = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void writeByStudent(String string, String string2, List<StudentMark> list) throws FenixServiceException {
        Object object = advice$writeByStudent.perform((Callable)new WriteMarks$callable$writeByStudent(string, string2, list));
    }

    static /* synthetic */ void advised$writeByStudent(String executioCourseOID, String evaluationOID, List<StudentMark> marks) throws FenixServiceException {
        Evaluation evaluation = (Evaluation)FenixFramework.getDomainObject((String)evaluationOID);
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executioCourseOID);
        WriteMarks.writeMarks(WriteMarks.convertMarks(executionCourse, marks), executionCourse, evaluation);
    }

    public static void writeByAttend(String string, String string2, List<AttendsMark> list) throws FenixServiceException {
        Object object = advice$writeByAttend.perform((Callable)new WriteMarks$callable$writeByAttend(string, string2, list));
    }

    static /* synthetic */ void advised$writeByAttend(String executioCourseOID, String evaluationOID, List<AttendsMark> marks) throws FenixServiceException {
        Evaluation evaluation = (Evaluation)FenixFramework.getDomainObject((String)evaluationOID);
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executioCourseOID);
        WriteMarks.writeMarks(marks, executionCourse, evaluation);
    }

    private static List<AttendsMark> convertMarks(ExecutionCourse executionCourse, List<StudentMark> marks) throws FenixServiceMultipleException {
        ArrayList<DomainException> exceptionList = new ArrayList<DomainException>();
        ArrayList<AttendsMark> result = new ArrayList<AttendsMark>();
        for (StudentMark studentMark : marks) {
            Attends attend = WriteMarks.findAttend(executionCourse, studentMark.studentNumber, exceptionList);
            if (attend == null) continue;
            WriteMarks.addMark(result, studentMark, attend, exceptionList);
        }
        if (!exceptionList.isEmpty()) {
            throw new FenixServiceMultipleException(exceptionList);
        }
        return result;
    }

    private static void addMark(List<AttendsMark> result, StudentMark studentMark, Attends attend, List<DomainException> exceptionList) {
        if (studentMark.mark.length() - studentMark.mark.indexOf(46) - 1 > 2) {
            exceptionList.add(new DomainException("error.mark.more.than.two.decimals", studentMark.studentNumber));
        } else {
            result.add(new AttendsMark(attend.getExternalId(), studentMark.mark));
        }
    }

    private static Attends findAttend(ExecutionCourse executionCourse, String studentNumber, List<DomainException> exceptionList) {
        ArrayList<Attends> activeAttends = new ArrayList<Attends>(2);
        for (Attends attend : executionCourse.getAttendsSet()) {
            Student student = attend.getRegistration().getStudent();
            if (!student.getPerson().getUsername().equals(studentNumber) && !student.getNumber().toString().equals(studentNumber) || !WriteMarks.isActive(attend) && !WriteMarks.belongsToActiveExternalCycle(attend)) continue;
            activeAttends.add(attend);
        }
        if (activeAttends.size() == 1) {
            return (Attends)((Object)activeAttends.iterator().next());
        }
        if (activeAttends.isEmpty()) {
            exceptionList.add(new DomainException("errors.student.without.active.attends", studentNumber));
        } else {
            exceptionList.add(new DomainException("errors.student.with.several.active.attends", studentNumber));
        }
        return null;
    }

    private static boolean belongsToActiveExternalCycle(Attends attend) {
        CycleCurriculumGroup cycle;
        if (attend.getEnrolment() != null && (cycle = attend.getEnrolment().getParentCycleCurriculumGroup()) != null && cycle.isExternal()) {
            Student student = attend.getRegistration().getStudent();
            return student.getActiveRegistrationFor(cycle.getDegreeCurricularPlanOfDegreeModule()) != null;
        }
        return false;
    }

    private static boolean isActive(Attends attends) {
        RegistrationState state = attends.getEnrolment() != null ? attends.getEnrolment().getRegistration().getLastRegistrationState(attends.getExecutionYear()) : attends.getRegistration().getLastRegistrationState(attends.getExecutionYear());
        return state != null && state.isActive();
    }

    private static void writeMarks(List<AttendsMark> marks, ExecutionCourse executionCourse, Evaluation evaluation) throws FenixServiceMultipleException {
        ArrayList<DomainException> exceptionList = new ArrayList<DomainException>();
        for (AttendsMark entry : marks) {
            Attends attend = WriteMarks.findAttend(executionCourse, entry.attendId);
            String markValue = entry.mark;
            if (attend.getEnrolment() != null && attend.getEnrolment().isImpossible()) {
                exceptionList.add(new DomainException("errors.student.with.impossible.enrolment", attend.getRegistration().getStudent().getNumber().toString()));
                continue;
            }
            Mark mark = attend.getMarkByEvaluation(evaluation);
            if (WriteMarks.isToDeleteMark(markValue)) {
                if (mark == null) continue;
                mark.delete();
                continue;
            }
            try {
                if (mark == null) {
                    evaluation.addNewMark(attend, markValue);
                    continue;
                }
                mark.setMark(markValue);
            }
            catch (InvalidMarkDomainException e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            throw new FenixServiceMultipleException(exceptionList);
        }
        EvaluationManagementLog.createLog(executionCourse, "resources.MessagingResources", "log.executionCourse.evaluation.generic.edited.marks", evaluation.getPresentationName(), executionCourse.getName(), executionCourse.getDegreePresentationString());
    }

    private static Attends findAttend(ExecutionCourse executionCourse, String attendId) {
        for (Attends attend : executionCourse.getAttendsSet()) {
            if (!attend.getExternalId().equals(attendId)) continue;
            return attend;
        }
        return null;
    }

    private static boolean isToDeleteMark(String markValue) {
        return markValue == null || markValue.isEmpty();
    }

    public static class AttendsMark
    implements Serializable {
        private final String attendId;
        private final String mark;

        public AttendsMark(String attendId, String mark) {
            this.attendId = attendId;
            this.mark = mark;
        }
    }

    public static class StudentMark
    implements Serializable {
        private final String studentNumber;
        private final String mark;

        public StudentMark(String studentNumber, String mark) {
            this.studentNumber = studentNumber;
            this.mark = mark;
        }
    }
}

