/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons.student;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.dto.InfoEnrolment;
import org.fenixedu.academic.service.services.commons.student.ReadStudentListByCurricularCourse$callable$runReadStudentListByCurricularCourse;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadStudentListByCurricularCourse {
    private static final ReadStudentListByCurricularCourse serviceInstance;
    public static final Advice advice$runReadStudentListByCurricularCourse;

    protected List run(User userView, String curricularCourseID, String executionYear) throws FenixServiceException {
        CurricularCourse curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)curricularCourseID);
        return executionYear != null ? this.cleanList(curricularCourse.getEnrolmentsByYear(executionYear)) : this.cleanList(curricularCourse.getEnrolments());
    }

    private List cleanList(List<Enrolment> enrolmentList) throws FenixServiceException {
        if (enrolmentList.isEmpty()) {
            throw new NonExistingServiceException();
        }
        Integer studentNumber = null;
        ArrayList<InfoEnrolment> result = new ArrayList<InfoEnrolment>();
        for (Enrolment enrolment : enrolmentList) {
            if (studentNumber != null && studentNumber.intValue() == enrolment.getStudentCurricularPlan().getRegistration().getNumber().intValue()) continue;
            studentNumber = enrolment.getStudentCurricularPlan().getRegistration().getNumber();
            result.add(InfoEnrolment.newInfoFromDomain(enrolment));
        }
        Collections.sort(result, new BeanComparator("infoStudentCurricularPlan.infoStudent.number"));
        return result;
    }

    public static List runReadStudentListByCurricularCourse(User user, String string, String string2) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadStudentListByCurricularCourse.perform((Callable)new ReadStudentListByCurricularCourse$callable$runReadStudentListByCurricularCourse(user, string, string2));
    }

    static /* synthetic */ List advised$runReadStudentListByCurricularCourse(User userView, String curricularCourseID, String executionYear) throws FenixServiceException, NotAuthorizedException {
        return serviceInstance.run(userView, curricularCourseID, executionYear);
    }

    static {
        advice$runReadStudentListByCurricularCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ReadStudentListByCurricularCourse();
    }
}

