/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.phd.notification;

import java.util.Locale;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdCandidacyDeclarationDocument
extends FenixReport {
    private PhdProgramCandidacyProcess candidacyProcess;
    private Locale language;

    public PhdCandidacyDeclarationDocument(PhdProgramCandidacyProcess candidacyProcess, Locale language) {
        this.setCandidacyProcess(candidacyProcess);
        this.setLanguage(language);
        this.fillReport();
    }

    @Override
    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public PhdProgramCandidacyProcess getCandidacyProcess() {
        return this.candidacyProcess;
    }

    public void setCandidacyProcess(PhdProgramCandidacyProcess arg) {
        this.candidacyProcess = arg;
    }

    @Override
    protected void fillReport() {
        this.addParameter("name", this.getCandidacyProcess().getPerson().getName());
        this.addParameter("programName", this.getCandidacyProcess().getIndividualProgramProcess().getPhdProgram().getName().getContent(this.getLanguage()));
        this.addParameter("candidacyDate", this.getCandidacyProcess().getCandidacyDate());
        this.addParameter("currentDate", new LocalDate());
        this.addParameter("documentIdNumber", this.getCandidacyProcess().getPerson().getDocumentIdNumber());
        this.addParameter("candidacyNumber", this.getCandidacyProcess().getProcessNumber());
        this.addParameter("administrativeOfficeCoordinator", this.getCandidacyProcess().getIndividualProgramProcess().getPhdProgram().getAdministrativeOffice().getCoordinator().getProfile().getDisplayName());
        this.addParameter("institutionName", Bennu.getInstance().getInstitutionUnit().getPartyName().getContent());
        this.addParameter("universityName", UniversityUnit.getInstitutionsUniversityUnit().getPartyName().getContent());
    }

    @Override
    public String getReportFileName() {
        return "CandidacyDeclaration-" + new DateTime().toString("yyyyMMddHHmmss");
    }

    @Override
    public String getReportTemplateKey() {
        return this.getClass().getName() + "." + this.getLanguage().getLanguage();
    }
}

