/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.accounting;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.PaymentsManagementDTO;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class GuideDocument
extends FenixReport {
    private final PaymentsManagementDTO paymentsManagementDTO;

    public GuideDocument(PaymentsManagementDTO paymentsManagementDTO) {
        this.paymentsManagementDTO = paymentsManagementDTO;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        this.addParameter("total", this.paymentsManagementDTO.getTotalAmountToPay().toPlainString());
        this.addParameter("date", new LocalDate().toString("dd MMMM yyyy", this.getLocale()));
        this.addParameter("unitPhone", Bennu.getInstance().getInstitutionUnit().getDefaultPhoneNumber());
        this.addParameter("documentIdType", this.paymentsManagementDTO.getPerson().getIdDocumentType().getLocalizedName());
        this.addParameter("documentIdNumber", this.paymentsManagementDTO.getPerson().getDocumentIdNumber());
        this.addParameter("name", this.paymentsManagementDTO.getPerson().getName());
        this.addParameter("studentNumber", this.paymentsManagementDTO.getPerson().getStudent() != null ? this.paymentsManagementDTO.getPerson().getStudent().getNumber().toString() : null);
        this.addDataSourceElements(this.buildEntries());
    }

    private List<GuideDocumentEntry> buildEntries() {
        ArrayList<GuideDocumentEntry> result = new ArrayList<GuideDocumentEntry>();
        for (EntryDTO entryDTO : this.paymentsManagementDTO.getSelectedEntries()) {
            result.add(new GuideDocumentEntry(entryDTO.getDescription().toString(), entryDTO.getAmountToPay().toPlainString()));
        }
        return result;
    }

    @Override
    public String getReportFileName() {
        return "Guide-" + new DateTime().toString("yyyyMMddHHmmss", this.getLocale());
    }

    public static class GuideDocumentEntry {
        private String description;
        private String amountToPay;

        public GuideDocumentEntry(String description, String amountToPay) {
            this.description = description;
            this.amountToPay = amountToPay;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAmountToPay() {
            return this.amountToPay;
        }

        public void setAmountToPay(String amountToPay) {
            this.amountToPay = amountToPay;
        }
    }
}

