/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import java.util.List;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.util.EnrolmentGroupPolicyType;
import pt.ist.fenixframework.DomainObject;

public class InfoGrouping
extends InfoObject {
    private Integer maximumCapacity;
    private Integer minimumCapacity;
    private Integer idealCapacity;
    private EnrolmentGroupPolicyType enrolmentPolicy;
    private Integer groupMaximumNumber;
    private String name;
    private List infoExportGroupings;
    private ShiftType shiftType;
    private Calendar enrolmentBeginDay;
    private Calendar enrolmentEndDay;
    private String projectDescription;
    private List infoAttends;
    private Boolean automaticEnrolment;
    private Boolean differentiatedCapacity;
    private List<InfoShift> infoShifts;

    public InfoGrouping() {
    }

    public InfoGrouping(Integer maximumCapacity, Integer minimumCapacity, Integer idealCapacity, EnrolmentGroupPolicyType enrolmentPolicy, Integer groupMaximumNumber, List infoExportGroupings, String name, ShiftType shiftType, Calendar enrolmentBeginDay, Calendar enrolmentEndDay, String projectDescription, Boolean automaticEnrolment, Boolean differenciatedCapacity, List infoShifts) {
        this.maximumCapacity = maximumCapacity;
        this.minimumCapacity = minimumCapacity;
        this.idealCapacity = idealCapacity;
        this.enrolmentPolicy = enrolmentPolicy;
        this.groupMaximumNumber = groupMaximumNumber;
        this.infoExportGroupings = infoExportGroupings;
        this.name = name;
        this.shiftType = shiftType;
        this.enrolmentBeginDay = enrolmentBeginDay;
        this.enrolmentEndDay = enrolmentEndDay;
        this.projectDescription = projectDescription;
        this.automaticEnrolment = automaticEnrolment;
        this.differentiatedCapacity = differenciatedCapacity;
        this.infoShifts = infoShifts;
    }

    public String toString() {
        String result = "[INFO_GROUP_PROPERTIES";
        result = result + ", maximumCapacity=" + this.getMaximumCapacity();
        result = result + ", minimumCapacity=" + this.getMinimumCapacity();
        result = result + ", idealCapacity=" + this.getIdealCapacity();
        result = result + ", enrolmentPolicy=" + this.getEnrolmentPolicy();
        result = result + ", groupMaximumNumber=" + this.getGroupMaximumNumber();
        result = result + ", name=" + this.getName();
        result = result + ", shiftType=" + (Object)((Object)this.getShiftType());
        result = result + ", projectDescription=" + this.getProjectDescription();
        result = result + "]";
        return result;
    }

    public Integer getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public Integer getMinimumCapacity() {
        return this.minimumCapacity;
    }

    public Integer getIdealCapacity() {
        return this.idealCapacity;
    }

    public EnrolmentGroupPolicyType getEnrolmentPolicy() {
        return this.enrolmentPolicy;
    }

    public Integer getGroupMaximumNumber() {
        return this.groupMaximumNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public Calendar getEnrolmentBeginDay() {
        return this.enrolmentBeginDay;
    }

    public Calendar getEnrolmentEndDay() {
        return this.enrolmentEndDay;
    }

    public void setMaximumCapacity(Integer maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public void setMinimumCapacity(Integer minimumCapacity) {
        this.minimumCapacity = minimumCapacity;
    }

    public void setIdealCapacity(Integer idealCapacity) {
        this.idealCapacity = idealCapacity;
    }

    public void setEnrolmentPolicy(EnrolmentGroupPolicyType enrolmentPolicy) {
        this.enrolmentPolicy = enrolmentPolicy;
    }

    public void setGroupMaximumNumber(Integer groupMaximumNumber) {
        this.groupMaximumNumber = groupMaximumNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setShiftType(ShiftType shiftType) {
        this.shiftType = shiftType;
    }

    public void setEnrolmentBeginDay(Calendar enrolmentBeginDay) {
        this.enrolmentBeginDay = enrolmentBeginDay;
    }

    public void setEnrolmentEndDay(Calendar enrolmentEndDay) {
        this.enrolmentEndDay = enrolmentEndDay;
    }

    public String getShiftTypeFormatted() {
        return this.shiftType.toString();
    }

    public String getEnrolmentBeginDayFormatted() {
        String result = "";
        Calendar date = this.getEnrolmentBeginDay();
        if (date == null) {
            return result;
        }
        if (date.get(5) < 10) {
            result = result.concat("0");
        }
        result = result + date.get(5);
        result = result + "/";
        if (date.get(2) + 1 < 10) {
            result = result.concat("0");
        }
        result = result + (date.get(2) + 1);
        result = result + "/";
        result = result + date.get(1);
        return result;
    }

    public String getEnrolmentBeginHourFormatted() {
        String result = "";
        Calendar date = this.getEnrolmentBeginDay();
        if (date == null) {
            return result;
        }
        if (date.get(11) < 10) {
            result = result.concat("0");
        }
        result = result + date.get(11);
        result = result + ":";
        if (date.get(12) < 10) {
            result = result.concat("0");
        }
        result = result + date.get(12);
        return result;
    }

    public String getEnrolmentEndDayFormatted() {
        String result = "";
        Calendar date = this.getEnrolmentEndDay();
        if (date == null) {
            return result;
        }
        if (date.get(5) < 10) {
            result = result.concat("0");
        }
        result = result + date.get(5);
        result = result + "/";
        if (date.get(2) + 1 < 10) {
            result = result.concat("0");
        }
        result = result + (date.get(2) + 1);
        result = result + "/";
        result = result + date.get(1);
        return result;
    }

    public String getEnrolmentEndHourFormatted() {
        String result = "";
        Calendar date = this.getEnrolmentEndDay();
        if (date == null) {
            return result;
        }
        if (date.get(11) < 10) {
            result = result.concat("0");
        }
        result = result + date.get(11);
        result = result + ":";
        if (date.get(12) < 10) {
            result = result.concat("0");
        }
        result = result + date.get(12);
        return result;
    }

    public void copyFromDomain(Grouping groupProperties) {
        super.copyFromDomain((DomainObject)groupProperties);
        if (groupProperties != null) {
            this.setName(groupProperties.getName());
            this.setProjectDescription(groupProperties.getProjectDescription());
            this.setShiftType(groupProperties.getShiftType());
            this.setEnrolmentPolicy(groupProperties.getEnrolmentPolicy());
            this.setGroupMaximumNumber(groupProperties.getGroupMaximumNumber());
            this.setIdealCapacity(groupProperties.getIdealCapacity());
            this.setMaximumCapacity(groupProperties.getMaximumCapacity());
            this.setMinimumCapacity(groupProperties.getMinimumCapacity());
            this.setEnrolmentBeginDay(groupProperties.getEnrolmentBeginDay());
            this.setEnrolmentEndDay(groupProperties.getEnrolmentEndDay());
            this.setAutomaticEnrolment(groupProperties.getAutomaticEnrolment());
            this.setDifferentiatedCapacity(groupProperties.getDifferentiatedCapacity());
        }
    }

    public static InfoGrouping newInfoFromDomain(Grouping groupProperties) {
        InfoGrouping infoGroupProperties = null;
        if (groupProperties != null) {
            infoGroupProperties = new InfoGrouping();
            infoGroupProperties.copyFromDomain(groupProperties);
        }
        return infoGroupProperties;
    }

    public List getInfoExportGroupings() {
        return this.infoExportGroupings;
    }

    public void setInfoExportGroupings(List infoExportGroupings) {
        this.infoExportGroupings = infoExportGroupings;
    }

    public List getInfoAttends() {
        return this.infoAttends;
    }

    public void setInfoAttends(List infoAttends) {
        this.infoAttends = infoAttends;
    }

    public List<InfoShift> getInfoShifts() {
        return this.infoShifts;
    }

    public void setInfoShifts(List<InfoShift> infoShifts) {
        this.infoShifts = infoShifts;
    }

    public Boolean getAutomaticEnrolment() {
        return this.automaticEnrolment;
    }

    public void setAutomaticEnrolment(Boolean automaticEnrolment) {
        this.automaticEnrolment = automaticEnrolment;
    }

    public Boolean getDifferentiatedCapacity() {
        return this.differentiatedCapacity;
    }

    public void setDifferentiatedCapacity(Boolean differentiatedCapacity) {
        this.differentiatedCapacity = differentiatedCapacity;
    }
}

