/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.reports.FlunkedReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class FlunkedReportFile
extends FlunkedReportFile_Base {
    public String getJobName() {
        return "Listagem de prescri\u00e7\u00f5es";
    }

    protected String getPrefix() {
        return "prescricoes";
    }

    public void renderReport(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("n\u00famero aluno");
        spreadsheet.setHeader("ciclo estudos");
        this.setDegreeHeaders(spreadsheet);
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!FlunkedReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree)) continue;
            for (Registration registration : degree.getRegistrationsSet()) {
                LinkedList states = new LinkedList();
                states.addAll(registration.getRegistrationStatesSet());
                CollectionUtils.filter(states, (Predicate)new Predicate(){

                    public boolean evaluate(Object item) {
                        return ((RegistrationState)item).getExecutionYear() != null && ((RegistrationState)item).getExecutionYear().equals(FlunkedReportFile.this.getExecutionYear());
                    }
                });
                Collections.sort(states, RegistrationState.DATE_COMPARATOR);
                if (states.isEmpty() || !((RegistrationState)states.getLast()).getStateType().equals((Object)RegistrationStateType.FLUNKED)) continue;
                Spreadsheet.Row row = spreadsheet.addRow();
                row.setCell(registration.getNumber());
                CycleType cycleType = registration.getCycleType(((RegistrationState)states.getLast()).getExecutionYear());
                row.setCell(cycleType != null ? cycleType.toString() : "");
                this.setDegreeCells(row, degree);
            }
        }
    }
}

