/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.reports.CourseLoadReportFile_Base;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class CourseLoadReportFile
extends CourseLoadReportFile_Base {
    public String getJobName() {
        return "Listagem de tipos de aula e carga hor\u00e1ria";
    }

    public String getDescription() {
        return this.getJobName() + " no formato " + this.getType().toUpperCase();
    }

    protected String getPrefix() {
        return "carga_horaria";
    }

    public void renderReport(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("Semestre");
        spreadsheet.setHeader("C\u00f3digo disciplina execu\u00e7\u00e3o");
        spreadsheet.setHeader("C\u00f3digo turno");
        spreadsheet.setHeader("Nome turno");
        spreadsheet.setHeader("Tipo aula");
        spreadsheet.setHeader("Carga horas aula inseridas");
        spreadsheet.setHeader("Horas aula sistema");
        spreadsheet.setHeader("Total turnos");
        for (ExecutionSemester executionSemester : this.getExecutionYear().getExecutionPeriodsSet()) {
            for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
                for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
                    for (Shift shift : courseLoad.getShiftsSet()) {
                        if (!shift.hasSchoolClassForDegreeType(this.getDegreeType())) continue;
                        Spreadsheet.Row row = spreadsheet.addRow();
                        row.setCell(executionSemester.getSemester());
                        row.setCell(GepReportFile.getExecutionCourseCode(executionCourse));
                        row.setCell(GepReportFile.getShiftCode(shift));
                        row.setCell(shift.getNome());
                        row.setCell(courseLoad.getType().name());
                        row.setCell(courseLoad.getTotalQuantity() != null ? courseLoad.getTotalQuantity().toPlainString().replace('.', ',') : "");
                        row.setCell(shift.getTotalHours() != null ? shift.getTotalHours().toPlainString().replace('.', ',') : "");
                        row.setCell(Integer.valueOf(courseLoad.getShiftsSet().size()));
                    }
                }
            }
        }
    }
}

