/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.person;

import java.util.ArrayList;
import java.util.Collection;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.IdDocumentTypeObject;
import org.fenixedu.academic.domain.person.IdDocument_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class IdDocument
extends IdDocument_Base {
    public IdDocument(Person person, String value, IdDocumentTypeObject idDocumentType) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setPerson(person);
        this.setIdDocumentType(idDocumentType);
        this.setValue(value);
    }

    public IdDocument(Person person, String value, IDDocumentType documentType) {
        this(person, value, IdDocumentTypeObject.readByIDDocumentType(documentType));
    }

    public static Collection<IdDocument> find(String idDocumentValue) {
        ArrayList<IdDocument> idDocuments = new ArrayList<IdDocument>();
        for (IdDocument idDocument : Bennu.getInstance().getIdDocumentsSet()) {
            if (!idDocument.getValue().equalsIgnoreCase(idDocumentValue)) continue;
            idDocuments.add(idDocument);
        }
        return idDocuments;
    }

    public void setIdDocumentType(IDDocumentType documentType) {
        super.setIdDocumentType(IdDocumentTypeObject.readByIDDocumentType(documentType));
    }

    public void delete() {
        this.setPerson(null);
        super.setIdDocumentType(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

