/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.mobility.outbound;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest$callable$delete;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest$callable$editVacancies;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest_Base;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OutboundMobilityCandidacyContest
extends OutboundMobilityCandidacyContest_Base
implements Comparable<OutboundMobilityCandidacyContest> {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$editVacancies = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OutboundMobilityCandidacyContest(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod, OutboundMobilityCandidacyContestGroup mobilityGroup, MobilityAgreement mobilityAgreement, Integer vacancies) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setOutboundMobilityCandidacyPeriod(outboundMobilityCandidacyPeriod);
        this.setMobilityAgreement(mobilityAgreement);
        this.setOutboundMobilityCandidacyContestGroup(mobilityGroup);
        for (ExecutionDegree executionDegree : mobilityGroup.getExecutionDegreeSet()) {
            this.addExecutionDegree(executionDegree);
        }
        this.setVacancies(vacancies);
    }

    @Override
    public int compareTo(OutboundMobilityCandidacyContest o) {
        int edc = this.compareDegrees(o);
        if (edc == 0) {
            int cc = this.compareCountries(o);
            if (cc == 0) {
                int uc = this.compareUniversities(o);
                if (uc == 0) {
                    int pc = this.comparePrograms(o);
                    return pc == 0 ? this.getExternalId().compareTo(o.getExternalId()) : pc;
                }
                return uc;
            }
            return cc;
        }
        return edc;
    }

    private int compareCountries(OutboundMobilityCandidacyContest o) {
        Country c2;
        Country c1 = this.getMobilityAgreement().getUniversityUnit().getCountry();
        return c1 == (c2 = o.getMobilityAgreement().getUniversityUnit().getCountry()) ? 0 : (c1 != null && c2 != null ? c1.getName().compareTo(c2.getName()) : (c1 == null ? -1 : 1));
    }

    private int comparePrograms(OutboundMobilityCandidacyContest o) {
        return this.getMobilityAgreement().getMobilityProgram().getRegistrationProtocol().getDescription().compareTo(o.getMobilityAgreement().getMobilityProgram().getRegistrationProtocol().getDescription());
    }

    private int compareUniversities(OutboundMobilityCandidacyContest o) {
        return Unit.COMPARATOR_BY_NAME_AND_ID.compare(this.getMobilityAgreement().getUniversityUnit(), o.getMobilityAgreement().getUniversityUnit());
    }

    private int compareDegrees(OutboundMobilityCandidacyContest o) {
        return this.executionDegreesCompareHash(o.getOutboundMobilityCandidacyContestGroup().getExecutionDegreeSet()).compareTo(this.executionDegreesCompareHash(this.getOutboundMobilityCandidacyContestGroup().getExecutionDegreeSet()));
    }

    private String executionDegreesCompareHash(Set<ExecutionDegree> executionDegreeSet) {
        TreeSet<String> strings = new TreeSet<String>();
        for (ExecutionDegree executionDegree : executionDegreeSet) {
            strings.add(executionDegree.getDegree().getSigla());
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        return builder.toString();
    }

    public boolean isAcceptingCandidacies() {
        return this.getOutboundMobilityCandidacyPeriod().isAcceptingCandidacies();
    }

    public boolean isAcceptingCandidacies(Student student) {
        return this.isAcceptingCandidacies() && this.findBestRegistration(student) != null;
    }

    public void apply(Student student) {
        Registration registration;
        if (this.isAcceptingCandidacies()) {
            registration = this.findBestRegistration(student);
            if (registration == null) {
                throw new DomainException("error.OutboundMobilityCandidacyContest.not.accepting.for.studnt", new String[0]);
            }
        } else {
            throw new DomainException("error.CandidacyPeriod.not.accepting.candidacies", new String[0]);
        }
        this.apply(registration);
    }

    private void apply(Registration registration) {
        OutboundMobilityCandidacySubmission.apply(this, registration);
    }

    public Registration findBestRegistration(Student student) {
        for (Registration registration : student.getRegistrationsSet()) {
            for (ExecutionDegree executionDegree : this.getOutboundMobilityCandidacyContestGroup().getExecutionDegreeSet()) {
                ExecutionYear executionYear;
                RegistrationState registrationState;
                if (executionDegree.getDegree() != registration.getDegree() || (registrationState = registration.getLastRegistrationState(executionYear = (ExecutionYear)((Object)this.getOutboundMobilityCandidacyPeriod().getExecutionInterval()))) == null || !registrationState.getStateType().isActive()) continue;
                return registration;
            }
        }
        return null;
    }

    public boolean hasCandidacy(Student student) {
        for (Registration registration : student.getRegistrationsSet()) {
            for (OutboundMobilityCandidacySubmission submission : registration.getOutboundMobilityCandidacySubmissionSet()) {
                for (OutboundMobilityCandidacy candidacy : submission.getOutboundMobilityCandidacySet()) {
                    if (candidacy.getOutboundMobilityCandidacyContest() != this) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addExecutionDegree(ExecutionDegree executionDegree) {
        super.addExecutionDegree(executionDegree);
        this.getExecutionDegreeSet().size();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new OutboundMobilityCandidacyContest$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(OutboundMobilityCandidacyContest this_) {
        OutboundMobilityCandidacyContestGroup mobilityGroup = this_.getOutboundMobilityCandidacyContestGroup();
        for (OutboundMobilityCandidacy candidacy : this_.getOutboundMobilityCandidacySet()) {
            candidacy.deleteWithNotification();
        }
        this_.getExecutionDegreeSet().clear();
        this_.setMobilityAgreement(null);
        this_.setOutboundMobilityCandidacyContestGroup(null);
        this_.setOutboundMobilityCandidacyPeriod(null);
        this_.setRootDomainObject(null);
        if (mobilityGroup != null && mobilityGroup.getOutboundMobilityCandidacyContestSet().size() == 0) {
            mobilityGroup.delete();
        }
        this_.deleteDomainObject();
    }

    public int countSelectedCandidates() {
        int c = 0;
        for (OutboundMobilityCandidacy candidacy : this.getOutboundMobilityCandidacySet()) {
            if (candidacy.getSubmissionFromSelectedCandidacy() == null) continue;
            ++c;
        }
        return c;
    }

    public boolean hasVacancy() {
        Integer vacancies = this.getVacancies();
        return vacancies == null || vacancies > this.countSelectedCandidates();
    }

    public void editVacancies(Integer n) {
        Object object = advice$editVacancies.perform((Callable)new OutboundMobilityCandidacyContest$callable$editVacancies(this, n));
    }

    static /* synthetic */ void advised$editVacancies(OutboundMobilityCandidacyContest this_, Integer vacancies) {
        this_.setVacancies(vacancies);
    }
}

