/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.Context_Base;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ContextPredicates;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class Context
extends Context_Base
implements Comparable<Context> {
    public static final Comparator<Context> COMPARATOR_BY_DEGREE_MODULE_NAME = new Comparator<Context>(){

        @Override
        public int compare(Context o1, Context o2) {
            DegreeModule d1 = o1.getChildDegreeModule();
            DegreeModule d2 = o2.getChildDegreeModule();
            int c = Collator.getInstance().compare(d1.getName(), d2.getName());
            return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)d1, (DomainObject)d2) : c;
        }
    };
    public static Comparator<Context> COMPARATOR_BY_CURRICULAR_YEAR = new Comparator<Context>(){

        @Override
        public int compare(Context leftContext, Context rightContext) {
            int comparationResult = leftContext.getCurricularYear().compareTo(rightContext.getCurricularYear());
            return comparationResult == 0 ? leftContext.getExternalId().compareTo(rightContext.getExternalId()) : comparationResult;
        }
    };

    protected Context() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setChildOrder(0);
    }

    public Context(CourseGroup courseGroup, DegreeModule degreeModule, CurricularPeriod curricularPeriod, ExecutionSemester begin, ExecutionSemester end) {
        this();
        this.checkParameters(courseGroup, degreeModule, begin);
        this.checkExecutionPeriods(begin, end);
        this.checkIfCanAddDegreeModuleToCourseGroup(courseGroup, degreeModule, curricularPeriod, begin.getExecutionYear());
        this.checkExistingCourseGroupContexts(courseGroup, degreeModule, curricularPeriod, begin, end);
        super.setParentCourseGroup(courseGroup);
        super.setChildDegreeModule(degreeModule);
        super.setCurricularPeriod(curricularPeriod);
        super.setBeginExecutionPeriod(begin);
        super.setEndExecutionPeriod(end);
    }

    private void checkIfCanAddDegreeModuleToCourseGroup(CourseGroup courseGroup, DegreeModule degreeModule, CurricularPeriod curricularPeriod, ExecutionYear executionYear) {
        if (degreeModule.isLeaf()) {
            this.checkIfCanAddCurricularCourseToCourseGroup(courseGroup, (CurricularCourse)((Object)degreeModule), curricularPeriod, executionYear);
        } else {
            this.checkIfCanAddCourseGroupToCourseGroup(courseGroup, (CourseGroup)((Object)degreeModule));
        }
    }

    private void checkIfCanAddCurricularCourseToCourseGroup(CourseGroup parent, CurricularCourse curricularCourse, CurricularPeriod curricularPeriod, ExecutionYear executionYear) {
        if (curricularCourse.getCompetenceCourse() != null && curricularCourse.getCompetenceCourse().isAnual(executionYear) && !curricularPeriod.hasChildOrderValue(1)) {
            throw new DomainException("competenceCourse.anual.but.trying.to.associate.curricular.course.not.to.first.period", new String[0]);
        }
    }

    private void checkIfCanAddCourseGroupToCourseGroup(CourseGroup parent, CourseGroup courseGroup) {
        parent.checkDuplicateChildNames(courseGroup.getName(), courseGroup.getNameEn());
    }

    private void checkParameters(CourseGroup courseGroup, DegreeModule degreeModule, ExecutionSemester beginExecutionPeriod) {
        if (courseGroup == null || degreeModule == null || beginExecutionPeriod == null) {
            throw new DomainException("error.incorrectContextValues", new String[0]);
        }
    }

    private void checkExistingCourseGroupContexts(CourseGroup courseGroup, DegreeModule degreeModule, CurricularPeriod curricularPeriod, ExecutionSemester begin, ExecutionSemester end) {
        for (Context context : courseGroup.getChildContextsSet()) {
            if (context == this || !context.hasChildDegreeModule(degreeModule) || !context.hasCurricularPeriod(curricularPeriod) || !context.intersects(begin, end)) continue;
            throw new DomainException("courseGroup.contextAlreadyExistForCourseGroup", new String[0]);
        }
    }

    public void edit(CourseGroup parent, CurricularPeriod curricularPeriod, ExecutionSemester begin, ExecutionSemester end) {
        this.setParentCourseGroup(parent);
        this.setCurricularPeriod(curricularPeriod);
        this.edit(begin, end);
    }

    protected void edit(ExecutionSemester begin, ExecutionSemester end) {
        this.checkExecutionPeriods(begin, end);
        this.checkExistingCourseGroupContexts(this.getParentCourseGroup(), this.getChildDegreeModule(), this.getCurricularPeriod(), begin, end);
        this.setBeginExecutionPeriod(begin);
        this.setEndExecutionPeriod(end);
        this.checkCurriculumLines(this.getChildDegreeModule());
    }

    private void checkCurriculumLines(DegreeModule degreeModule) {
        for (CurriculumModule curriculumModule : degreeModule.getCurriculumModulesSet()) {
            CurriculumLine curriculumLine;
            if (!curriculumModule.isCurriculumLine() || !(curriculumLine = (CurriculumLine)((Object)curriculumModule)).hasExecutionPeriod() || degreeModule.hasAnyOpenParentContexts(curriculumLine.getExecutionPeriod())) continue;
            throw new DomainException("error.Context.cannot.modify.begin.and.end.because.of.enroled.curriculumLines", new String[0]);
        }
    }

    public void delete() {
        DegreeModule degreeModule = this.getChildDegreeModule();
        this.setChildDegreeModule(null);
        this.checkCurriculumLines(degreeModule);
        this.setCurricularPeriod(null);
        this.setParentCourseGroup(null);
        super.setBeginExecutionPeriod(null);
        this.setEndExecutionPeriod(null);
        this.setRootDomainObject(null);
        this.getAssociatedWrittenEvaluationsSet().clear();
        super.deleteDomainObject();
    }

    @Override
    public int compareTo(Context o) {
        int orderCompare = this.getChildOrder().compareTo(o.getChildOrder());
        if (this.getParentCourseGroup().equals((Object)o.getParentCourseGroup()) && orderCompare != 0) {
            return orderCompare;
        }
        if (this.getChildDegreeModule() instanceof CurricularCourse) {
            int periodsCompare = this.getCurricularPeriod().compareTo(o.getCurricularPeriod());
            if (periodsCompare != 0) {
                return periodsCompare;
            }
            return Collator.getInstance().compare(this.getChildDegreeModule().getName(), o.getChildDegreeModule().getName());
        }
        return Collator.getInstance().compare(this.getChildDegreeModule().getName(), o.getChildDegreeModule().getName());
    }

    public void setParentCourseGroup(CourseGroup courseGroup) {
        AccessControl.check(this, ContextPredicates.curricularPlanMemberWritePredicate);
        super.setParentCourseGroup(courseGroup);
    }

    public void setCurricularPeriod(CurricularPeriod curricularPeriod) {
        AccessControl.check(this, ContextPredicates.curricularPlanMemberWritePredicate);
        super.setCurricularPeriod(curricularPeriod);
    }

    public void setChildDegreeModule(DegreeModule degreeModule) {
        AccessControl.check(this, ContextPredicates.curricularPlanMemberWritePredicate);
        super.setChildDegreeModule(degreeModule);
    }

    public boolean isValid(ExecutionSemester executionSemester) {
        if (this.isOpen(executionSemester)) {
            CurricularCourse curricularCourse;
            if (this.getChildDegreeModule().isCurricularCourse() && !(curricularCourse = (CurricularCourse)((Object)this.getChildDegreeModule())).isAnual(executionSemester.getExecutionYear())) {
                return this.containsSemester(executionSemester.getSemester());
            }
            return true;
        }
        return false;
    }

    public boolean isValid(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isValid(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(AcademicInterval academicInterval) {
        ExecutionInterval interval = ExecutionInterval.getExecutionInterval(academicInterval);
        if (interval instanceof ExecutionSemester) {
            return this.isValid((ExecutionSemester)((Object)interval));
        }
        if (interval instanceof ExecutionYear) {
            return this.isValid((ExecutionYear)((Object)interval));
        }
        throw new UnsupportedOperationException("Unknown academicIntervalType: " + academicInterval);
    }

    protected void checkExecutionPeriods(ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        if (beginExecutionPeriod == null) {
            throw new DomainException("context.begin.execution.period.cannot.be.null", new String[0]);
        }
        if (endExecutionPeriod != null && beginExecutionPeriod.isAfter(endExecutionPeriod)) {
            throw new DomainException("context.begin.is.after.end.execution.period", new String[0]);
        }
    }

    public boolean isOpen(ExecutionSemester executionSemester) {
        return this.getBeginExecutionPeriod().isBeforeOrEquals(executionSemester) && (this.getEndExecutionPeriod() == null || this.getEndExecutionPeriod().isAfterOrEquals(executionSemester));
    }

    public boolean isOpen(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isOpen(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen(ExecutionSemester.readActualExecutionSemester());
    }

    public boolean intersects(ExecutionSemester begin, ExecutionSemester end) {
        if (end != null && begin.isAfter(end)) {
            throw new DomainException("context.begin.is.after.end.execution.period", new String[0]);
        }
        if (begin.isAfterOrEquals(this.getBeginExecutionPeriod())) {
            return this.getEndExecutionPeriod() == null || begin.isBeforeOrEquals(this.getEndExecutionPeriod());
        }
        return end == null || end.isAfterOrEquals(this.getBeginExecutionPeriod());
    }

    public boolean containsInterval(ExecutionInterval begin, ExecutionInterval end) {
        if (begin.isAfterOrEquals((ExecutionInterval)((Object)this.getBeginExecutionPeriod()))) {
            return this.getEndExecutionPeriod() == null || end != null && !end.isAfter((ExecutionInterval)((Object)this.getEndExecutionPeriod()));
        }
        return false;
    }

    @Deprecated
    public Integer getOrder() {
        return super.getChildOrder();
    }

    @Deprecated
    public void setOrder(Integer order) {
        super.setChildOrder(order);
    }

    public boolean containsCurricularYear(Integer curricularYear) {
        CurricularPeriod firstCurricularPeriod = this.getCurricularPeriod().getParent();
        int firstCurricularPeriodOrder = firstCurricularPeriod.getAbsoluteOrderOfChild();
        return curricularYear == firstCurricularPeriodOrder;
    }

    public boolean containsSemester(Integer semester) {
        CurricularPeriod firstCurricularPeriod = this.getCurricularPeriod();
        int firstCurricularPeriodOrder = firstCurricularPeriod.getChildOrder();
        return semester == firstCurricularPeriodOrder;
    }

    public boolean containsSemesterAndCurricularYear(Integer semester, Integer curricularYear, RegimeType regimeType) {
        int duration;
        int argumentOrder = (curricularYear - 1) * 2 + semester;
        CurricularPeriod firstCurricularPeriod = this.getCurricularPeriod();
        int firstCurricularPeriodOrder = firstCurricularPeriod.getAbsoluteOrderOfChild();
        if (regimeType == RegimeType.ANUAL) {
            duration = 2;
        } else if (regimeType == RegimeType.SEMESTRIAL) {
            duration = 1;
        } else {
            throw new IllegalArgumentException("Unknown regimeType: " + (Object)((Object)regimeType));
        }
        int lastCurricularPeriodOrder = firstCurricularPeriodOrder + duration - 1;
        return firstCurricularPeriodOrder <= argumentOrder && argumentOrder <= lastCurricularPeriodOrder;
    }

    public DegreeModuleScopeContext getDegreeModuleScopeContext() {
        return new DegreeModuleScopeContext(this);
    }

    public void setBeginExecutionPeriod(ExecutionSemester beginExecutionPeriod) {
        if (beginExecutionPeriod == null) {
            throw new DomainException("curricular.rule.begin.execution.period.cannot.be.null", new String[0]);
        }
        super.setBeginExecutionPeriod(beginExecutionPeriod);
    }

    public void removeBeginExecutionPeriod() {
        super.setBeginExecutionPeriod(null);
    }

    public Integer getCurricularYear() {
        return this.getCurricularPeriod().getParent().getAbsoluteOrderOfChild();
    }

    public void addAllCourseGroups(Set<CourseGroup> courseGroups) {
        DegreeModule degreeModule = this.getChildDegreeModule();
        if (!degreeModule.isLeaf()) {
            CourseGroup courseGroup = (CourseGroup)((Object)degreeModule);
            courseGroups.add(courseGroup);
            courseGroup.getAllCoursesGroupse(courseGroups);
        }
    }

    public void getAllDegreeModules(Collection<DegreeModule> degreeModules) {
        DegreeModule degreeModule = this.getChildDegreeModule();
        degreeModule.getAllDegreeModules(degreeModules);
    }

    public boolean hasChildDegreeModule(DegreeModule degreeModule) {
        return this.getChildDegreeModule() != null && this.getChildDegreeModule().equals((Object)degreeModule);
    }

    public boolean hasCurricularPeriod(CurricularPeriod curricularPeriod) {
        return this.getCurricularPeriod() != null && this.getCurricularPeriod().equals(curricularPeriod);
    }

    static {
        Context.getRelationCourseGroupContext().addListener((RelationListener)new RelationAdapter<CourseGroup, Context>(){

            public void beforeAdd(CourseGroup courseGroup, Context context) {
                if (context != null && courseGroup != null) {
                    if (context.getChildDegreeModule() != null && context.getChildDegreeModule().isCycleCourseGroup()) {
                        this.validateCycleCourseGroupParent(context, courseGroup);
                    }
                    if (context.getChildDegreeModule() != null && context.getParentCourseGroup() != null && context.getParentCourseGroup().hasAnyParentBranchCourseGroup() && context.getChildDegreeModule().isBranchCourseGroup()) {
                        throw new DomainException("error.degreeStructure.BranchCourseGroup.cant.have.branch.parent", new String[0]);
                    }
                }
            }

            private void validateCycleCourseGroupParent(Context context, CourseGroup courseGroup) {
                CycleCourseGroup cycleCourseGroup = (CycleCourseGroup)((Object)context.getChildDegreeModule());
                if (cycleCourseGroup.getParentContextsSet().size() > 1) {
                    throw new DomainException("error.degreeStructure.CycleCourseGroup.can.only.have.one.parent", new String[0]);
                }
                if (!courseGroup.isRoot()) {
                    throw new DomainException("error.degreeStructure.CycleCourseGroup.parent.must.be.RootCourseGroup", new String[0]);
                }
            }
        });
        Context.getRelationDegreeModuleContext().addListener((RelationListener)new RelationAdapter<Context, DegreeModule>(){

            public void beforeAdd(Context context, DegreeModule degreeModule) {
                if (context != null && degreeModule != null) {
                    if (degreeModule.isRoot()) {
                        throw new DomainException("error.degreeStructure.RootCourseGroup.cannot.have.parent.contexts", new String[0]);
                    }
                    if (degreeModule.isCycleCourseGroup()) {
                        CycleCourseGroup cycleCourseGroup = (CycleCourseGroup)((Object)degreeModule);
                        if (cycleCourseGroup.getParentContextsSet().size() > 0) {
                            throw new DomainException("error.degreeStructure.CycleCourseGroup.can.only.have.one.parent", new String[0]);
                        }
                        if (context.getParentCourseGroup() != null && !context.getParentCourseGroup().isRoot()) {
                            throw new DomainException("error.degreeStructure.CycleCourseGroup.parent.must.be.RootCourseGroup", new String[0]);
                        }
                    }
                }
            }
        });
    }

    public static class DegreeModuleScopeContext
    extends DegreeModuleScope {
        private final Context context;

        private DegreeModuleScopeContext(Context context) {
            this.context = context;
        }

        @Override
        public String getExternalId() {
            return this.context.getExternalId();
        }

        @Override
        public Integer getCurricularSemester() {
            return this.context.getCurricularPeriod().getChildOrder();
        }

        @Override
        public Integer getCurricularYear() {
            return this.context.getCurricularYear();
        }

        @Override
        public String getBranch() {
            return "";
        }

        public Context getContext() {
            return this.context;
        }

        @Override
        public boolean isActiveForExecutionPeriod(ExecutionSemester executionSemester) {
            ExecutionYear executionYear = executionSemester.getExecutionYear();
            return this.getCurricularCourse().isAnual(executionYear) ? this.getContext().isValid(executionYear) : this.getContext().isValid(executionSemester);
        }

        @Override
        public boolean isActiveForAcademicInterval(AcademicInterval academicInterval) {
            return this.getContext().isValid(academicInterval);
        }

        @Override
        public CurricularCourse getCurricularCourse() {
            return (CurricularCourse)((Object)this.context.getChildDegreeModule());
        }

        @Override
        public String getAnotation() {
            return null;
        }

        @Override
        public String getClassName() {
            return this.context.getClass().getName();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DegreeModuleScopeContext)) {
                return false;
            }
            return this.context.equals(((DegreeModuleScopeContext)obj).getContext());
        }

        public int hashCode() {
            return this.context.hashCode();
        }
    }
}

