/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.degreeChange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessSelectDegreesBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeChange.DegreeChangeCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.degreeChange.DegreeChangeIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyProcessCandidacyPeriod;
import org.fenixedu.academic.domain.period.DegreeChangeCandidacyPeriod;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class DegreeChangeCandidacyProcess
extends DegreeChangeCandidacyProcess_Base {
    private static List<Activity> activities;
    private static final Predicate<DegreeType> ALLOWED_DEGREE_TYPES;

    private DegreeChangeCandidacyProcess() {
    }

    private DegreeChangeCandidacyProcess(ExecutionYear executionYear, DateTime start, DateTime end) {
        this();
        this.checkParameters((ExecutionInterval)((Object)executionYear), start, end);
        this.setState(CandidacyProcessState.STAND_BY);
        new DegreeChangeCandidacyPeriod(this, executionYear, start, end);
    }

    private void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        if (executionInterval == null) {
            throw new DomainException("error.DegreeChangeCandidacyProcess.invalid.executionInterval", new String[0]);
        }
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.DegreeChangeCandidacyProcess.invalid.interval", new String[0]);
        }
    }

    private void edit(DateTime start, DateTime end) {
        this.checkParameters(this.getCandidacyPeriod().getExecutionInterval(), start, end);
        this.getCandidacyPeriod().edit(start, end);
    }

    public boolean canExecuteActivity(User userView) {
        return DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public Map<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> getValidDegreeChangeIndividualCandidacyProcessesByDegree() {
        TreeMap<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> result = new TreeMap<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>>(Degree.COMPARATOR_BY_NAME_AND_ID);
        for (IndividualCandidacyProcess process2 : this.getChildProcessesSet()) {
            DegreeChangeIndividualCandidacyProcess child = (DegreeChangeIndividualCandidacyProcess)((Object)process2);
            if (!child.isCandidacyValid()) continue;
            this.addCandidacy(result, child);
        }
        return result;
    }

    public List<DegreeChangeIndividualCandidacyProcess> getValidDegreeChangeIndividualCandidacyProcesses(Degree degree) {
        if (degree == null) {
            return Collections.emptyList();
        }
        ArrayList<DegreeChangeIndividualCandidacyProcess> result = new ArrayList<DegreeChangeIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess process2 : this.getChildProcessesSet()) {
            DegreeChangeIndividualCandidacyProcess child = (DegreeChangeIndividualCandidacyProcess)((Object)process2);
            if (!child.isCandidacyValid() || !child.hasCandidacyForSelectedDegree(degree)) continue;
            result.add(child);
        }
        return result;
    }

    public Map<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> getValidInstitutionIndividualCandidacyProcessesByDegree() {
        TreeMap<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> result = new TreeMap<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>>(Degree.COMPARATOR_BY_NAME_AND_ID);
        for (IndividualCandidacyProcess process2 : this.getChildProcessesSet()) {
            DegreeChangeIndividualCandidacyProcess child = (DegreeChangeIndividualCandidacyProcess)((Object)process2);
            if (!child.isCandidacyValid() || child.getPrecedentDegreeInformation().isCandidacyExternal()) continue;
            this.addCandidacy(result, child);
        }
        return result;
    }

    public Map<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> getValidExternalIndividualCandidacyProcessesByDegree() {
        TreeMap<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> result = new TreeMap<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>>(Degree.COMPARATOR_BY_NAME_AND_ID);
        for (IndividualCandidacyProcess process2 : this.getChildProcessesSet()) {
            DegreeChangeIndividualCandidacyProcess child = (DegreeChangeIndividualCandidacyProcess)((Object)process2);
            if (!child.isCandidacyValid() || !child.getPrecedentDegreeInformation().isCandidacyExternal()) continue;
            this.addCandidacy(result, child);
        }
        return result;
    }

    private void addCandidacy(Map<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> result, DegreeChangeIndividualCandidacyProcess process2) {
        SortedSet<DegreeChangeIndividualCandidacyProcess> values = result.get(process2.getCandidacySelectedDegree());
        if (values == null) {
            values = new TreeSet<DegreeChangeIndividualCandidacyProcess>(DegreeChangeIndividualCandidacyProcess.COMPARATOR_BY_CANDIDACY_PERSON);
            result.put(process2.getCandidacySelectedDegree(), values);
        }
        values.add(process2);
    }

    public List<DegreeChangeIndividualCandidacyProcess> getAcceptedDegreeChangeIndividualCandidacyProcesses() {
        ArrayList<DegreeChangeIndividualCandidacyProcess> result = new ArrayList<DegreeChangeIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!child.isCandidacyValid() || !child.isCandidacyAccepted()) continue;
            result.add((DegreeChangeIndividualCandidacyProcess)((Object)child));
        }
        return result;
    }

    private static boolean isAllowedToManageProcess(User userView) {
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet())) {
            if (!ALLOWED_DEGREE_TYPES.test(program.getDegreeType())) continue;
            return true;
        }
        return false;
    }

    public List<Degree> getAvailableDegrees() {
        Set degrees = this.getDegreeSet();
        return degrees.isEmpty() ? Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree)) : new ArrayList<Degree>(degrees);
    }

    static {
        DegreeChangeCandidacyProcess.getRelationCandidacyPeriodCandidacyProcess().addListener((RelationListener)new RelationAdapter<CandidacyProcess, CandidacyProcessCandidacyPeriod>(){

            public void beforeAdd(CandidacyProcess candidacyProcess, CandidacyProcessCandidacyPeriod candidacyPeriod) {
                super.beforeAdd((DomainObject)candidacyProcess, (DomainObject)candidacyPeriod);
                if (candidacyProcess != null && candidacyPeriod != null && candidacyPeriod instanceof DegreeChangeCandidacyPeriod && !candidacyPeriod.getCandidacyProcessesSet().isEmpty()) {
                    throw new DomainException("error.DegreeChangeCandidacyProcess.candidacy.period.already.has.process", new String[0]);
                }
            }
        });
        activities = new ArrayList<Activity>();
        activities.add(new EditCandidacyPeriod());
        activities.add(new SendToCoordinator());
        activities.add(new SendToScientificCouncil());
        activities.add(new PrintCandidaciesFromInstitutionDegrees());
        activities.add(new PrintCandidaciesFromExternalDegrees());
        activities.add(new ExportCandidacies());
        activities.add(new SelectAvailableDegrees());
        ALLOWED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree);
    }

    private static class SelectAvailableDegrees
    extends Activity<DegreeChangeCandidacyProcess> {
        private SelectAvailableDegrees() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessSelectDegreesBean bean = (CandidacyProcessSelectDegreesBean)object;
            List<Degree> degrees = bean.getDegrees();
            process2.getDegreeSet().addAll(degrees);
            process2.getDegreeSet().retainAll(degrees);
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ExportCandidacies
    extends Activity<DegreeChangeCandidacyProcess> {
        private ExportCandidacies() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class PrintCandidaciesFromExternalDegrees
    extends Activity<DegreeChangeCandidacyProcess> {
        private PrintCandidaciesFromExternalDegrees() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class PrintCandidaciesFromInstitutionDegrees
    extends Activity<DegreeChangeCandidacyProcess> {
        private PrintCandidaciesFromInstitutionDegrees() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class SendToScientificCouncil
    extends Activity<DegreeChangeCandidacyProcess> {
        private SendToScientificCouncil() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() && !process2.isSentToCoordinator()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_SCIENTIFIC_COUNCIL);
            return process2;
        }
    }

    private static class SendToCoordinator
    extends Activity<DegreeChangeCandidacyProcess> {
        private SendToCoordinator() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_COORDINATOR);
            return process2;
        }
    }

    private static class EditCandidacyPeriod
    extends Activity<DegreeChangeCandidacyProcess> {
        private EditCandidacyPeriod() {
        }

        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            process2.edit(bean.getStart(), bean.getEnd());
            return process2;
        }
    }

    @StartActivity
    public static class CreateCandidacyPeriod
    extends Activity<DegreeChangeCandidacyProcess> {
        @Override
        public void checkPreConditions(DegreeChangeCandidacyProcess process2, User userView) {
            if (!DegreeChangeCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeChangeCandidacyProcess executeActivity(DegreeChangeCandidacyProcess dummy, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            return new DegreeChangeCandidacyProcess((ExecutionYear)((Object)bean.getExecutionInterval()), bean.getStart(), bean.getEnd());
        }
    }
}

