/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.candidacy.CancelledCandidacySituation;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacySituation;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.DFACandidacy;
import org.fenixedu.academic.domain.candidacy.DegreeCandidacy;
import org.fenixedu.academic.domain.candidacy.IMDCandidacy;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.MDCandidacy;
import org.fenixedu.academic.domain.candidacy.SDCandidacy;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.candidacy.PHDProgramCandidacy;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public abstract class StudentCandidacy
extends StudentCandidacy_Base {
    protected void init(Person person, ExecutionDegree executionDegree) {
        StudentCandidacy existentCandidacy;
        String[] args = new String[]{};
        if (executionDegree == null) {
            throw new DomainException("execution degree cannot be null", args);
        }
        String[] args1 = new String[]{};
        if (person == null) {
            throw new DomainException("person cannot be null", args1);
        }
        if (person.hasStudentCandidacyForExecutionDegree(executionDegree) && ((existentCandidacy = person.getStudentCandidacyForExecutionDegree(executionDegree)).getRegistration() == null || existentCandidacy.getRegistration().getActiveStateType().isActive())) {
            throw new DomainException("error.candidacy.already.created", new String[0]);
        }
        this.setExecutionDegree(executionDegree);
        this.setPerson(person);
        this.setPrecedentDegreeInformation(new PrecedentDegreeInformation());
    }

    protected void init(Person person) {
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("person cannot be null", args);
        }
        this.setPerson(person);
        this.setPrecedentDegreeInformation(new PrecedentDegreeInformation());
    }

    private void checkParameters(Person person, ExecutionDegree executionDegree, Person creator, Double entryGrade, String contigent, IngressionType ingressionType, EntryPhase entryPhase) {
        if (executionDegree == null) {
            throw new DomainException("error.candidacy.DegreeCandidacy.executionDegree.cannot.be.null", new String[0]);
        }
        if (person == null) {
            throw new DomainException("error.candidacy.DegreeCandidacy.person.cannot.be.null", new String[0]);
        }
        if (person.hasDegreeCandidacyForExecutionDegree(executionDegree)) {
            throw new DomainException("error.candidacy.DegreeCandidacy.candidacy.already.created", new String[0]);
        }
        if (creator == null) {
            throw new DomainException("error.candidacy.DegreeCandidacy.creator.cannot.be.null", new String[0]);
        }
        if (entryPhase == null) {
            throw new DomainException("error.candidacy.DegreeCandidacy.entryPhase.cannot.be.null", new String[0]);
        }
    }

    protected void init(Person person, ExecutionDegree executionDegree, Person creator, Double entryGrade, String contigent, IngressionType ingressionType, EntryPhase entryPhase, Integer placingOption) {
        this.checkParameters(person, executionDegree, creator, entryGrade, contigent, ingressionType, entryPhase);
        super.setExecutionDegree(executionDegree);
        super.setPerson(person);
        super.setPrecedentDegreeInformation(new PrecedentDegreeInformation());
        super.setEntryGrade(entryGrade);
        super.setContigent(contigent);
        super.setIngressionType(ingressionType);
        super.setEntryPhase(entryPhase);
        super.setPlacingOption(placingOption);
    }

    public DateTime getCandidacyDate() {
        return Collections.min(this.getCandidacySituationsSet(), CandidacySituation.DATE_COMPARATOR).getSituationDate();
    }

    public static StudentCandidacy createStudentCandidacy(ExecutionDegree executionDegree, Person studentPerson) {
        if (executionDegree.getDegree().getDegreeType().isEmpty()) {
            return new DegreeCandidacy(studentPerson, executionDegree);
        }
        if (executionDegree.getDegree().getDegreeType().isSpecializationDegree()) {
            return new SDCandidacy(studentPerson, executionDegree);
        }
        if (executionDegree.getDegree().getDegreeType().isAdvancedSpecializationDiploma()) {
            return new PHDProgramCandidacy(studentPerson, executionDegree);
        }
        if (executionDegree.getDegree().getDegreeType().isAdvancedFormationDiploma()) {
            return new DFACandidacy(studentPerson, executionDegree);
        }
        if (executionDegree.getDegree().getDegreeType().isDegree()) {
            return new DegreeCandidacy(studentPerson, executionDegree);
        }
        if (executionDegree.getDegree().getDegreeType().isBolonhaMasterDegree()) {
            return new MDCandidacy(studentPerson, executionDegree);
        }
        if (executionDegree.getDegree().getDegreeType().isIntegratedMasterDegree()) {
            return new IMDCandidacy(studentPerson, executionDegree);
        }
        return new DegreeCandidacy(studentPerson, executionDegree);
    }

    public static Set<StudentCandidacy> readByIds(List<String> studentCandidacyIds) {
        HashSet<StudentCandidacy> result = new HashSet<StudentCandidacy>();
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            if (!(candidacy instanceof StudentCandidacy) || !studentCandidacyIds.contains(candidacy.getExternalId())) continue;
            result.add((StudentCandidacy)((Object)candidacy));
        }
        return result;
    }

    public static Set<StudentCandidacy> readByExecutionYear(ExecutionYear executionYear) {
        HashSet<StudentCandidacy> result = new HashSet<StudentCandidacy>();
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            StudentCandidacy studentCandidacy;
            if (!(candidacy instanceof StudentCandidacy) || (studentCandidacy = (StudentCandidacy)((Object)candidacy)).getExecutionDegree().getExecutionYear() != executionYear) continue;
            result.add(studentCandidacy);
        }
        return result;
    }

    public static Set<StudentCandidacy> readNotConcludedBy(ExecutionDegree executionDegree, ExecutionYear executionYear, EntryPhase entryPhase) {
        HashSet<StudentCandidacy> result = new HashSet<StudentCandidacy>();
        for (Candidacy candidacy : Bennu.getInstance().getCandidaciesSet()) {
            StudentCandidacy studentCandidacy;
            if (!(candidacy instanceof StudentCandidacy) || (studentCandidacy = (StudentCandidacy)((Object)candidacy)).getCandidacySituationsSet().isEmpty() || studentCandidacy.isConcluded() || studentCandidacy.getExecutionDegree() != executionDegree || studentCandidacy.getExecutionDegree().getExecutionYear() != executionYear || studentCandidacy.getEntryPhase() == null || !studentCandidacy.getEntryPhase().equals((Object)entryPhase)) continue;
            result.add(studentCandidacy);
        }
        return result;
    }

    public void delete() {
        this.setRegistration(null);
        this.setExecutionDegree(null);
        this.setSchoolTimeDistrictSubDivisionOfResidence(null);
        this.setCountryOfResidence(null);
        this.setDistrictSubdivisionOfResidence(null);
        if (this.getGrantOwnerProvider() != null) {
            this.setGrantOwnerProvider(null);
        }
        if (this.getPrecedentDegreeInformation() != null && this.getPrecedentDegreeInformation().getStudent() == null) {
            this.getPrecedentDegreeInformation().delete();
        }
        super.delete();
    }

    public boolean isConcluded() {
        CandidacySituation activeSituation = this.getActiveCandidacySituation();
        return activeSituation != null && (activeSituation.getCandidacySituationType() == CandidacySituationType.REGISTERED || this.getActiveCandidacySituation().getCandidacySituationType() == CandidacySituationType.CANCELLED);
    }

    public boolean cancelCandidacy() {
        if (!this.isConcluded()) {
            new CancelledCandidacySituation((Candidacy)((Object)this), this.getPerson());
            for (PaymentCode paymentCode : this.getAvailablePaymentCodesSet()) {
                AccountingEventPaymentCode accountingEventPaymentCode = (AccountingEventPaymentCode)((Object)paymentCode);
                if (!accountingEventPaymentCode.isNew() || accountingEventPaymentCode.getAccountingEvent() != null) continue;
                accountingEventPaymentCode.cancel();
            }
            return true;
        }
        return false;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan();
    }

    public boolean hasEntryPhase() {
        return this.getEntryPhase() != null;
    }

    public boolean hasApplyForResidence() {
        return this.getApplyForResidence() != null;
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionDegree().getExecutionYear();
    }
}

