/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentProfessorshipsGroup;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInterval;

@GroupOperator(value="professorship")
public class ProfessorshipsGroup
extends FenixGroup {
    private static final long serialVersionUID = -6043352087768539757L;
    @GroupArgument(value="external")
    private Boolean externalAuthorizations;
    @GroupArgument
    private AcademicPeriod period;

    private ProfessorshipsGroup() {
    }

    private ProfessorshipsGroup(Boolean externalAuthorizations, AcademicPeriod period) {
        this();
        this.externalAuthorizations = externalAuthorizations;
        this.period = period;
    }

    public static ProfessorshipsGroup get(Boolean externalAuthorizations, AcademicPeriod period) {
        return new ProfessorshipsGroup(externalAuthorizations, period);
    }

    @Override
    public String getPresentationNameKey() {
        if (this.externalAuthorizations.booleanValue()) {
            return super.getPresentationNameKey() + ".external";
        }
        return super.getPresentationNameKey();
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{BundleUtil.getString((String)"resources.EnumerationResources", (String)this.period.getName(), (String[])new String[0])};
    }

    public Set<User> getMembers() {
        return this.getMembers(DateTime.now());
    }

    public Set<User> getMembers(DateTime when) {
        HashSet<User> users = new HashSet<User>();
        ExecutionInterval interval = ExecutionInterval.getExecutionInterval(AcademicInterval.readDefaultAcademicInterval(this.period));
        if (interval instanceof ExecutionSemester) {
            ExecutionSemester semester = (ExecutionSemester)((Object)interval);
            this.fillMembers(users, semester);
        } else if (interval instanceof ExecutionYear) {
            for (ExecutionSemester semester : ((ExecutionYear)((Object)interval)).getExecutionPeriodsSet()) {
                this.fillMembers(users, semester);
            }
        }
        return users;
    }

    private void fillMembers(Set<User> users, ExecutionSemester semester) {
        if (this.externalAuthorizations.booleanValue()) {
            users.addAll(semester.getTeacherAuthorizationStream().filter(a -> !a.isContracted()).map(a -> a.getTeacher().getPerson().getUser()).collect(Collectors.toSet()));
        } else {
            for (ExecutionCourse executionCourse : semester.getAssociatedExecutionCoursesSet()) {
                for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                    User user = professorship.getPerson().getUser();
                    if (user == null) continue;
                    users.add(user);
                }
            }
        }
    }

    public boolean isMember(User user) {
        return this.isMember(user, DateTime.now());
    }

    public boolean isMember(User user, DateTime when) {
        if (user == null) {
            return false;
        }
        AcademicInterval interval = AcademicInterval.readDefaultAcademicInterval(this.period);
        if (this.externalAuthorizations.booleanValue()) {
            if (user.getPerson().getTeacher().getTeacherAuthorization(interval).isPresent()) {
                return true;
            }
        } else {
            for (Professorship professorship : user.getPerson().getProfessorshipsSet()) {
                ExecutionCourse executionCourse = professorship.getExecutionCourse();
                if (!interval.contains((ReadableInterval)executionCourse.getAcademicInterval())) continue;
                return true;
            }
        }
        return false;
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentProfessorshipsGroup.getInstance(this.externalAuthorizations, this.period);
    }

    public boolean equals(Object object) {
        if (object instanceof ProfessorshipsGroup) {
            ProfessorshipsGroup other = (ProfessorshipsGroup)((Object)object);
            return Objects.equal((Object)this.externalAuthorizations, (Object)other.externalAuthorizations) && Objects.equal((Object)((Object)this.period), (Object)((Object)other.period));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.externalAuthorizations, this.period});
    }
}

