/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.QualificationTypes;
import org.fenixedu.academic.util.Money;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudentLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(StudentLine.class);
    protected static final List<Integer> STUDENTS_WITH_CET = Arrays.asList(70855, 70696, 70757, 70786, 55647, 59218, 70749, 70856, 70678, 70681, 70712, 70737, 70837, 70793, 10425, 38565, 70783, 70664, 70859, 70766, 70844, 48936, 50315, 70788, 70794, 70795, 70804, 70809, 70716, 70719, 70763, 70776, 70841, 70923);
    public ExecutionYear forExecutionYear;
    public String institutionCode;
    public String institutionName;
    public String candidacyNumber;
    public Integer studentNumber;
    public String studentName;
    public String documentTypeName;
    public String documentNumber;
    public String degreeCode;
    public String degreeName;
    public String degreeTypeName;
    public String upperObservations = "";
    public boolean enrolledInAnualCoursesLastYear;
    private Student student = null;
    private Registration registration = null;
    private Person person = null;
    private boolean multiplePersonsFound = false;
    private String observations;
    private static final String INTEGRATED_MASTER_DESIGNATION = "Mestrado Integrado";
    private static final String BOLONHA_DEGREE_DESIGNATION = "Licenciatura 1\u00ba Ciclo";

    public boolean fillWithFileLineData(String dataLine) {
        String[] compounds = dataLine.split(";");
        this.institutionCode = compounds[0].trim();
        this.institutionName = compounds[1].trim();
        this.candidacyNumber = compounds[2].trim();
        try {
            this.studentNumber = Integer.valueOf(compounds[3].trim());
        }
        catch (NumberFormatException e) {
            this.studentNumber = null;
        }
        this.studentName = compounds[4].trim();
        this.documentTypeName = compounds[5].trim();
        this.documentNumber = compounds[6].trim();
        this.degreeCode = compounds[7].trim();
        this.degreeName = compounds[8].trim();
        this.degreeTypeName = compounds[9].trim();
        if (compounds.length == 36) {
            this.upperObservations = compounds[35].trim();
        }
        this.setBestMatchingStudent();
        if (this.multiplePersonsFound) {
            return false;
        }
        if (this.person == null) {
            return false;
        }
        this.enrolledInAnualCoursesLastYear = false;
        return true;
    }

    public boolean fillWithSpreadsheetRow(ExecutionYear forExecutionYear, HSSFRow row) {
        this.forExecutionYear = forExecutionYear;
        try {
            this.institutionCode = this.getValueFromColumnMayBeNull(row, 0);
            this.institutionName = this.getValueFromColumnMayBeNull(row, 1);
            this.candidacyNumber = this.getValueFromColumnMayBeNull(row, 2);
            try {
                this.studentNumber = Integer.valueOf(this.getValueFromColumnMayBeNull(row, 3));
            }
            catch (NumberFormatException e) {
                this.studentNumber = null;
            }
            this.studentName = this.getValueFromColumnMayBeNull(row, 4);
            this.documentTypeName = this.getValueFromColumnMayBeNull(row, 5);
            this.documentNumber = this.getValueFromColumnMayBeNull(row, 6);
            this.degreeCode = this.getValueFromColumnMayBeNull(row, 7);
            this.degreeName = this.getValueFromColumnMayBeNull(row, 8);
            this.degreeTypeName = this.getValueFromColumnMayBeNull(row, 9);
            if (row.getLastCellNum() >= 35) {
                this.upperObservations = this.getValueFromColumnMayBeNull(row, 35);
            }
            this.setBestMatchingStudent();
            if (this.multiplePersonsFound) {
                return false;
            }
            if (this.person == null) {
                return false;
            }
            this.enrolledInAnualCoursesLastYear = false;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getValueFromColumnMayBeNull(HSSFRow row, int i) {
        HSSFCell cell = row.getCell((short)i);
        if (cell == null) {
            return "";
        }
        return this.getValueFromColumn(row, i).trim();
    }

    private String getValueFromColumn(HSSFRow row, int i) {
        try {
            return new Integer(new Double(row.getCell((short)i).getNumericCellValue()).intValue()).toString();
        }
        catch (NumberFormatException e) {
            return row.getCell((short)i).getStringCellValue();
        }
        catch (IllegalStateException e) {
            return row.getCell((short)i).getStringCellValue();
        }
    }

    public String getUniqueKey() {
        return this.documentNumber;
    }

    public DegreeType readDegreeType() {
        if (this.degreeTypeName.equals(INTEGRATED_MASTER_DESIGNATION)) {
            return DegreeType.matching(DegreeType::isIntegratedMasterDegree).get();
        }
        if (this.degreeTypeName.equals(BOLONHA_DEGREE_DESIGNATION)) {
            return DegreeType.matching(DegreeType::isBolonhaDegree).get();
        }
        throw new RuntimeException("Unknown degree type " + this.degreeTypeName);
    }

    public Degree readDegree() {
        for (Degree degree : Degree.readAllByDegreeCode(this.degreeCode)) {
            if (!degree.getDegreeType().equals(this.readDegreeType())) continue;
            return degree;
        }
        return null;
    }

    public Student getStudent() {
        return this.student;
    }

    public boolean isStudentFound() {
        return this.getStudent() != null;
    }

    public Person getPerson() {
        return this.person;
    }

    public boolean isPersonFound() {
        return this.getPerson() != null;
    }

    public Registration getRegistration() {
        if (this.getStudent() == null) {
            return null;
        }
        if (this.registration == null) {
            this.registration = this.getStudent().getLastActiveRegistration();
        }
        return this.registration;
    }

    public boolean isStudentActive() {
        if (this.getRegistration() == null) {
            return false;
        }
        if (!this.getRegistration().isActive()) {
            return false;
        }
        return this.getRegistration().getLastStudentCurricularPlan().hasAnyEnrolmentForExecutionYear(this.getForExecutionYear()) || this.getRegistration().isInMobilityState();
    }

    public boolean isLastRegistrationEqualToSpecifiedDegree() {
        if (this.getRegistration() == null) {
            return false;
        }
        return this.getRegistration().getDegree() == this.readDegree();
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getLastStudentCurricularPlan();
    }

    public boolean isDocumentIdentificationEqual() {
        return this.getPerson().getDocumentIdNumber().equals(this.documentNumber);
    }

    public boolean isNameEqual() {
        return this.getPerson().getName().toUpperCase().equals(this.studentName.toUpperCase());
    }

    public boolean isMasterQualificationOwner() {
        for (Qualification qualification : this.getPerson().getAssociatedQualificationsSet()) {
            if (!QualificationTypes.isMasterQualificationType(qualification.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isPhdQualificationOwner() {
        for (Qualification qualification : this.getPerson().getAssociatedQualificationsSet()) {
            if (!QualificationTypes.isPhdQualificationType(qualification.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isDegreeQualificationOwner() {
        for (Qualification qualification : this.getPerson().getAssociatedQualificationsSet()) {
            if (!QualificationTypes.isDegreeQualificationType(qualification.getType())) continue;
            return true;
        }
        return false;
    }

    public LocalDate getFirstEnrolmentOnCurrentExecutionYear() {
        if (this.getRegistration() == null) {
            return null;
        }
        if (this.getRegistration().isInMobilityState()) {
            return this.getForExecutionYear().getBeginDateYearMonthDay().toLocalDate();
        }
        TreeSet<CurriculumModule> orderedEnrolmentSet = new TreeSet<CurriculumModule>(Collections.reverseOrder(CurriculumModule.COMPARATOR_BY_CREATION_DATE));
        orderedEnrolmentSet.addAll(this.getStudentCurricularPlan().getEnrolmentsByExecutionYear(this.getForExecutionYear()));
        return orderedEnrolmentSet.isEmpty() ? null : ((Enrolment)((Object)orderedEnrolmentSet.iterator().next())).getCreationDateDateTime().toLocalDate();
    }

    public LocalDate getEnrolmentDateTime() {
        if (this.getRegistration().isFirstTime()) {
            return this.getRegistration().getStartDate().toLocalDate();
        }
        return this.getFirstEnrolmentOnCurrentExecutionYear();
    }

    public Money getGratuityAmount() {
        if (this.getRegistration() == null) {
            return Money.ZERO;
        }
        if (!this.getRegistration().hasToPayGratuityOrInsurance()) {
            return Money.ZERO;
        }
        GratuityEventWithPaymentPlan event = (GratuityEventWithPaymentPlan)((Object)this.getStudentCurricularPlan().getGratuityEvent(this.getForExecutionYear(), GratuityEventWithPaymentPlan.class));
        if (event == null) {
            return Money.ZERO;
        }
        return event.getOriginalAmountToPay();
    }

    public LocalDate getFirstInstallmentPaymentLocalDate() {
        if (!this.getRegistration().hasToPayGratuityOrInsurance()) {
            return null;
        }
        GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan = (GratuityEventWithPaymentPlan)((Object)this.getStudentCurricularPlan().getGratuityEvent(this.getForExecutionYear(), GratuityEventWithPaymentPlan.class));
        Installment firstInstallment = gratuityEventWithPaymentPlan.getInstallments().iterator().next();
        Money paidForFirstInstallment = Money.ZERO;
        for (AccountingTransaction accountingTransaction : gratuityEventWithPaymentPlan.getNonAdjustingTransactions()) {
            if (!(paidForFirstInstallment = paidForFirstInstallment.add(accountingTransaction.getAmountWithAdjustment())).greaterOrEqualThan(firstInstallment.getAmount())) continue;
            return accountingTransaction.getWhenRegistered().toLocalDate();
        }
        return firstInstallment.getEndDate().toLocalDate();
    }

    public String getRegime() {
        if (this.getRegistration() == null) {
            return "";
        }
        RegistrationRegimeType type = this.getRegistration().getRegimeType(this.getForExecutionYear());
        if (RegistrationRegimeType.FULL_TIME.equals((Object)type)) {
            return "Tempo integral";
        }
        if (RegistrationRegimeType.PARTIAL_TIME.equals((Object)type)) {
            return "Tempo parcial";
        }
        return "";
    }

    public Integer getNumberOfDegreeCurricularYears() {
        if (this.getRegistration() == null) {
            return null;
        }
        return this.getStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears();
    }

    public Integer getNumberOfEnrolmentYearsOnIST() {
        return StudentLine.getEnrolmentsExecutionYears(this.getStudent()).size();
    }

    public String getDegreeCode() {
        if (this.getRegistration() == null) {
            return "";
        }
        String ministryCode = this.getRegistration().getDegree().getMinistryCode();
        return "9999".equals(ministryCode) ? "0" : ministryCode;
    }

    public String getDegreeName() {
        if (this.getRegistration() != null) {
            return this.getRegistration().getDegree().getNameI18N().getContent(MultiLanguageString.pt);
        }
        return this.degreeName;
    }

    public boolean isOwnerOfCollegeQualification() {
        return this.isDegreeQualificationOwner() || this.isMasterQualificationOwner() || this.isPhdQualificationOwner();
    }

    public double getNumberOfDoneECTS() {
        return this.getRegistration().getEctsCredits();
    }

    public Double getNumberOfEnrolledECTS() {
        if (this.getStudentCurricularPlan() == null) {
            return null;
        }
        return this.getEnrolmentsEctsCredits(this.getForExecutionYear());
    }

    private double getEnrolmentsEctsCredits(ExecutionYear executionYear) {
        double result = 0.0;
        HashSet<Enrolment> annualEnrolments = new HashSet<Enrolment>();
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            for (Enrolment enrolment : this.getStudentCurricularPlan().getEnrolmentsSet()) {
                if (!enrolment.isValid(executionSemester) || annualEnrolments.contains(enrolment)) continue;
                result += enrolment.getEctsCredits().doubleValue();
                if (!enrolment.isAnual()) continue;
                annualEnrolments.add(enrolment);
            }
        }
        return result;
    }

    public boolean isMultiplePersonsFound() {
        return this.multiplePersonsFound;
    }

    public String getStudentNumberForPrint() {
        if (this.studentNumber != null) {
            return this.studentNumber.toString();
        }
        if (!this.isStudentFound()) {
            return "n/a";
        }
        return this.getStudent().getNumber().toString();
    }

    public String getDegreeTypeName() {
        if (this.getRegistration() == null) {
            return "";
        }
        if (this.getRegistration().getDegree().getDegreeType().isBolonhaDegree()) {
            return BOLONHA_DEGREE_DESIGNATION;
        }
        if (this.getRegistration().getDegree().getDegreeType().isIntegratedMasterDegree()) {
            return INTEGRATED_MASTER_DESIGNATION;
        }
        return this.getRegistration().getDegree().getDegreeType().getName().getContent();
    }

    public boolean isStudentNumberDiffer() {
        if (this.studentNumber != null && this.isStudentFound()) {
            return this.studentNumber.equals(this.getStudent().getNumber());
        }
        return false;
    }

    private Collection<Person> readPersonsByCompleteDocumentId() {
        return Person.readByDocumentIdNumber(this.documentNumber);
    }

    public String getPartialDocumentId() {
        return this.documentNumber.substring(0, this.documentNumber.length() - 1);
    }

    private Collection<Person> readPersonsByPartialDocumentId() {
        return Person.readByDocumentIdNumber(this.getPartialDocumentId());
    }

    public boolean isPersonReadByPartialDocumentId() {
        return this.readPersonsByCompleteDocumentId().isEmpty() && this.readPersonsByPartialDocumentId().size() == 1;
    }

    public Integer getCountNumberOfDegreeChanges() {
        int numberOfDegreeChanges = 0;
        if (this.student == null) {
            return 0;
        }
        ArrayList<Registration> registrations = new ArrayList<Registration>(this.student.getRegistrationsSet());
        Collections.sort(registrations, Registration.COMPARATOR_BY_START_DATE);
        for (Registration iter : registrations) {
            TreeSet<RegistrationState> states = new TreeSet<RegistrationState>(RegistrationState.DATE_COMPARATOR);
            states.addAll(iter.getRegistrationStates(RegistrationStateType.INTERNAL_ABANDON));
            if (states.isEmpty()) continue;
            ++numberOfDegreeChanges;
        }
        return numberOfDegreeChanges;
    }

    public boolean hasMadeDegreeChange() {
        if (this.getRegistration() == null) {
            return false;
        }
        return this.getRegistration().getStartExecutionYear() == this.getForExecutionYear() && this.getRegistration().getIngressionType().isInternalDegreeChange();
    }

    public Boolean getHasMadeDegreeChange() {
        return this.hasMadeDegreeChange();
    }

    public String getFirstRegistrationExecutionYear() {
        if (this.getRegistration() == null) {
            return "";
        }
        return Integer.valueOf(this.getRegistration().getStudent().getFirstRegistrationExecutionYear().getBeginCivilYear()).toString();
    }

    public Integer getCountNumberOfEnrolmentsYearsSinceRegistrationStart() {
        if (this.getRegistration() == null) {
            return null;
        }
        return this.getRegistration().getEnrolmentsExecutionYears().size();
    }

    public Integer getCountNumberOfEnrolmentsYearsInIntegralRegime() {
        if (this.getRegistration() == null) {
            return null;
        }
        Collection<ExecutionYear> registrationExecutionYears = this.getRegistration().getEnrolmentsExecutionYears();
        int count = 0;
        for (ExecutionYear executionYear : registrationExecutionYears) {
            RegistrationRegimeType regimeType = this.getRegistration().getRegimeType(executionYear);
            count += RegistrationRegimeType.FULL_TIME.equals((Object)regimeType) ? 1 : 0;
        }
        return count;
    }

    public Integer getCurricularYearOneYearAgo() {
        ExecutionYear oneYearAgo = this.getForExecutionYear().getPreviousExecutionYear();
        if (this.student == null) {
            return 0;
        }
        Registration lastRegistration = this.student.getLastActiveRegistration();
        if (lastRegistration == null) {
            return null;
        }
        if (lastRegistration.getDegreeType().isBolonhaDegree()) {
            return lastRegistration.getCurriculum(new DateTime(), oneYearAgo, CycleType.FIRST_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isIntegratedMasterDegree()) {
            if (lastRegistration.hasConcludedFirstCycle()) {
                return lastRegistration.getCurricularYear(oneYearAgo);
            }
            if (lastRegistration.getLastStudentCurricularPlan().getCycle(CycleType.FIRST_CYCLE) != null) {
                return lastRegistration.getCurriculum(new DateTime(), oneYearAgo, CycleType.FIRST_CYCLE).getCurricularYear();
            }
            return lastRegistration.getCurriculum(new DateTime(), oneYearAgo, CycleType.SECOND_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isBolonhaMasterDegree()) {
            return lastRegistration.getCurricularYear(oneYearAgo);
        }
        return lastRegistration.getCurricularYear(oneYearAgo);
    }

    public Integer getCurricularYearInCurrentYear() {
        ExecutionYear currentYear = this.getForExecutionYear();
        if (this.student == null) {
            return 0;
        }
        Registration lastRegistration = this.student.getLastActiveRegistration();
        if (lastRegistration == null) {
            return null;
        }
        if (lastRegistration.getDegreeType().isBolonhaDegree()) {
            return lastRegistration.getCurriculum(new DateTime(), currentYear, CycleType.FIRST_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isIntegratedMasterDegree()) {
            if (lastRegistration.hasConcludedFirstCycle()) {
                return lastRegistration.getCurricularYear(currentYear);
            }
            if (lastRegistration.getLastStudentCurricularPlan().getCycle(CycleType.FIRST_CYCLE) != null) {
                return lastRegistration.getCurriculum(new DateTime(), currentYear, CycleType.FIRST_CYCLE).getCurricularYear();
            }
            return lastRegistration.getCurriculum(new DateTime(), currentYear, CycleType.SECOND_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isBolonhaMasterDegree()) {
            return lastRegistration.getCurricularYear(currentYear);
        }
        return lastRegistration.getCurricularYear(currentYear);
    }

    public BigDecimal getNumberOfEnrolledEctsCurrentYear() {
        ExecutionYear currentYear = this.getForExecutionYear();
        return new BigDecimal(this.getRegistration().getEnrolmentsEcts(currentYear));
    }

    public BigDecimal getNumberOfEnrolledEctsOneYearAgo() {
        ExecutionYear oneYearAgo = this.getForExecutionYear().getPreviousExecutionYear();
        BigDecimal result = BigDecimal.ZERO;
        if (this.student == null) {
            return BigDecimal.ZERO;
        }
        for (Registration registration : this.student.getRegistrationsSet()) {
            if (!registration.isBolonha() || !registration.hasAnyEnrolmentsIn(oneYearAgo)) continue;
            result = result.add(new BigDecimal(this.getEnrolmentsEctsCredits(registration, oneYearAgo)));
        }
        return result;
    }

    public BigDecimal getNumberOfApprovedEctsOneYearAgo() {
        ExecutionYear oneYearAgo = this.getForExecutionYear().getPreviousExecutionYear();
        BigDecimal result = BigDecimal.ZERO;
        if (this.student == null) {
            return BigDecimal.ZERO;
        }
        for (Registration registration : this.student.getRegistrationsSet()) {
            if (!registration.isBolonha() || !registration.hasAnyEnrolmentsIn(oneYearAgo)) continue;
            result = result.add(StudentLine.calculateApprovedECTS(registration.getLastStudentCurricularPlan().getAprovedEnrolmentsInExecutionPeriod(oneYearAgo.getFirstExecutionPeriod()))).add(StudentLine.calculateApprovedECTS(registration.getLastStudentCurricularPlan().getAprovedEnrolmentsInExecutionPeriod(oneYearAgo.getLastExecutionPeriod())));
        }
        return result;
    }

    private double getEnrolmentsEctsCredits(Registration registration, ExecutionYear executionYear) {
        double result = 0.0;
        double annualCredits = 0.0;
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            for (Enrolment enrolment : registration.getLastStudentCurricularPlan().getEnrolmentsSet()) {
                if (!enrolment.isValid(executionSemester)) continue;
                if (enrolment.isAnual()) {
                    this.enrolledInAnualCoursesLastYear = true;
                    if (executionSemester.getSemester() != 1) continue;
                    annualCredits += enrolment.getEctsCredits().doubleValue();
                    continue;
                }
                result += enrolment.getEctsCredits().doubleValue();
            }
        }
        return result + annualCredits;
    }

    public ExecutionYear getForExecutionYear() {
        return this.forExecutionYear;
    }

    public void setForExecutionYear(ExecutionYear forExecutionYear) {
        this.forExecutionYear = forExecutionYear;
    }

    private void setBestMatchingStudent() {
        Person personByFullDocumentId = null;
        Person personByPartialDocumentId = null;
        Collection<Person> fullDocumentIdPersonsCollection = this.readPersonsByCompleteDocumentId();
        Collection<Person> partialDocumentIdPersonsCollection = this.readPersonsByPartialDocumentId();
        if (fullDocumentIdPersonsCollection.size() > 1) {
            this.multiplePersonsFound = true;
            return;
        }
        if (fullDocumentIdPersonsCollection.size() == 1) {
            personByFullDocumentId = fullDocumentIdPersonsCollection.iterator().next();
        }
        if (partialDocumentIdPersonsCollection.size() == 1) {
            personByPartialDocumentId = partialDocumentIdPersonsCollection.iterator().next();
        }
        Student studentReadByNumber = this.studentNumber != null ? Student.readStudentByNumber(this.studentNumber) : null;
        Person personFoundByStudent = null;
        if (studentReadByNumber != null) {
            personFoundByStudent = studentReadByNumber.getPerson();
        }
        if (personByFullDocumentId != null && personFoundByStudent != null && personByFullDocumentId != personFoundByStudent) {
            this.multiplePersonsFound = true;
            return;
        }
        if (personByPartialDocumentId != null && personFoundByStudent != null && personByPartialDocumentId != personFoundByStudent) {
            this.multiplePersonsFound = true;
            return;
        }
        if (personByFullDocumentId != null) {
            this.person = personByFullDocumentId;
            this.student = this.person.getStudent();
        } else if (personByPartialDocumentId != null) {
            this.person = personByPartialDocumentId;
            this.student = this.person.getStudent();
        } else if (personFoundByStudent != null) {
            this.person = personFoundByStudent;
            this.student = this.person.getStudent();
        }
    }

    private static BigDecimal calculateApprovedECTS(Collection<Enrolment> list) {
        BigDecimal result = BigDecimal.ZERO;
        for (CurriculumLine curriculumLine : list) {
            result = result.add(BigDecimal.valueOf(curriculumLine.getAprovedEctsCredits()));
        }
        return result;
    }

    public static Collection<ExecutionYear> getEnrolmentsExecutionYears(Student student) {
        HashSet<ExecutionYear> executionYears = new HashSet<ExecutionYear>();
        for (Registration registration : student.getRegistrationsSet()) {
            if (RegistrationStateType.CANCELED.equals(registration.getLastActiveState()) || RegistrationStateType.TRANSITION.equals(registration.getLastActiveState())) continue;
            executionYears.addAll(registration.getEnrolmentsExecutionYears());
        }
        return executionYears;
    }

    public String getObservations() {
        if (this.observations == null) {
            this.buildSystemObservations();
        }
        if (StringUtils.isEmpty((String)this.observations)) {
            return "";
        }
        return this.upperObservations + " | " + this.observations + ";";
    }

    private void buildSystemObservations() {
        StringBuilder observationsBuilder = new StringBuilder();
        if (!this.isPersonFound()) {
            this.appendPersonNotFound(observationsBuilder);
        }
        if (this.isMultiplePersonsFound()) {
            this.appendMultiplePersonsFound(observationsBuilder);
        }
        if (this.isPersonReadByPartialDocumentId()) {
            this.appendPersonReadByPartialDocumentId(observationsBuilder);
        }
        if (!this.isStudentFound()) {
            this.appendStudentNotFound(observationsBuilder);
            this.observations = observationsBuilder.toString();
            return;
        }
        if (!this.isStudentNumberDiffer()) {
            this.appendStudentNumberIsDifferent(observationsBuilder);
        }
        if (!this.isDocumentIdentificationEqual()) {
            this.appendIdentificationNotEqual(observationsBuilder);
        }
        if (!this.isNameEqual()) {
            this.appendNameIsNotEqual(observationsBuilder);
        }
        if (!this.isStudentActive()) {
            this.appendStudentIsNotActive(observationsBuilder);
            this.observations = observationsBuilder.toString();
            return;
        }
        this.observations = observationsBuilder.toString();
    }

    protected void appendPersonReadByPartialDocumentId(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("O aluno foi lido com o numero de identificacao '%s'. ", this.getPartialDocumentId()));
    }

    protected void appendStudentNumberIsDifferent(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("Os numeros de aluno diferem '%s' / '%s'. ", this.studentNumber, this.getStudent().getNumber()));
    }

    protected void appendMultiplePersonsFound(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("Foram encontradas muitas pessoas com a identificacao %s. ", this.documentNumber));
    }

    protected void appendDegreeIsNotEqual(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("Os cursos diferem '%s' / '%s'. ", this.degreeName, this.getRegistration().getDegree().getNameI18N().getContent()));
    }

    protected void appendNameIsNotEqual(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("Os nomes diferem '%s' / '%s'. ", this.studentName, this.getPerson().getName()));
    }

    protected void appendIdentificationNotEqual(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("Os documentos de identificacao diferem '%s' / '%s'. ", this.documentNumber, this.getPerson().getDocumentIdNumber()));
    }

    protected void appendStudentIsNotActive(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("O aluno nao tem nenhuma matricula activa. ", new Object[0]));
    }

    protected void appendStudentNotFound(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("O aluno com o numero %s nao foi encontrado. ", this.studentNumber));
    }

    protected void appendPersonNotFound(StringBuilder observationsBuilder) {
        observationsBuilder.append(String.format("O aluno n\u00e3o foi encontrado com o numero de aluno nem com o n\u00ba de identifica\u00e7\u00e3o. ", new Object[0]));
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public String getInstitutionName() {
        return "Universidade T\u00e9cnica de Lisboa - " + Unit.getInstitutionName().getContent();
    }

    public String getCandidacyNumber() {
        return this.candidacyNumber;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public Boolean getStudentHadPerformanceLastYear() {
        BigDecimal numberOfApprovedEctsOneYearAgo = this.getNumberOfApprovedEctsOneYearAgo();
        BigDecimal numberOfEnrolledEctsOneYearAgo = this.getNumberOfEnrolledEctsOneYearAgo();
        if (numberOfEnrolledEctsOneYearAgo.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        BigDecimal average = numberOfApprovedEctsOneYearAgo.divide(numberOfEnrolledEctsOneYearAgo, RoundingMode.HALF_EVEN);
        average.setScale(2);
        return average.compareTo(new BigDecimal(0.5)) >= 0;
    }

    public String getDegreeConclusionValue() {
        return "";
    }

    public String getFinalResultValue() {
        return "";
    }

    public Integer getNumberOfMonthsExecutionYear() {
        return 10;
    }

    public String getFirstMonthOfPayment() {
        return "Setembro";
    }

    public Boolean getOwnerOfCETQualification() {
        return this.isStudentFound() && STUDENTS_WITH_CET.contains(this.getStudent().getNumber());
    }

    public String getRegimeCode() {
        return "N\u00e3o especificado";
    }

    public String getLastEnrolledExecutionYear() {
        if (this.getStudent() == null) {
            return "";
        }
        ArrayList<ExecutionYear> enrolmentsExecutionYears = new ArrayList<ExecutionYear>(StudentLine.getEnrolmentsExecutionYears(this.getStudent()));
        Collections.sort(enrolmentsExecutionYears, ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        ExecutionYear lastEnrolledExecutionYear = null;
        if (enrolmentsExecutionYears.isEmpty()) {
            return "";
        }
        if (enrolmentsExecutionYears.size() == 1 && ExecutionYear.readCurrentExecutionYear().equals(enrolmentsExecutionYears.iterator().next())) {
            return "";
        }
        lastEnrolledExecutionYear = ExecutionYear.readCurrentExecutionYear().equals(enrolmentsExecutionYears.iterator().next()) ? (ExecutionYear)enrolmentsExecutionYears.get(1) : (ExecutionYear)enrolmentsExecutionYears.iterator().next();
        return Integer.valueOf(lastEnrolledExecutionYear.getBeginCivilYear()).toString();
    }

    public String getNif() {
        if (this.getPerson() == null) {
            return "";
        }
        return this.getPerson().getSocialSecurityNumber();
    }

    public boolean isAbleToReadAllValues() {
        try {
            this.getInstitutionCode();
            this.getInstitutionName();
            this.getCandidacyNumber();
            this.getStudentNumberForPrint();
            this.getStudentName();
            this.getDocumentTypeName();
            this.getDocumentNumber();
            this.getDegreeCode();
            this.getDegreeName();
            this.getDegreeTypeName();
            this.getCountNumberOfDegreeChanges();
            this.getHasMadeDegreeChange();
            this.getFirstEnrolmentOnCurrentExecutionYear();
            this.getRegime();
            this.getFirstRegistrationExecutionYear();
            this.getCountNumberOfEnrolmentsYearsSinceRegistrationStart();
            this.getNumberOfDegreeCurricularYears();
            this.getNumberOfDoneECTS();
            this.getCurricularYearOneYearAgo();
            this.getNumberOfEnrolledEctsOneYearAgo();
            this.getNumberOfApprovedEctsOneYearAgo();
            this.getCurricularYearInCurrentYear();
            this.getNumberOfEnrolledECTS();
            this.getGratuityAmount();
            this.getNumberOfMonthsExecutionYear();
            this.getFirstMonthOfPayment();
            this.getOwnerOfCETQualification();
            this.isDegreeQualificationOwner();
            this.isMasterQualificationOwner();
            this.isPhdQualificationOwner();
            this.isOwnerOfCollegeQualification();
            this.getObservations();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean fillWithStudent(ExecutionYear forExecutionYear, Student student) {
        this.forExecutionYear = forExecutionYear;
        try {
            this.institutionCode = this.getDefaultInstitutionCode();
            this.institutionName = this.getDefaultInstitutionName();
            this.candidacyNumber = "";
            this.studentNumber = student.getNumber();
            this.studentName = student.getPerson().getName();
            this.documentTypeName = student.getPerson().getIdDocumentType().getLocalizedName();
            this.documentNumber = student.getPerson().getDocumentIdNumber();
            Registration activeRegistration = this.getActiveRegistration(student);
            this.degreeCode = activeRegistration.getDegree().getMinistryCode();
            if ("9999".equals(this.degreeCode)) {
                this.degreeCode = "";
            }
            this.degreeName = activeRegistration.getDegree().getNameI18N().getContent();
            this.degreeTypeName = activeRegistration.getDegree().getDegreeTypeName();
            this.upperObservations = "";
            this.person = student.getPerson();
            this.student = student;
            this.enrolledInAnualCoursesLastYear = false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getDefaultInstitutionName() {
        return MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidates.defaultInstitutionName", (String[])new String[0]), Unit.getInstitutionName().getContent());
    }

    private String getDefaultInstitutionCode() {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidates.defaultInstitutionCode", (String[])new String[0]);
    }

    private Registration getActiveRegistration(Student student) {
        List<Registration> activeRegistrations = student.getActiveRegistrations();
        if (activeRegistrations.isEmpty()) {
            return student.getLastRegistration();
        }
        for (Registration registration : activeRegistrations) {
            if (registration.getDegree().getDegreeType().isEmpty()) continue;
            return registration;
        }
        return student.getLastRegistration();
    }
}

