/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.payments;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.documents.ReceiptGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academic.dto.accounting.CreateReceiptBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.report.accounting.ReceiptDocument;
import org.fenixedu.academic.service.services.accounting.CreateReceipt;
import org.fenixedu.academic.service.services.accounting.EditReceipt;
import org.fenixedu.academic.service.services.accounting.RegisterReceiptPrint;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.payments.PaymentsManagementDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/receipts", module="academicAdministration", formBeanClass=FenixActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showReceipts", path="/academicAdminOffice/payments/receipts/showReceipts.jsp"), @Forward(name="showReceipt", path="/academicAdminOffice/payments/receipts/showReceipt.jsp"), @Forward(name="showPaymentsWithoutReceipt", path="/academicAdminOffice/payments/receipts/showPaymentsWithoutReceipt.jsp"), @Forward(name="confirmCreateReceipt", path="/academicAdminOffice/payments/receipts/confirmCreateReceipt.jsp"), @Forward(name="showOperations", path="/academicAdministration/payments.do?method=showOperations"), @Forward(name="editReceipt", path="/academicAdminOffice/payments/receipts/editReceipt.jsp")})
public class ReceiptsManagementDA
extends PaymentsManagementDispatchAction {
    public ActionForward showPaymentsWithoutReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getPerson(request);
        CreateReceiptBean receiptBean = new CreateReceiptBean();
        IViewState viewState = RenderUtils.getViewState((String)"entriesToSelect");
        Collection entriesToSelect = (Collection)(viewState != null ? viewState.getMetaObject().getObject() : null);
        receiptBean.setPerson(person);
        receiptBean.setEntries(this.getSelectableEntryBeans(person.getPaymentsWithoutReceiptByAdministrativeOffices(this.getAdministrativeOffices()), entriesToSelect != null ? entriesToSelect : new HashSet()));
        request.setAttribute("createReceiptBean", (Object)receiptBean);
        return mapping.findForward("showPaymentsWithoutReceipt");
    }

    public ActionForward backToShowPaymentsWithoutReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createReceiptBean", this.getRenderedObject("createReceiptBeanConfirm"));
        return mapping.findForward("showPaymentsWithoutReceipt");
    }

    public ActionForward confirmCreateReceipt(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CreateReceiptBean createReceiptBean = (CreateReceiptBean)RenderUtils.getViewState((String)"createReceiptBean").getMetaObject().getObject();
        if (createReceiptBean.getSelectedEntries().isEmpty()) {
            this.addActionMessage("context", request, "error.payments.receipt.entries.selection.is.required");
            request.setAttribute("personId", (Object)createReceiptBean.getPerson().getExternalId());
            return this.showPaymentsWithoutReceipt(mapping, actionForm, request, response);
        }
        request.setAttribute("createReceiptBean", (Object)createReceiptBean);
        return mapping.findForward("confirmCreateReceipt");
    }

    public ActionForward createReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateReceiptBean createReceiptBean = (CreateReceiptBean)RenderUtils.getViewState((String)"createReceiptBeanConfirm").getMetaObject().getObject();
        createReceiptBean.getPerson().getReceiptsSet().size();
        try {
            Receipt receipt = CreateReceipt.run(ReceiptsManagementDA.getUserView(request).getPerson(), createReceiptBean.getPerson(), createReceiptBean.getContributorName(), createReceiptBean.getContributorNumber(), createReceiptBean.getContributorAddress(), createReceiptBean.getYear(), createReceiptBean.getSelectedEntries());
            request.setAttribute("personId", (Object)receipt.getPerson().getExternalId());
            request.setAttribute("receiptID", (Object)receipt.getExternalId());
            return this.prepareShowReceipt(mapping, form, request, response);
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("createReceiptBean", (Object)createReceiptBean);
            return mapping.findForward("confirmCreateReceipt");
        }
    }

    public ActionForward showReceipts(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        request.setAttribute("receiptsForAdministrativeOffice", this.getPerson(request).getReceiptsByAdministrativeOffices(this.getAdministrativeOffices()));
        return mapping.findForward("showReceipts");
    }

    public ActionForward prepareShowPaymentsWithoutReceiptInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createReceiptBean", RenderUtils.getViewState((String)"createReceiptBean").getMetaObject().getObject());
        return mapping.findForward("showPaymentsWithoutReceipt");
    }

    public ActionForward printReceipt(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Receipt receipt = (Receipt)((Object)this.getRenderedObject("receipt"));
        try {
            ReceiptDocument original = new ReceiptDocument(receipt, true);
            ReceiptDocument duplicate2 = new ReceiptDocument(receipt, false);
            byte[] data = ReportsUtils.generateReport(original, duplicate2).getData();
            ReceiptGeneratedDocument.store(receipt, original.getReportFileName() + ".pdf", data);
            RegisterReceiptPrint.run(receipt, ReceiptsManagementDA.getUserView(request).getPerson());
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", original.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("personId", (Object)receipt.getPerson().getExternalId());
            request.setAttribute("receiptID", (Object)receipt.getExternalId());
            return this.prepareShowReceipt(mapping, actionForm, request, response);
        }
    }

    public ActionForward prepareShowReceipt(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getPerson(request);
        Receipt receipt = this.getReceipt(request);
        if (receipt == null) {
            this.addActionMessage("context", request, "error.payments.receipt.not.found");
            request.setAttribute("person", (Object)person);
            return mapping.findForward("showReceipts");
        }
        if (receipt.getPerson() != person) {
            this.addActionMessage("context", request, "error.payments.person.doesnot.contain.receipt");
            request.setAttribute("person", (Object)person);
            return mapping.findForward("showReceipts");
        }
        request.setAttribute("receipt", (Object)receipt);
        return mapping.findForward("showReceipt");
    }

    public ActionForward prepareEditReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editReceiptBean", (Object)new EditReceiptBean(this.getReceipt(request), AccessControl.getPerson()));
        return mapping.findForward("editReceipt");
    }

    public ActionForward prepareEditReceiptInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editReceiptBean", this.getObjectFromViewState("editReceiptBean"));
        return mapping.findForward("editReceipt");
    }

    public ActionForward editReceipt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EditReceiptBean editReceiptBean = (EditReceiptBean)this.getObjectFromViewState("editReceiptBean");
        try {
            EditReceipt.run(editReceiptBean.getReceipt(), editReceiptBean.getResponsible(), editReceiptBean.getContributorName(), editReceiptBean.getContributorNumber(), editReceiptBean.getContributorAddress());
        }
        catch (DomainException e) {
            request.setAttribute("editReceiptBean", (Object)editReceiptBean);
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return mapping.findForward("editReceipt");
        }
        request.setAttribute("personId", (Object)editReceiptBean.getReceipt().getPerson().getExternalId());
        return this.showReceipts(mapping, form, request, response);
    }

    protected Receipt getReceipt(HttpServletRequest request) {
        return (Receipt)((Object)this.getDomainObject(request, "receiptID"));
    }

    protected Receipt getReceiptFromViewState(String viewStateName) {
        return (Receipt)((Object)RenderUtils.getViewState((String)viewStateName).getMetaObject().getObject());
    }

    public ActionForward editUsingContributorPartyPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EditReceiptBean editReceiptBean = (EditReceiptBean)this.getObjectFromViewState("editReceiptBean");
        RenderUtils.invalidateViewState((String)"editReceiptBean");
        editReceiptBean.setContributorParty(null);
        editReceiptBean.setContributorNumber(null);
        editReceiptBean.setContributorName(null);
        request.setAttribute("editReceiptBean", (Object)editReceiptBean);
        return mapping.findForward("editReceipt");
    }

    public ActionForward createUsingContributorPartyPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateReceiptBean createReceiptBean = (CreateReceiptBean)this.getObjectFromViewState("createReceiptBean");
        RenderUtils.invalidateViewState((String)"createReceiptBean");
        createReceiptBean.setContributorParty(null);
        createReceiptBean.setContributorNumber(null);
        createReceiptBean.setContributorName(null);
        request.setAttribute("createReceiptBean", (Object)createReceiptBean);
        return mapping.findForward("showPaymentsWithoutReceipt");
    }

    protected Set<AdministrativeOffice> getAdministrativeOffices() {
        return AcademicAccessRule.getOfficesAccessibleToFunction(AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Authenticate.getUser()).collect(Collectors.toSet());
    }

    public static class EditReceiptBean
    implements Serializable {
        private static final long serialVersionUID = -1140016139503995375L;
        private Receipt receipt;
        private Party contributorParty;
        private Person responsible;
        private String contributorNumber;
        private String contributorName;
        private String contributorAddress;
        private boolean usingContributorParty;

        public EditReceiptBean(Receipt receipt, Person responsible) {
            this.setReceipt(receipt);
            this.setResponsible(responsible);
            this.setContributorAddress(receipt.getContributorAddress());
            this.setContributorName(receipt.getContributorName());
            this.setContributorNumber(receipt.getContributorNumber());
        }

        public Receipt getReceipt() {
            return this.receipt;
        }

        public void setReceipt(Receipt receipt) {
            this.receipt = receipt;
        }

        public Party getContributorParty() {
            return this.contributorParty != null ? this.contributorParty : (StringUtils.isEmpty((String)this.contributorNumber) ? null : Party.readByContributorNumber(this.contributorNumber));
        }

        public void setContributorParty(Party contributorParty) {
            this.contributorParty = contributorParty;
            if (contributorParty != null) {
                this.contributorName = contributorParty.getName();
                this.contributorNumber = contributorParty.getSocialSecurityNumber();
                this.contributorAddress = contributorParty.getAddress() + (!StringUtils.isEmpty((String)contributorParty.getAreaCode()) ? contributorParty.getAreaCode() + " " + contributorParty.getAreaOfAreaCode() : null);
            }
        }

        public void setContributorPartySocialSecurityNumber(PartySocialSecurityNumber partySocialSecurityNumber) {
            this.contributorParty = partySocialSecurityNumber != null ? partySocialSecurityNumber.getParty() : null;
        }

        public PartySocialSecurityNumber getContributorPartySocialSecurityNumber() {
            return this.contributorParty != null ? this.contributorParty.getPartySocialSecurityNumber() : null;
        }

        public Person getResponsible() {
            return this.responsible;
        }

        public void setResponsible(Person responsible) {
            this.responsible = responsible;
        }

        public String getContributorNumber() {
            return this.contributorNumber;
        }

        public void setContributorNumber(String contributorNumber) {
            this.contributorNumber = contributorNumber;
        }

        public String getContributorName() {
            return this.contributorName;
        }

        public void setContributorName(String contributorName) {
            this.contributorName = contributorName;
        }

        public String getContributorAddress() {
            return this.contributorAddress;
        }

        public void setContributorAddress(String contributorAddress) {
            this.contributorAddress = contributorAddress;
        }

        public boolean isUsingContributorParty() {
            return this.usingContributorParty;
        }

        public void setUsingContributorParty(boolean usingContributorParty) {
            this.usingContributorParty = usingContributorParty;
        }
    }
}

