/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.BolonhaManager;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoadBean;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.bolonhaManager.DeleteCompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.BolonhaManager.BolonhaManagerApplication;
import org.fenixedu.academic.ui.struts.action.BolonhaManager.CompetenceCourseInformationRequestBean;
import org.fenixedu.academic.ui.struts.action.BolonhaManager.CreateReferenceBean;
import org.fenixedu.academic.ui.struts.action.BolonhaManager.EditReferenceBean;
import org.fenixedu.academic.ui.struts.action.BolonhaManager.ManageCompetenceCourseInformationVersions$callable$createCompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=BolonhaManagerApplication.CompetenceCourseManagementApp.class, path="versions", titleKey="label.manage.versions")
@Mapping(module="bolonhaManager", path="/competenceCourses/manageVersions")
@Forwards(value={@Forward(name="showCourses", path="/bolonhaManager/competenceCourseVersions/listCompetenceCourses.jsp"), @Forward(name="createVersions", path="/bolonhaManager/competenceCourseVersions/createVersion.jsp"), @Forward(name="viewVersions", path="/bolonhaManager/competenceCourseVersions/viewVersions.jsp"), @Forward(name="viewVersionDetails", path="/bolonhaManager/competenceCourseVersions/viewVersionDetails.jsp"), @Forward(name="editBiblio", path="/bolonhaManager/competenceCourseVersions/editBibliography.jsp"), @Forward(name="editBibliographicReference", path="/bolonhaManager/competenceCourseVersions/editBibliographicReference.jsp"), @Forward(name="viewInformationDetails", path="/bolonhaManager/competenceCourseVersions/viewCompetenceCourseInformation.jsp")})
public class ManageCompetenceCourseInformationVersions
extends FenixDispatchAction {
    public static final Advice advice$createCompetenceCourseInformationChangeRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CompetenceCourseInformationRequestBean requestBean = this.getOrCreateRequestBean(request);
        request.setAttribute("department", Bennu.getInstance().getDepartmentsSet().stream().filter(dep -> dep.getCompetenceCourseMembersGroup().isMember(Authenticate.getUser())).findAny().orElse(null));
        request.setAttribute("requestBean", (Object)requestBean);
        return mapping.findForward("showCourses");
    }

    private CompetenceCourseInformationRequestBean getOrCreateRequestBean(HttpServletRequest request) {
        CompetenceCourseInformationRequestBean requestBean = (CompetenceCourseInformationRequestBean)this.getObjectFromViewState("requestBean");
        if (requestBean == null) {
            requestBean = new CompetenceCourseInformationRequestBean();
            requestBean.setShowOldCompetenceCourses(true);
        }
        return requestBean;
    }

    public ActionForward editVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CompetenceCourseInformationChangeRequest changeRequest = this.getCompetenceCourseInformationRequest(request);
        if (changeRequest == null || !changeRequest.isLoggedPersonAllowedToEdit()) {
            this.addActionMessage(request, "error.cannot.edit.request");
            return this.forwardToViewVersions(mapping, request, changeRequest.getCompetenceCourse());
        }
        CompetenceCourseInformationRequestBean bean = new CompetenceCourseInformationRequestBean(changeRequest);
        CompetenceCourseLoadBean loadBean = new CompetenceCourseLoadBean(changeRequest);
        request.setAttribute("beanLoad", (Object)loadBean);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("createVersions");
    }

    public ActionForward prepareCreateVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CompetenceCourse course = this.getCompetenceCourse(request);
        ExecutionSemester period = this.getExecutionPeriod(request);
        CompetenceCourseInformationRequestBean bean = null;
        IViewState viewState = RenderUtils.getViewState((String)"editVersion");
        CompetenceCourseInformation information = null;
        if (viewState != null) {
            bean = (CompetenceCourseInformationRequestBean)viewState.getMetaObject().getObject();
            ExecutionSemester beanPeriod = bean.getExecutionPeriod();
            if (beanPeriod == null) {
                beanPeriod = ExecutionSemester.readActualExecutionSemester();
                bean.setExecutionPeriod(beanPeriod);
            }
            information = bean.getCompetenceCourse().findCompetenceCourseInformationForExecutionPeriod(beanPeriod);
        }
        if (bean == null) {
            bean = new CompetenceCourseInformationRequestBean(course.findCompetenceCourseInformationForExecutionPeriod(period != null ? period : ExecutionSemester.readActualExecutionSemester()));
        } else if (information == null) {
            bean.reset();
        } else {
            bean.update(information);
        }
        IViewState viewStateLoad = RenderUtils.getViewState((String)"editVersionLoad");
        CompetenceCourseLoadBean load = viewStateLoad != null ? (CompetenceCourseLoadBean)viewStateLoad.getMetaObject().getObject() : (information != null && information.getCompetenceCourseLoadsSet().size() > 0 ? new CompetenceCourseLoadBean((CompetenceCourseLoad)information.getCompetenceCourseLoadsSet().iterator().next()) : (period != null && course.findCompetenceCourseInformationForExecutionPeriod(period).getCompetenceCourseLoadsSet().size() > 0 ? new CompetenceCourseLoadBean((CompetenceCourseLoad)course.findCompetenceCourseInformationForExecutionPeriod(period).getCompetenceCourseLoadsSet().iterator().next()) : new CompetenceCourseLoadBean()));
        request.setAttribute("beanLoad", (Object)load);
        RenderUtils.invalidateViewState((String)"common-part");
        RenderUtils.invalidateViewState((String)"pt-part");
        RenderUtils.invalidateViewState((String)"en-part");
        RenderUtils.invalidateViewState((String)"versionLoad");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("createVersions");
    }

    private ActionForward forwardToViewVersions(ActionMapping mapping, HttpServletRequest request, CompetenceCourse course) {
        request.setAttribute("competenceCourse", (Object)course);
        return mapping.findForward("viewVersions");
    }

    private ExecutionSemester getExecutionPeriod(HttpServletRequest request) {
        return (ExecutionSemester)this.getDomainObject(request, "executionPeriodID");
    }

    public ActionForward revokeVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationChangeRequest changeRequest = this.getChangeRequest(request);
        if (changeRequest == null || !changeRequest.isLoggedPersonAllowedToEdit()) {
            this.addActionMessage(request, "error.cannot.edit.request");
            return this.forwardToViewVersions(mapping, request, changeRequest.getCompetenceCourse());
        }
        try {
            DeleteCompetenceCourseInformationChangeRequest.run(changeRequest);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
        }
        return this.showVersions(mapping, form, request, response);
    }

    public ActionForward editBibliography(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String index = request.getParameter("index");
        request.setAttribute("edit", (Object)index);
        return this.viewBibliography(mapping, form, request, response);
    }

    public ActionForward createBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationRequestBean bean = (CompetenceCourseInformationRequestBean)RenderUtils.getViewState((String)"editVersion").getMetaObject().getObject();
        CreateReferenceBean referenceBean = (CreateReferenceBean)RenderUtils.getViewState((String)"createReference").getMetaObject().getObject();
        bean.setReferences(bean.getReferences().with(referenceBean.getYear(), referenceBean.getTitle(), referenceBean.getAuthors(), referenceBean.getReference(), referenceBean.getUrl(), referenceBean.getType()));
        RenderUtils.invalidateViewState((String)"createReference");
        return this.viewBibliography(mapping, form, request, response);
    }

    public ActionForward prepareEditBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationRequestBean bean = (CompetenceCourseInformationRequestBean)RenderUtils.getViewState((String)"editVersion").getMetaObject().getObject();
        Integer index = Integer.parseInt(request.getParameter("index"));
        request.setAttribute("editBean", (Object)new EditReferenceBean(bean.getReferences().getBibliographicReference(index)));
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editBibliographicReference");
    }

    public ActionForward editBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationRequestBean bean = (CompetenceCourseInformationRequestBean)RenderUtils.getViewState((String)"editVersion").getMetaObject().getObject();
        EditReferenceBean referenceBean = (EditReferenceBean)RenderUtils.getViewState((String)"editReference").getMetaObject().getObject();
        bean.setReferences(bean.getReferences().replacing(referenceBean.getOrder(), referenceBean.getYear(), referenceBean.getTitle(), referenceBean.getAuthors(), referenceBean.getReference(), referenceBean.getUrl(), referenceBean.getType()));
        RenderUtils.invalidateViewState((String)"createReference");
        return this.viewBibliography(mapping, form, request, response);
    }

    public ActionForward viewBibliography(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationRequestBean bean = (CompetenceCourseInformationRequestBean)RenderUtils.getViewState((String)"editVersion").getMetaObject().getObject();
        CompetenceCourseLoadBean load = (CompetenceCourseLoadBean)RenderUtils.getViewState((String)"editVersionLoad").getMetaObject().getObject();
        request.setAttribute("bean", (Object)bean);
        request.setAttribute("beanLoad", (Object)load);
        if (this.areBeansValid(bean, load)) {
            request.setAttribute("referenceBean", (Object)new CreateReferenceBean());
            return mapping.findForward("editBiblio");
        }
        this.addActionMessage(request, "error.all.fields.are.required");
        request.setAttribute("proposal", this.getFromRequest(request, "proposal"));
        return mapping.findForward("createVersions");
    }

    public ActionForward removeBibliography(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationRequestBean bean = (CompetenceCourseInformationRequestBean)RenderUtils.getViewState((String)"editVersion").getMetaObject().getObject();
        bean.setReferences(bean.getReferences().without(Integer.valueOf(request.getParameter("index"))));
        return this.viewBibliography(mapping, form, request, response);
    }

    public ActionForward createVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState((String)"editVersion");
        if (viewState == null) {
            return this.prepareCreateVersion(mapping, form, request, response);
        }
        CompetenceCourseInformationRequestBean bean = (CompetenceCourseInformationRequestBean)viewState.getMetaObject().getObject();
        CompetenceCourseLoadBean load = (CompetenceCourseLoadBean)RenderUtils.getViewState((String)"editVersionLoad").getMetaObject().getObject();
        CompetenceCourse course = bean.getCompetenceCourse();
        if (!course.isLoggedPersonAllowedToCreateChangeRequests(bean.getExecutionPeriod())) {
            this.addActionMessage(request, "error.cannot.create.request.in.chosen.semester");
            return this.forwardToViewVersions(mapping, request, course);
        }
        try {
            ManageCompetenceCourseInformationVersions.createCompetenceCourseInformationChangeRequest(bean, load, this.getLoggedPerson(request));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.prepareCreateVersion(mapping, form, request, response);
        }
        return this.showVersions(mapping, form, request, response);
    }

    private static void createCompetenceCourseInformationChangeRequest(CompetenceCourseInformationRequestBean competenceCourseInformationRequestBean, CompetenceCourseLoadBean competenceCourseLoadBean, Person person) {
        Object object = advice$createCompetenceCourseInformationChangeRequest.perform((Callable)new ManageCompetenceCourseInformationVersions$callable$createCompetenceCourseInformationChangeRequest(competenceCourseInformationRequestBean, competenceCourseLoadBean, person));
    }

    static /* synthetic */ void advised$createCompetenceCourseInformationChangeRequest(CompetenceCourseInformationRequestBean bean, CompetenceCourseLoadBean loadBean, Person requestor) {
        AccessControl.check(RolePredicates.BOLONHA_MANAGER_PREDICATE);
        CompetenceCourse course = bean.getCompetenceCourse();
        ExecutionSemester period = bean.getExecutionPeriod();
        CompetenceCourseInformationChangeRequest request = course.getChangeRequestDraft(period);
        if (request != null) {
            request.edit(bean.getName(), bean.getNameEn(), bean.getJustification(), bean.getRegime(), bean.getObjectives(), bean.getObjectivesEn(), bean.getProgram(), bean.getProgramEn(), bean.getEvaluationMethod(), bean.getEvaluationMethodEn(), bean.getCompetenceCourseLevel(), requestor, loadBean.getTheoreticalHours(), loadBean.getProblemsHours(), loadBean.getLaboratorialHours(), loadBean.getSeminaryHours(), loadBean.getFieldWorkHours(), loadBean.getTrainingPeriodHours(), loadBean.getTutorialOrientationHours(), loadBean.getAutonomousWorkHours(), loadBean.getEctsCredits(), loadBean.getSecondTheoreticalHours(), loadBean.getSecondProblemsHours(), loadBean.getSecondLaboratorialHours(), loadBean.getSecondSeminaryHours(), loadBean.getSecondFieldWorkHours(), loadBean.getSecondTrainingPeriodHours(), loadBean.getSecondTutorialOrientationHours(), loadBean.getSecondAutonomousWorkHours(), loadBean.getSecondEctsCredits(), bean.getReferences(), null);
        } else {
            new CompetenceCourseInformationChangeRequest(bean.getName(), bean.getNameEn(), bean.getJustification(), bean.getRegime(), bean.getObjectives(), bean.getObjectivesEn(), bean.getProgram(), bean.getProgramEn(), bean.getEvaluationMethod(), bean.getEvaluationMethodEn(), bean.getCompetenceCourse(), bean.getCompetenceCourseLevel(), bean.getExecutionPeriod(), requestor, loadBean.getTheoreticalHours(), loadBean.getProblemsHours(), loadBean.getLaboratorialHours(), loadBean.getSeminaryHours(), loadBean.getFieldWorkHours(), loadBean.getTrainingPeriodHours(), loadBean.getTutorialOrientationHours(), loadBean.getAutonomousWorkHours(), loadBean.getEctsCredits(), loadBean.getSecondTheoreticalHours(), loadBean.getSecondProblemsHours(), loadBean.getSecondLaboratorialHours(), loadBean.getSecondSeminaryHours(), loadBean.getSecondFieldWorkHours(), loadBean.getSecondTrainingPeriodHours(), loadBean.getSecondTutorialOrientationHours(), loadBean.getSecondAutonomousWorkHours(), loadBean.getSecondEctsCredits(), bean.getReferences(), null);
        }
    }

    public ActionForward showVersions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourse course = this.getCompetenceCourse(request);
        return this.forwardToViewVersions(mapping, request, course);
    }

    private CompetenceCourse getCompetenceCourse(HttpServletRequest request) {
        return (CompetenceCourse)((Object)this.getDomainObject(request, "competenceCourseID"));
    }

    public ActionForward viewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationChangeRequest changeRequest = this.getCompetenceCourseInformationRequest(request);
        if (changeRequest == null || !changeRequest.getCompetenceCourse().isLoggedPersonAllowedToViewChangeRequests()) {
            this.addActionMessage(request, "error.cannot.view.request");
            return this.forwardToViewVersions(mapping, request, this.getCompetenceCourse(request));
        }
        request.setAttribute("changeRequest", (Object)changeRequest);
        return mapping.findForward("viewVersionDetails");
    }

    private CompetenceCourseInformationChangeRequest getCompetenceCourseInformationRequest(HttpServletRequest request) {
        return (CompetenceCourseInformationChangeRequest)((Object)this.getDomainObject(request, "changeRequestID"));
    }

    public ActionForward showCompetenceCourseInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourse course = this.getCompetenceCourse(request);
        String externalId = request.getParameter("oid");
        for (CompetenceCourseInformation information : course.getCompetenceCourseInformationsSet()) {
            if (!information.getExternalId().equals(externalId)) continue;
            request.setAttribute("information", (Object)information);
        }
        return mapping.findForward("viewInformationDetails");
    }

    private CompetenceCourseInformationChangeRequest getChangeRequest(HttpServletRequest request) {
        return (CompetenceCourseInformationChangeRequest)((Object)this.getDomainObject(request, "changeRequestID"));
    }

    private boolean areBeansValid(CompetenceCourseInformationRequestBean bean, CompetenceCourseLoadBean loadBean) {
        return !StringUtils.isEmpty((String)bean.getName()) && !StringUtils.isEmpty((String)bean.getNameEn()) && !StringUtils.isEmpty((String)bean.getJustification()) && bean.getRegime() != null && !StringUtils.isEmpty((String)bean.getObjectives()) && !StringUtils.isEmpty((String)bean.getObjectivesEn()) && !StringUtils.isEmpty((String)bean.getProgram()) && !StringUtils.isEmpty((String)bean.getProgramEn()) && !StringUtils.isEmpty((String)bean.getEvaluationMethod()) && !StringUtils.isEmpty((String)bean.getEvaluationMethodEn()) && bean.getCompetenceCourse() != null && bean.getExecutionPeriod() != null && bean.getCompetenceCourseLevel() != null && loadBean.getTheoreticalHours() != null && loadBean.getProblemsHours() != null && loadBean.getLaboratorialHours() != null && loadBean.getSeminaryHours() != null && loadBean.getFieldWorkHours() != null && loadBean.getTrainingPeriodHours() != null && loadBean.getTutorialOrientationHours() != null && loadBean.getAutonomousWorkHours() != null && loadBean.getEctsCredits() != null;
    }

    public ActionForward exportCompetenceCourseExecutionToExcel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        List<CompetenceCourse> competenceCourses = this.getDepartmentCompetenceCourses();
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=list.xls");
            ServletOutputStream outputStream = response.getOutputStream();
            Spreadsheet spreadsheet = new Spreadsheet("list");
            spreadsheet.setHeader(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"competenceCourse", (String[])new String[0]));
            spreadsheet.setHeader(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularPlan", (String[])new String[0]));
            spreadsheet.setHeader(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularYear", (String[])new String[0]));
            spreadsheet.setHeader(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.semester", (String[])new String[0]));
            for (CompetenceCourse competenceCourse : competenceCourses) {
                if (competenceCourse.getCurricularStage() != CurricularStage.APPROVED) continue;
                for (CurricularCourse curricularCourse : competenceCourse.getAssociatedCurricularCoursesSet()) {
                    for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                        ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
                        for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                            if (!degreeModuleScope.isActiveForExecutionPeriod(executionSemester)) continue;
                            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
                            Spreadsheet.Row row = spreadsheet.addRow();
                            row.setCell(competenceCourse.getName(executionSemester));
                            row.setCell(degreeCurricularPlan.getName());
                            row.setCell(degreeModuleScope.getCurricularYear());
                            row.setCell(degreeModuleScope.getCurricularSemester());
                        }
                    }
                }
            }
            spreadsheet.exportToXLSSheet((OutputStream)outputStream);
            outputStream.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new FenixServiceException(e);
        }
        return null;
    }

    public List<CompetenceCourse> getDepartmentCompetenceCourses() {
        DepartmentUnit selectedDepartmentUnit = this.getPersonDepartment().getDepartmentUnit();
        if (selectedDepartmentUnit != null) {
            return selectedDepartmentUnit.getCompetenceCourses(CurricularStage.APPROVED);
        }
        return new ArrayList<CompetenceCourse>();
    }

    public Department getPersonDepartment() {
        Person person = AccessControl.getPerson();
        Teacher teacher = person == null ? null : person.getTeacher();
        return teacher == null ? null : teacher.getDepartment();
    }
}

