/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.bolonhaManager;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CompetenceCourseType;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.service.filter.BolonhaManagerAuthorizationFilter;
import org.fenixedu.academic.service.filter.ScientificCouncilAuthorizationFilter;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$1;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$2;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$3;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$4;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$5;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$6;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse$callable$runEditCompetenceCourse$7;
import org.fenixedu.academic.service.services.exceptions.ExistingCompetenceCourseInformationException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.util.StringFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EditCompetenceCourse {
    private static final EditCompetenceCourse serviceInstance;
    public static final Advice advice$runEditCompetenceCourse;
    public static final Advice advice$runEditCompetenceCourse$1;
    public static final Advice advice$runEditCompetenceCourse$2;
    public static final Advice advice$runEditCompetenceCourse$3;
    public static final Advice advice$runEditCompetenceCourse$4;
    public static final Advice advice$runEditCompetenceCourse$5;
    public static final Advice advice$runEditCompetenceCourse$6;
    public static final Advice advice$runEditCompetenceCourse$7;

    protected void run(String competenceCourseID, String objectives, String program, String evaluationMethod, String objectivesEn, String programEn, String evaluationMethodEn) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.edit(objectives, program, evaluationMethod, objectivesEn, programEn, evaluationMethodEn);
    }

    protected void run(String competenceCourseID, String name, String nameEn, Boolean basic, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType type, CurricularStage curricularStage, String code) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        this.checkIfCanEditCompetenceCourse(competenceCourse, name.trim(), nameEn.trim(), code);
        competenceCourse.edit(name, nameEn, basic, competenceCourseLevel, type, curricularStage);
        competenceCourse.setCode(code);
    }

    protected void run(String competenceCourseID, String acronym) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.editAcronym(acronym);
    }

    protected void run(String competenceCourseID, CurricularStage curricularStage) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.changeCurricularStage(curricularStage);
    }

    protected void run(String competenceCourseID, String year, String title, String authors, String reference, BibliographicReferences.BibliographicReferenceType bibliographicReferenceType, String url) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.createBibliographicReference(year, title, authors, reference, this.buildUrl(url), bibliographicReferenceType);
    }

    protected void run(String competenceCourseID, Integer bibliographicReferenceID, String year, String title, String authors, String reference, BibliographicReferences.BibliographicReferenceType bibliographicReferenceType, String url) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.editBibliographicReference(bibliographicReferenceID, year, title, authors, reference, this.buildUrl(url), bibliographicReferenceType);
    }

    protected void run(String competenceCourseID, Integer bibliographicReferenceID) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.deleteBibliographicReference(bibliographicReferenceID);
    }

    protected void run(String competenceCourseID, Integer oldPosition, Integer newPosition) throws FenixServiceException {
        CompetenceCourse competenceCourse = this.readCompetenceCourse(competenceCourseID);
        competenceCourse.switchBibliographicReferencePosition(oldPosition, newPosition);
    }

    private CompetenceCourse readCompetenceCourse(String competenceCourseID) throws FenixServiceException {
        CompetenceCourse competenceCourse = (CompetenceCourse)FenixFramework.getDomainObject((String)competenceCourseID);
        if (competenceCourse == null) {
            throw new FenixServiceException("error.noCompetenceCourse");
        }
        return competenceCourse;
    }

    private String buildUrl(String url) {
        String httpString = "http://";
        return !url.startsWith("http://") ? "http://" + url : url;
    }

    private void checkIfCanEditCompetenceCourse(CompetenceCourse competenceCourseToEdit, String name, String nameEn, String code) throws FenixServiceException {
        String normalizedName = StringFormatter.normalize(name);
        String normalizedNameEn = StringFormatter.normalize(nameEn);
        for (CompetenceCourse competenceCourse : CompetenceCourse.readBolonhaCompetenceCourses()) {
            if (competenceCourse == competenceCourseToEdit) continue;
            boolean sameCode = Objects.equals(code, competenceCourse.getCode());
            if (StringFormatter.normalize(competenceCourse.getName()) != null && StringFormatter.normalize(competenceCourse.getName()).equals(normalizedName) && sameCode) {
                throw new ExistingCompetenceCourseInformationException("error.existingCompetenceCourseWithSameName", competenceCourse.getDepartmentUnit().getName());
            }
            if (StringFormatter.normalize(competenceCourse.getNameEn()) == null || !StringFormatter.normalize(competenceCourse.getNameEn()).equals(normalizedNameEn) || !sameCode) continue;
            throw new ExistingCompetenceCourseInformationException("error.existingCompetenceCourseWithSameNameEn", competenceCourse.getDepartmentUnit().getName());
        }
    }

    public static void runEditCompetenceCourse(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runEditCompetenceCourse.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse(string, string2, string3, string4, string5, string6, string7));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, String objectives, String program, String evaluationMethod, String objectivesEn, String programEn, String evaluationMethodEn) throws FenixServiceException, NotAuthorizedException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, objectives, program, evaluationMethod, objectivesEn, programEn, evaluationMethodEn);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, objectives, program, evaluationMethod, objectivesEn, programEn, evaluationMethodEn);
        }
    }

    public static void runEditCompetenceCourse(String string, CurricularStage curricularStage) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runEditCompetenceCourse$1.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$1(string, curricularStage));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, CurricularStage curricularStage) throws FenixServiceException, NotAuthorizedException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, curricularStage);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, curricularStage);
        }
    }

    public static void runEditCompetenceCourse(String string, String string2) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runEditCompetenceCourse$2.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$2(string, string2));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, String acronym) throws FenixServiceException, NotAuthorizedException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, acronym);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, acronym);
        }
    }

    public static void runEditCompetenceCourse(String string, String string2, String string3, String string4, String string5, BibliographicReferences.BibliographicReferenceType bibliographicReferenceType, String string6) throws FenixServiceException {
        Object object = advice$runEditCompetenceCourse$3.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$3(string, string2, string3, string4, string5, bibliographicReferenceType, string6));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, String year, String title, String author, String reference, BibliographicReferences.BibliographicReferenceType valueOf, String url) throws FenixServiceException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, year, title, author, reference, valueOf, url);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, year, title, author, reference, valueOf, url);
        }
    }

    public static void runEditCompetenceCourse(String string, Integer n, String string2, String string3, String string4, String string5, BibliographicReferences.BibliographicReferenceType bibliographicReferenceType, String string6) throws FenixServiceException {
        Object object = advice$runEditCompetenceCourse$4.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$4(string, n, string2, string3, string4, string5, bibliographicReferenceType, string6));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, Integer bibliographicReferenceID, String year, String title, String author, String reference, BibliographicReferences.BibliographicReferenceType valueOf, String url) throws FenixServiceException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, bibliographicReferenceID, year, title, author, reference, valueOf, url);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, bibliographicReferenceID, year, title, author, reference, valueOf, url);
        }
    }

    public static void runEditCompetenceCourse(String string, Integer n) throws FenixServiceException {
        Object object = advice$runEditCompetenceCourse$5.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$5(string, n));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, Integer bibliographicReferenceIDToDelete) throws FenixServiceException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, bibliographicReferenceIDToDelete);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, bibliographicReferenceIDToDelete);
        }
    }

    public static void runEditCompetenceCourse(String string, Integer n, Integer n2) throws FenixServiceException {
        Object object = advice$runEditCompetenceCourse$6.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$6(string, n, n2));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, Integer oldPosition, Integer newPosition) throws FenixServiceException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, oldPosition, newPosition);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, oldPosition, newPosition);
        }
    }

    public static void runEditCompetenceCourse(String string, String string2, String string3, Boolean bl, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType competenceCourseType, CurricularStage curricularStage, String string4) throws FenixServiceException {
        Object object = advice$runEditCompetenceCourse$7.perform((Callable)new EditCompetenceCourse$callable$runEditCompetenceCourse$7(string, string2, string3, bl, competenceCourseLevel, competenceCourseType, curricularStage, string4));
    }

    static /* synthetic */ void advised$runEditCompetenceCourse(String competenceCourseID, String name, String nameEn, Boolean basic, CompetenceCourseLevel enumCompetenceCourseLevel, CompetenceCourseType enumCompetenceCourseType, CurricularStage valueOf, String code) throws FenixServiceException {
        try {
            BolonhaManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, name, nameEn, basic, enumCompetenceCourseLevel, enumCompetenceCourseType, valueOf, code);
        }
        catch (NotAuthorizedException ex1) {
            ScientificCouncilAuthorizationFilter.instance.execute();
            serviceInstance.run(competenceCourseID, name, nameEn, basic, enumCompetenceCourseLevel, enumCompetenceCourseType, valueOf, code);
        }
    }

    static {
        advice$runEditCompetenceCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$3 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$4 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$5 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$6 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditCompetenceCourse$7 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new EditCompetenceCourse();
    }
}

