/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class StudentPredicates {
    public static final AccessControlPredicate<Student> checkIfLoggedPersonIsStudentOwnerOrManager = new AccessControlPredicate<Student>(){

        @Override
        public boolean evaluate(Student student) {
            Person person = AccessControl.getPerson();
            return person.getStudent() == student || RoleType.MANAGER.isMember(person.getUser());
        }
    };
    public static final AccessControlPredicate<Student> checkIfLoggedPersonIsCoordinator = new AccessControlPredicate<Student>(){

        @Override
        public boolean evaluate(Student student) {
            return RoleType.COORDINATOR.isMember(AccessControl.getPerson().getUser());
        }
    };
}

