/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.math.BigDecimal;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public interface ICurriculumEntry {
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_ID = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            return o1.getExternalId().compareTo(o2.getExternalId());
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_PERIOD = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            ExecutionSemester e1 = o1.getExecutionPeriod();
            ExecutionSemester e2 = o2.getExecutionPeriod();
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            return e1.compareTo(e2);
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_PERIOD_AND_ID = new Comparator<ICurriculumEntry>(){

        @Override
        public final int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_EXECUTION_PERIOD);
            comparatorChain.addComparator(COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_REVERSE_EXECUTION_PERIOD_AND_NAME = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            int result = COMPARATOR_BY_EXECUTION_PERIOD.compare(o2, o1);
            return result == 0 ? o1.getName().compareTo(o2.getName()) : result;
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            int result = COMPARATOR_BY_EXECUTION_PERIOD.compare(o1, o2);
            return result == 0 ? o1.getName().compareTo(o2.getName()) : result;
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID = new Comparator<ICurriculumEntry>(){

        @Override
        public final int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME);
            comparatorChain.addComparator(COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_REVERSE_EXECUTION_PERIOD_AND_NAME_AND_ID = new Comparator<ICurriculumEntry>(){

        @Override
        public final int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_REVERSE_EXECUTION_PERIOD_AND_NAME);
            comparatorChain.addComparator(COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_YEAR = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            ExecutionYear e1 = o1.getExecutionYear();
            ExecutionYear e2 = o2.getExecutionYear();
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            return e1.compareTo(e2);
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_YEAR_AND_NAME = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            int result = COMPARATOR_BY_EXECUTION_YEAR.compare(o1, o2);
            return result == 0 ? o1.getName().compareTo(o2.getName()) : result;
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_EXECUTION_YEAR_AND_NAME_AND_ID = new Comparator<ICurriculumEntry>(){

        @Override
        public final int compare(ICurriculumEntry o1, ICurriculumEntry o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_EXECUTION_YEAR_AND_NAME);
            comparatorChain.addComparator(COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    public static final Comparator<ICurriculumEntry> COMPARATOR_BY_APPROVEMENT_DATE = new Comparator<ICurriculumEntry>(){

        @Override
        public int compare(ICurriculumEntry curriculumEntry1, ICurriculumEntry curriculumEntry2) {
            YearMonthDay localDate2;
            YearMonthDay localDate1 = curriculumEntry1.getApprovementDate();
            int c = localDate1.compareTo((ReadablePartial)(localDate2 = curriculumEntry2.getApprovementDate()));
            return c == 0 ? COMPARATOR_BY_ID.compare(curriculumEntry1, curriculumEntry2) : c;
        }
    };

    public String getExternalId();

    public String getCode();

    public MultiLanguageString getName();

    public MultiLanguageString getPresentationName();

    public Grade getGrade();

    public String getGradeValue();

    public BigDecimal getWeigthForCurriculum();

    public BigDecimal getEctsCreditsForCurriculum();

    public ExecutionSemester getExecutionPeriod();

    public boolean hasExecutionPeriod();

    public ExecutionYear getExecutionYear();

    public DateTime getCreationDateDateTime();

    public YearMonthDay getApprovementDate();
}

