/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.bennu.core.domain.User;

public class RequestPublicThesisPresentation
extends PhdIndividualProgramProcessActivity {
    @Override
    protected void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (process2.getSeminarProcess() == null || !process2.getSeminarProcess().isExempted() && !process2.getSeminarProcess().isConcluded()) {
            throw new PreConditionNotValidException();
        }
        if (process2.getThesisProcess() != null || process2.getActiveState() != PhdIndividualProgramProcessState.WORK_DEVELOPMENT) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess individualProcess, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        bean.setProcess(individualProcess);
        Process.createNewProcess(userView, PhdThesisProcess.class, (Object)bean);
        individualProcess.createState(PhdIndividualProgramProcessState.THESIS_DISCUSSION, userView.getPerson(), "");
        return individualProcess;
    }
}

