/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EquivalencePlan;
import org.fenixedu.academic.domain.EquivalencePlanEntry;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.PrecedenceRule;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CurricularCourseFunctor;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.core.AbstractDomainObject;

public abstract class DegreeModule
extends DegreeModule_Base {
    public static final Comparator<DegreeModule> COMPARATOR_BY_NAME = Comparator.comparing(DegreeModule::getNameI18N).thenComparing(AbstractDomainObject::getExternalId);
    private static final String FULL_NAME_SEPARATOR = " > ";

    public DegreeModule() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected void getOneFullName(StringBuilder result, ExecutionSemester executionSemester) {
        String selfName = this.getNameI18N(executionSemester).getContent();
        if (this.isRoot()) {
            result.append(selfName);
        } else {
            Collection<Context> parentContextsByExecutionPeriod = this.getParentContextsByExecutionSemester(executionSemester);
            if (parentContextsByExecutionPeriod.isEmpty()) {
                parentContextsByExecutionPeriod = this.getParentContextsSet();
            }
            CourseGroup parentCourseGroup = ((Context)parentContextsByExecutionPeriod.iterator().next()).getParentCourseGroup();
            parentCourseGroup.getOneFullName(result, executionSemester);
            result.append(FULL_NAME_SEPARATOR);
            result.append(selfName);
        }
    }

    public String getOneFullName(ExecutionSemester executionSemester) {
        StringBuilder result = new StringBuilder();
        this.getOneFullName(result, executionSemester);
        return result.toString();
    }

    public String getOneFullName() {
        return this.getOneFullName(null);
    }

    public String getOneFullNameI18N(Locale language) {
        return this.getOneFullNameI18N(null, language);
    }

    public String getOneFullNameI18N(ExecutionSemester executionSemester, Locale language) {
        StringBuilder result = new StringBuilder();
        this.getOneFullNameI18N(result, executionSemester, language);
        return result.toString();
    }

    protected void getOneFullNameI18N(StringBuilder result, ExecutionSemester executionSemester, Locale language) {
        String selfName = this.getNameI18N(executionSemester).getContent(language);
        if (this.isRoot()) {
            result.append(selfName);
        } else {
            Collection<Context> parentContextsByExecutionPeriod = this.getParentContextsByExecutionSemester(executionSemester);
            if (parentContextsByExecutionPeriod.isEmpty()) {
                parentContextsByExecutionPeriod = this.getParentContextsSet();
            }
            CourseGroup parentCourseGroup = ((Context)parentContextsByExecutionPeriod.iterator().next()).getParentCourseGroup();
            parentCourseGroup.getOneFullNameI18N(result, executionSemester, language);
            result.append(FULL_NAME_SEPARATOR);
            result.append(selfName);
        }
    }

    public MultiLanguageString getNameI18N(ExecutionSemester executionSemester) {
        String nameEn;
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        String name = this.getName(executionSemester);
        if (name != null && name.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, name);
        }
        if ((nameEn = this.getNameEn(executionSemester)) != null && nameEn.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, nameEn);
        }
        return multiLanguageString;
    }

    public MultiLanguageString getNameI18N(ExecutionYear executionYear) {
        return this.getNameI18N(executionYear == null ? null : executionYear.getLastExecutionPeriod());
    }

    public MultiLanguageString getNameI18N() {
        return this.getNameI18N((ExecutionSemester)null);
    }

    protected String getName(ExecutionSemester executionSemester) {
        return this.getName();
    }

    protected String getNameEn(ExecutionSemester executionSemester) {
        return this.getNameEn();
    }

    public MultiLanguageString getNameI18N(ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionSemester) {
            return this.getNameI18N((ExecutionSemester)((Object)executionInterval));
        }
        if (executionInterval instanceof ExecutionYear) {
            return this.getNameI18N((ExecutionYear)((Object)executionInterval));
        }
        if (executionInterval == null) {
            return this.getNameI18N((ExecutionSemester)null);
        }
        throw new DomainException("error.DegreeModule.getNameI18N.does.not.support.provided.executionInterval.type", ((Object)((Object)executionInterval)).getClass().getName());
    }

    public void delete() {
        if (this.getCanBeDeleted().booleanValue()) {
            while (!this.getParentContextsSet().isEmpty()) {
                ((Context)this.getParentContextsSet().iterator().next()).delete();
            }
            while (!this.getCurricularRulesSet().isEmpty()) {
                ((CurricularRule)this.getCurricularRulesSet().iterator().next()).delete();
            }
            while (!this.getParticipatingPrecedenceCurricularRulesSet().isEmpty()) {
                ((PrecedenceRule)((Object)this.getParticipatingPrecedenceCurricularRulesSet().iterator().next())).delete();
            }
            while (!this.getParticipatingExclusivenessCurricularRulesSet().isEmpty()) {
                ((Exclusiveness)((Object)this.getParticipatingExclusivenessCurricularRulesSet().iterator().next())).delete();
            }
        } else {
            throw new DomainException("courseGroup.notEmptyCurriculumModules", new String[0]);
        }
    }

    protected Boolean getCanBeDeleted() {
        return this.getCurriculumModulesSet().isEmpty();
    }

    public void deleteContext(Context context) {
        if (this.getParentContextsSet().contains(context)) {
            context.delete();
        }
        if (this.getParentContextsSet().isEmpty()) {
            this.delete();
        }
    }

    public Set<CourseGroup> getAllParentCourseGroups() {
        HashSet<CourseGroup> result = new HashSet<CourseGroup>();
        this.collectParentCourseGroups(result, this);
        return result;
    }

    private void collectParentCourseGroups(Set<CourseGroup> result, DegreeModule module) {
        for (Context parent : module.getParentContextsSet()) {
            if (parent.getParentCourseGroup().isRoot()) continue;
            result.add(parent.getParentCourseGroup());
            this.collectParentCourseGroups(result, (DegreeModule)((Object)parent.getParentCourseGroup()));
        }
    }

    public List<CurricularRule> getParticipatingCurricularRules() {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        result.addAll(this.getParticipatingPrecedenceCurricularRulesSet());
        result.addAll(this.getParticipatingExclusivenessCurricularRulesSet());
        return result;
    }

    public List<CurricularRule> getCurricularRules(ExecutionYear executionYear) {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!this.isCurricularRuleValid((ICurricularRule)curricularRule, executionYear)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public List<CurricularRule> getCurricularRules(ExecutionSemester executionSemester) {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!this.isCurricularRuleValid((ICurricularRule)curricularRule, executionSemester)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public List<CurricularRule> getVisibleCurricularRules(ExecutionYear executionYear) {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.isVisible() || executionYear != null && !curricularRule.isValid(executionYear)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public List<CurricularRule> getVisibleCurricularRules(ExecutionSemester executionSemester) {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.isVisible() || !this.isCurricularRuleValid((ICurricularRule)curricularRule, executionSemester)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public List<CurricularRule> getCurricularRules(Context context, ExecutionSemester executionSemester) {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!this.isCurricularRuleValid((ICurricularRule)curricularRule, executionSemester) || !curricularRule.appliesToContext(context)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    private boolean isCurricularRuleValid(ICurricularRule curricularRule, ExecutionSemester executionSemester) {
        return executionSemester == null || curricularRule.isValid(executionSemester);
    }

    private boolean isCurricularRuleValid(ICurricularRule curricularRule, ExecutionYear executionYear) {
        return executionYear == null || curricularRule.isValid(executionYear);
    }

    public List<Context> getParentContextsByExecutionYear(ExecutionYear executionYear) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getParentContextsSet()) {
            if (executionYear != null && !context.isValid(executionYear)) continue;
            result.add(context);
        }
        return result;
    }

    public List<Context> getParentContextsByExecutionSemester(ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getParentContextsSet()) {
            if (executionSemester != null && !context.isValid(executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public List<Context> getParentContextsBy(ExecutionSemester executionSemester, CourseGroup parentCourseGroup) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getParentContextsSet()) {
            if (!context.isValid(executionSemester) || context.getParentCourseGroup() != parentCourseGroup) continue;
            result.add(context);
        }
        return result;
    }

    public boolean hasAnyParentContexts(ExecutionSemester executionSemester) {
        for (Context context : this.getParentContextsSet()) {
            if (executionSemester != null && !context.isValid(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyOpenParentContexts(ExecutionSemester executionSemester) {
        for (Context context : this.getParentContextsSet()) {
            if (executionSemester != null && !context.isOpen(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isBolonhaDegree() {
        return this.getParentDegreeCurricularPlan().isBolonhaDegree();
    }

    public boolean isOptional() {
        return false;
    }

    public boolean isBranchCourseGroup() {
        return false;
    }

    public boolean isCycleCourseGroup() {
        return false;
    }

    public boolean isCurricularCourse() {
        return false;
    }

    public boolean isCourseGroup() {
        return false;
    }

    public Degree getDegree() {
        return this.getParentDegreeCurricularPlan().getDegree();
    }

    public DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public boolean hasOnlyOneParentCourseGroup() {
        return this.hasOnlyOneParentCourseGroup(null);
    }

    public boolean hasOnlyOneParentCourseGroup(ExecutionSemester executionSemester) {
        CourseGroup degreeModule = null;
        for (Context context : this.getParentContextsByExecutionSemester(executionSemester)) {
            if (degreeModule == null) {
                degreeModule = context.getParentCourseGroup();
                continue;
            }
            if (degreeModule == context.getParentCourseGroup()) continue;
            return false;
        }
        return true;
    }

    public List<? extends ICurricularRule> getCurricularRules(CurricularRuleType ruleType, ExecutionSemester executionSemester) {
        ArrayList<ICurricularRule> result = new ArrayList<ICurricularRule>();
        for (ICurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.hasCurricularRuleType(ruleType) || !this.isCurricularRuleValid(curricularRule, executionSemester)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public boolean hasAnyCurricularRules(CurricularRuleType ruleType, ExecutionSemester executionSemester) {
        for (ICurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.hasCurricularRuleType(ruleType) || !this.isCurricularRuleValid(curricularRule, executionSemester)) continue;
            return true;
        }
        return false;
    }

    public List<? extends ICurricularRule> getCurricularRules(CurricularRuleType ruleType, ExecutionYear executionYear) {
        ArrayList<ICurricularRule> result = new ArrayList<ICurricularRule>();
        for (ICurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.hasCurricularRuleType(ruleType) || !this.isCurricularRuleValid(curricularRule, executionYear)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public List<? extends ICurricularRule> getCurricularRules(CurricularRuleType ruleType, CourseGroup parentCourseGroup, ExecutionYear executionYear) {
        ArrayList<ICurricularRule> result = new ArrayList<ICurricularRule>();
        for (ICurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.hasCurricularRuleType(ruleType) || !this.isCurricularRuleValid(curricularRule, executionYear) || !curricularRule.appliesToCourseGroup(parentCourseGroup)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public List<? extends ICurricularRule> getCurricularRules(CurricularRuleType ruleType, CourseGroup parentCourseGroup, ExecutionSemester executionSemester) {
        ArrayList<ICurricularRule> result = new ArrayList<ICurricularRule>();
        for (ICurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.hasCurricularRuleType(ruleType) || !this.isCurricularRuleValid(curricularRule, executionSemester) || !curricularRule.appliesToCourseGroup(parentCourseGroup)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    public ICurricularRule getMostRecentActiveCurricularRule(CurricularRuleType ruleType, CourseGroup parentCourseGroup, ExecutionYear executionYear) {
        ArrayList<? extends ICurricularRule> curricularRules = new ArrayList<ICurricularRule>(this.getCurricularRules(ruleType, parentCourseGroup, (ExecutionYear)null));
        Collections.sort(curricularRules, ICurricularRule.COMPARATOR_BY_BEGIN);
        if (curricularRules.isEmpty()) {
            return null;
        }
        if (executionYear == null) {
            ListIterator iter = curricularRules.listIterator(curricularRules.size());
            while (iter.hasPrevious()) {
                ICurricularRule curricularRule = (ICurricularRule)iter.previous();
                if (!curricularRule.isActive()) continue;
                return curricularRule;
            }
            return null;
        }
        ICurricularRule result = null;
        for (ICurricularRule iCurricularRule : curricularRules) {
            if (!iCurricularRule.isValid(executionYear)) continue;
            if (result != null) {
                throw new DomainException("error.degree.module.has.more.than.one.credits.limit.for.executionYear", this.getName());
            }
            result = iCurricularRule;
        }
        return result;
    }

    public ICurricularRule getMostRecentActiveCurricularRule(CurricularRuleType ruleType, CourseGroup parentCourseGroup, ExecutionSemester executionSemester) {
        ArrayList<? extends ICurricularRule> curricularRules = new ArrayList<ICurricularRule>(this.getCurricularRules(ruleType, parentCourseGroup, executionSemester));
        if (curricularRules.isEmpty()) {
            return null;
        }
        ICurricularRule result = null;
        for (ICurricularRule iCurricularRule : curricularRules) {
            if (!iCurricularRule.isValid(executionSemester)) continue;
            if (result != null) {
                throw new DomainException("error.degree.module.has.more.than.one.credits.limit.for.executionPeriod", this.getName());
            }
            result = iCurricularRule;
        }
        return result;
    }

    public Double getMaxEctsCredits() {
        return this.getMaxEctsCredits(ExecutionSemester.readActualExecutionSemester());
    }

    public Double getMinEctsCredits() {
        return this.getMinEctsCredits(ExecutionSemester.readActualExecutionSemester());
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        return this.equals((Object)degreeModule);
    }

    public ExecutionSemester getMinimumExecutionPeriod() {
        if (this.isRoot()) {
            return this.isBolonhaDegree() ? this.getBeginBolonhaExecutionPeriod() : this.getFirstExecutionPeriodOfFirstExecutionDegree();
        }
        TreeSet<ExecutionSemester> executionSemesters = new TreeSet<ExecutionSemester>();
        for (Context context : this.getParentContextsSet()) {
            executionSemesters.add(context.getBeginExecutionPeriod());
        }
        return (ExecutionSemester)executionSemesters.first();
    }

    public ExecutionSemester getBeginBolonhaExecutionPeriod() {
        return ExecutionSemester.readFirstBolonhaExecutionPeriod();
    }

    private ExecutionSemester getFirstExecutionPeriodOfFirstExecutionDegree() {
        ExecutionDegree executionDegree = this.getParentDegreeCurricularPlan().getFirstExecutionDegree();
        return executionDegree != null ? executionDegree.getExecutionYear().getFirstExecutionPeriod() : this.getBeginBolonhaExecutionPeriod();
    }

    public DegreeModulesSelectionLimit getDegreeModulesSelectionLimitRule(ExecutionSemester executionSemester) {
        List<? extends ICurricularRule> result = this.getCurricularRules(CurricularRuleType.DEGREE_MODULES_SELECTION_LIMIT, executionSemester);
        return result.isEmpty() ? null : (DegreeModulesSelectionLimit)((Object)result.iterator().next());
    }

    public CreditsLimit getCreditsLimitRule(ExecutionSemester executionSemester) {
        List<? extends ICurricularRule> result = this.getCurricularRules(CurricularRuleType.CREDITS_LIMIT, executionSemester);
        return result.isEmpty() ? null : (CreditsLimit)((Object)result.iterator().next());
    }

    public List<Exclusiveness> getExclusivenessRules(ExecutionSemester executionSemester) {
        return this.getCurricularRules(CurricularRuleType.EXCLUSIVENESS, executionSemester);
    }

    public Set<EquivalencePlanEntry> getNewDegreeModuleEquivalencePlanEntries(EquivalencePlan equivalencePlan) {
        TreeSet<EquivalencePlanEntry> equivalencePlanEntries = new TreeSet<EquivalencePlanEntry>(EquivalencePlanEntry.COMPARATOR);
        for (EquivalencePlanEntry equivalencePlanEntry : this.getNewEquivalencePlanEntriesSet()) {
            if (equivalencePlanEntry.getEquivalencePlan() != equivalencePlan) continue;
            equivalencePlanEntries.add(equivalencePlanEntry);
        }
        return equivalencePlanEntries;
    }

    public Collection<CycleCourseGroup> getParentCycleCourseGroups() {
        HashSet<CycleCourseGroup> res = new HashSet<CycleCourseGroup>();
        for (CourseGroup courseGroup : this.getParentCourseGroups()) {
            res.addAll(courseGroup.getParentCycleCourseGroups());
        }
        return res;
    }

    public Set<CourseGroup> getParentCourseGroups() {
        HashSet<CourseGroup> res = new HashSet<CourseGroup>();
        for (Context context : this.getParentContextsSet()) {
            res.add(context.getParentCourseGroup());
        }
        return res;
    }

    public boolean isDissertation() {
        return false;
    }

    public abstract DegreeCurricularPlan getParentDegreeCurricularPlan();

    public abstract void print(StringBuilder var1, String var2, Context var3);

    public abstract boolean isLeaf();

    public abstract boolean isRoot();

    public abstract Double getMaxEctsCredits(ExecutionSemester var1);

    public abstract Double getMinEctsCredits(ExecutionSemester var1);

    public abstract void getAllDegreeModules(Collection<DegreeModule> var1);

    public abstract Set<CurricularCourse> getAllCurricularCourses(ExecutionSemester var1);

    public abstract Set<CurricularCourse> getAllCurricularCourses();

    public abstract void doForAllCurricularCourses(CurricularCourseFunctor var1);

    public abstract void applyToCurricularCourses(ExecutionYear var1, Predicate var2);

    public boolean isOptionalCourseGroup() {
        return false;
    }

    public static class ComparatorByMinEcts
    implements Comparator<DegreeModule> {
        private final ExecutionSemester executionSemester;

        public ComparatorByMinEcts(ExecutionSemester executionSemester) {
            this.executionSemester = executionSemester;
        }

        @Override
        public int compare(DegreeModule leftDegreeModule, DegreeModule rightDegreeModule) {
            int comparationResult = leftDegreeModule.getMinEctsCredits(this.executionSemester).compareTo(rightDegreeModule.getMinEctsCredits(this.executionSemester));
            return comparationResult == 0 ? leftDegreeModule.getExternalId().compareTo(rightDegreeModule.getExternalId()) : comparationResult;
        }
    }
}

