/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.RestrictionDoneDegreeModule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.RestrictionDoneDegreeModuleVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.fenixedu.academic.dto.GenericPair;

public class RestrictionDoneDegreeModule
extends RestrictionDoneDegreeModule_Base {
    private RestrictionDoneDegreeModule(DegreeModule done) {
        if (done == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        this.setPrecedenceDegreeModule(done);
        this.setCurricularRuleType(CurricularRuleType.PRECEDENCY_APPROVED_DEGREE_MODULE);
    }

    public RestrictionDoneDegreeModule(CurricularCourse toApply, CurricularCourse done, CourseGroup contextCourseGroup, CurricularPeriodInfoDTO curricularPeriodInfoDTO, ExecutionSemester begin, ExecutionSemester end) {
        this((DegreeModule)((Object)done));
        this.init((DegreeModule)((Object)toApply), contextCourseGroup, begin, end);
        if (curricularPeriodInfoDTO != null) {
            this.setAcademicPeriod(curricularPeriodInfoDTO.getPeriodType());
            this.setCurricularPeriodOrder(curricularPeriodInfoDTO.getOrder());
        }
    }

    public CurricularCourse getDegreeModuleToApplyRule() {
        return (CurricularCourse)((Object)super.getDegreeModuleToApplyRule());
    }

    public CurricularCourse getPrecedenceDegreeModule() {
        return (CurricularCourse)((Object)super.getPrecedenceDegreeModule());
    }

    protected void edit(DegreeModule done, CourseGroup contextCourseGroup, CurricularPeriodInfoDTO curricularPeriodInfoDTO) {
        this.setPrecedenceDegreeModule(done);
        this.setContextCourseGroup(contextCourseGroup);
        this.setAcademicPeriod(curricularPeriodInfoDTO.getPeriodType());
        this.setCurricularPeriodOrder(curricularPeriodInfoDTO.getOrder());
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        if (this.belongsToCompositeRule() && this.getParentCompositeRule().getCompositeRuleType().equals((Object)LogicOperator.NOT)) {
            labelList.add(new GenericPair<String, Boolean>("label.precedenceNotDone", true));
        } else {
            labelList.add(new GenericPair<String, Boolean>("label.precedenceDone", true));
        }
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        String precedenceDegreeModule = this.getPrecedenceDegreeModule().isLeaf() ? this.getPrecedenceDegreeModule().getName() : this.getPrecedenceDegreeModule().getOneFullName();
        labelList.add(new GenericPair<String, Boolean>(precedenceDegreeModule, false));
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inContext", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        if (!this.hasNoCurricularPeriodOrder()) {
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.and", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.in", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getAcademicPeriod().getName(), true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getCurricularPeriodOrder(), false));
        }
        return labelList;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new RestrictionDoneDegreeModuleVerifier();
    }
}

